/***********************
Red Connect Console Program - CCCP 
Author: hampa@chello.se
Licence: GPL
Version: 0.5
This is a frontend to Direct Connect Text Client
************************/
#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <dirent.h>
#include <stdarg.h>
#include <libgen.h>
#include <wait.h>


#define MAXMSG 4096 
#define NUM_OPTS 50

//return error codes
#define ERR_DCTC_SOCKET_CLOSED 	100
#define ERR_NO_DCTC_FOUND			101 
#define ERR_BAD_INPUT_PARAMS		102
#define ERR_SOCKET_ERROR			103
#define ERR_BAD_SWITCHES			104

extern int errno;
extern int opterr;
time_t last_output_time;
int dctc_timeout;
int dctc_filetype = 0;
int fd;
int num_dctc_clients = 0;
char dctc_clients[128][128];
void sig_alrm();
void sig_int(int);
static void sig_usr(int signo);
void TELL_WAIT();
void TELL_PARENT(pid_t pid);
void TELL_CHILD(pid_t pid);
void WAIT_CHILD();
void WAIT_PARENT(void);
int parent_is_signaled = 0;

void fill_running_hub_list(char *s);
void usage();
int clean_dctc_string(char *cleaned, char *dirty);
int dctc_srv_index =0;
//void time_stamped_printf(int newline, char *s);
int timestamp_printf (const char *format, ...);


int Sflag = 0; //TimeStamp flag
int SCflag = 0; //TimeStamp Clock format
pid_t pid;

//signals
static volatile sig_atomic_t	sigflag;
static sigset_t			newmask, oldmask, zeromask;

int main(int argc, char **argv){

	struct sockaddr_un name;
	int status = 0;
	int a;
	int n;
	int sock;
	int oflag = 0; //output to stdout
	int Oflag = 0; //no output - just send commands
	int Cflag = 0; //send command only flag
	int cflag = 0; //send chat message
	int lflag = 0; //list user  - /ULIST
	int qflag = 0; //queue flag - /XFER
	int sflag = 0; //search flag
	int mflag = 0; //multi hub search flag
	int xflag = 0; //wait for dl then make dctc client exit
	int Xflag = 0; //force dctc client to exit without waiting for dl to finnish
	int pflag = 0; //private message flag
	int rflag = 0; //raw output flag 
	int dflag = 0; //download 
	int uflag = 0; //List USERS 
	int hflag = 0; //help - show usage
	int Hflag = 0; //Hub to connect to
	int Lflag = 0; //Hub LIST flag
	int kflag = 0; //kill flag - kill transfer 
	int nflag = 0; //user iNfo flag
	int Nflag = 0; //No error flag
	int Tflag = 0; //Timeout flag
	int tflag = 0; //Transfer flag
	//group dl
	int gqflag = 0; //group quick list
	int glflag = 0; //group list 
	int gaflag = 0; //group add
	int gnflag = 0; //group new
	int gdflag = 0; //group delete
	int geflag = 0; //group end 
	
	int i;

	//char  str[MAXMSG];
	// char cmd[10];
	// char *p;
	int starttag = 0;
	int ret = 0;
	char c;
	// int nbytes = 0;
	char message[MAXMSG];
	char target[MAXMSG];
	char tmpbuf[MAXMSG];
	//char dctc_socket_path[MAXMSG];
	char dctc_command[MAXMSG];
	char dctc_server_name[MAXMSG];
	// char op;
	char optarg[128];

	//set default values
	dctc_timeout = 10;
	strcpy(dctc_server_name, "");

	if(argc < 2){
		usage();
	}

	for(i=1; i<argc; i++){
		
		//where only interessted in switches
		if(strncmp(argv[i], "-",1)){
			continue;
		}

		//save argument to optarg
		if((argv[i+1] != NULL) && (strncmp(argv[i+1], "-", 1))){
			strncpy(optarg,argv[i+1], 128);
		}
		else {
			strcpy(optarg, "");
		} 

		//fprintf(stderr, "switch %s optarg=%s\n", argv[i], optarg);
		
		if(!strcmp(argv[i], "-q")){
			strcpy(dctc_command, "/XFERKB\n");
			qflag++;
		}
		else if(!strcmp(argv[i], "-x")){
			strcpy(dctc_command, "/QUIT\n");
			xflag++;
		}
		else if(!strcmp(argv[i], "-X")){
			strcpy(dctc_command, "/QUIT_FORCE\n");
			Xflag++;
		}
		else if(!strcmp(argv[i], "-t")){
			strcpy(dctc_command, "/XFER\n");
			tflag++;
		}
		else if(!strcmp(argv[i], "-SC")){
			SCflag++;
		}
		else if(!strcmp(argv[i], "-S")){
			Sflag++;
		}
		else if(!strcmp(argv[i], "-N")){
			Nflag++;
		}
		else if(!strcmp(argv[i], "-o")){
			oflag++;
		}
		else if((!strcmp(argv[i], "-s")) || (!strcmp(argv[i], "-m"))){
			if(!strcmp(argv[i], "-m")){
				mflag++;
			}
			sflag++;
			//this switch har mandatory value
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for\n");
				exit(ERR_BAD_SWITCHES);
			}
			//raw dctc command "*file*filetype*"
			//fprintf(stderr, "%s\n", optarg);
			if(strstr(optarg, "*")){
				if(mflag){
					sprintf(dctc_command, "/MSRCH %s\n",optarg);
				}
				else {
					sprintf(dctc_command, "/SRCH %s\n",optarg);
				}
					
			}
			//usr did not specify a search command in the format
			//"*file*filetype*, lets figure out what he means
			else {
				if(mflag){
					strcpy(dctc_command, "/MSRCH *");
				}
				else {
					strcpy(dctc_command, "/SRCH *");
				}
				while(argv[++i]){
					//check if last element is a filetype	
					if(!argv[i+1])
					{
						if(atoi(argv[i]) < 1 || atoi(argv[i]) > 9)
						{
							//not a valied filetype (1-9) add 1(all)
							strcat(dctc_command, argv[i]);	
							strcat(dctc_command, "*1");
						}
						else 
						{
							dctc_command[strlen(dctc_command) - 1] = '*';
							strcat(dctc_command, argv[i]);
						}
					}
					else 
					{
						strcat(dctc_command, argv[i]);	
						strcat(dctc_command, " ");	
					}
				}
				strcat(dctc_command, "\n");
				//fprintf(stderr, "here: %s\n", argv[i-1]);
			} 
		}
		else if(!strcmp(argv[i], "-l")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -l\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/LS %s\n",optarg);
			strcpy(target, optarg);
			lflag++;
		}
		else if(!strcmp(argv[i], "-c")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -c\n");
				exit(ERR_BAD_SWITCHES);
			}
			strcat(dctc_command, "/CHAT");
			while(argv[++i]){
					strcat(dctc_command, " ");	
					strcat(dctc_command, argv[i]);	
			}
			strcat(dctc_command, "\n");
			cflag++;
		}
		else if(!strcmp(argv[i], "-p")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -p\n");
				exit(ERR_BAD_SWITCHES);
			}
			if(strstr(optarg, "*")){
				sprintf(dctc_command, "/PRIV %s\n",optarg);
			}
			else {
				//usr did not specify a DCTC command in the ** format
				sprintf(dctc_command, "/PRIV *%s*",argv[++i]);
				while(argv[++i]){
					strcat(dctc_command, argv[i]);	
					if(argv[i+1]){
						strcat(dctc_command, " ");	
					}
				}
				strcat(dctc_command, "\n");
			}
			pflag++;
		}
		else if(!strcmp(argv[i], "-k")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -k\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/KILLKBN %s\n",optarg);
			kflag++;
		}
		else if(!strcmp(argv[i], "-u")){
			strcpy(dctc_command, "/ULIST\n");
			uflag++;
		}
		else if(!strcmp(argv[i], "-n")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -n\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/UINFO %s\n",optarg);
			strcpy(target, optarg);
			nflag++;
		}
		else if(!strcmp(argv[i], "-H")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -H\n");
				exit(ERR_BAD_SWITCHES);
			}
			strcpy(dctc_server_name, optarg);
			printf("dctc_server_name=%s\n", dctc_server_name);
			Hflag++;
		}
		else if(!strcmp(argv[i], "-T")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -T\n");
				exit(ERR_BAD_SWITCHES);
			}
			dctc_timeout = atoi(optarg);
			if(dctc_timeout == 0){
				fprintf(stderr, "bad timeout %i", dctc_timeout);
				dctc_timeout = 1;
			}
			Tflag++;
		}
		else if(!strcmp(argv[i], "-L")){
			Lflag++;
		}
		else if((!strcmp(argv[i], "-h")) || (!strcmp(argv[i], "--help"))){
			hflag++;
			usage();
			exit(-1);
		}
		else if(!strcmp(argv[i], "-r")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -r\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/%s\n", optarg);
			rflag++;
		}
		else if(!strcmp(argv[i], "-O")){
			Oflag++;
		}
		else if(!strcmp(argv[i], "-d")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -d\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/DL %s\n", optarg);
			fprintf(stderr, "dctc_command dflag %s\n", dctc_command);
			dflag++;
			//parse out target
			//*nickname*asdf*asdf*adf -> nickname
			strcpy(tmpbuf, optarg);
			if(!strstr(optarg, "*")){
				usage();
			}
			i = 1;	
			do{
				target[i-1] = tmpbuf[i++];	
			}while(tmpbuf[i] != '*');
			target[i] = '\0';
		}
		//Group Download stuff
		else if(!strcmp(argv[i], "-gq")){
			strcpy(dctc_command, "/GDLQLST\n");
			 gqflag++;
		}
		else if(!strcmp(argv[i], "-gl")){
			strcpy(dctc_command, "/GDLLST\n");
			glflag++;
		}
		else if(!strcmp(argv[i], "-ge")){
			if(!strcmp(optarg, "")){
				fprintf(stderr, "error: missing option for -ge\n");
				exit(ERR_BAD_SWITCHES);
			}
			sprintf(dctc_command, "/GDLEND %s\n", optarg);
			geflag++;
		}
		else if(!strcmp(argv[i], "-gn")){
			//gdlid|filesize|filename
			if(optarg == NULL ||
				argv[i+2] == NULL ||
				argv[i+3] == NULL)
			{
				usage();
				exit(-1);
			}
			sprintf(dctc_command, "/GDLNEW %s|%s|%s\n", 
			optarg,
			argv[i+2],
			argv[i+3]);
			gnflag++;
		}
		else if(!strcmp(argv[i], "-ga")){
			//gdlid|nickname|remotefilename|remotefilesize
			if(optarg == NULL ||
				argv[i+2] == NULL ||
				argv[i+3] == NULL ||
				argv[i+4] == NULL){
				/********
				fprintf(stderr, "%s|%s|%s|%s\n", 
				optarg,
				argv[i+2],
				argv[i+3],
				argv[i+4]);
				*********/
				usage();
				exit(-1);
			}
			sprintf(dctc_command, "/GDLADD %s|%s|%s|%s\n", 
			optarg,
			argv[i+2],
			argv[i+3],
			argv[i+4]);
			gaflag++;
		}
		else if(!strcmp(argv[i], "-gd")){
			//gdlid|nickname|remotefilename
			if(optarg == NULL ||
				argv[i+2] == NULL ||
				argv[i+3] == NULL){
				usage();
				exit(-1);
			}
			sprintf(dctc_command, "/GDLDEL %s|%s|%s\n",
			optarg,
			argv[i+2],
			argv[i+3]);
			gdflag++;
		}
		else {
			fprintf(stderr, "unknown switch %s\n", argv[i]);
			//usage();
			exit(ERR_BAD_SWITCHES);
		}
	}

	if(strcmp(dctc_command, "")){
		fprintf(stderr, "dctc_command=%s", dctc_command);
	}
	
	
	//return 0;
	//certain flags have default flags.. set them now	
	if(rflag || kflag || gaflag || gnflag || geflag){
		Cflag++;
	}
	else if(	cflag || pflag || dflag || uflag || 
				lflag || sflag || qflag || tflag || 
				nflag || mflag || Hflag || 
				Xflag || xflag || 
				gqflag || glflag || 
				gdflag){
		Cflag++; //send command
		oflag++; //show output  
	}
	if(Oflag || Lflag || kflag){
		oflag = 0;
	}

	//what hubs are running in $HOME/.dtct/current/running ?
	fill_running_hub_list(dctc_server_name);

	if(num_dctc_clients == 0){
		fprintf(stderr, "did not find any running dctc clients\n");
		exit(-1);
	}

	//catch Ctrl-c
	if(signal(SIGINT, sig_int) == SIG_ERR){
		fprintf(stderr, "unable to create sig_int signal\n");
	}

	// List hubs and exit
	if(Lflag){
		for(i = 0; i < num_dctc_clients; i++){
			printf("%s\n", basename(dctc_clients[i])); 
		}
		return 0;
	}

	
	if(oflag && Cflag){
		//fprintf(stderr, "calling TELL_WAIT\n");
		TELL_WAIT();
	}

	//child process that outputs data from dctc
	if(oflag){
		fd=socket(AF_UNIX,SOCK_STREAM,0);
		if(fd==-1) {
			perror("socket");
			exit(ERR_SOCKET_ERROR);
		}
	
		name.sun_family = AF_UNIX;
		strcpy(name.sun_path, 
		dctc_clients[dctc_srv_index]);
	
		fprintf(stderr, "connecting to : %s\n", dctc_clients[dctc_srv_index]);
		a=connect(fd,(void *)&name,sizeof(struct sockaddr_un));
		if(a==-1){
			perror("connect");
			exit(-1);
		}

		if((pid = fork()) < 0){
			fprintf(stderr, "fork error\n");
			exit(-1);
		}
		else if (pid == 0){
			//fprintf(stderr, "output from child\n");
			signal(SIGALRM, sig_alrm);
			if(sflag || uflag || nflag){
				alarm(dctc_timeout);
			}
			while(1){
				memset(message, 0, MAXMSG);
				i = 0;
				if(Cflag && parent_is_signaled == 0){
					//fprintf(stderr, "calling tell_parent\n");
					parent_is_signaled++;
					TELL_PARENT(getppid());
				}
				do {
					n=read(fd,&c,1);
					if(n!=1) {
						close(fd);
						fprintf(stderr, "dctc closed my socket.. exiting\n");
						//return 0;			
						exit(ERR_DCTC_SOCKET_CLOSED);
					}
					//printf("%i=%c ", c,c );
					message[i] = c;
					i++;
				}while(c!='\n');
				
				//printf("oflag = %i got message %s\n", oflag, message);
				if(!Nflag){
					if(!strncmp(message, "ERR  ]", 6)){
						fprintf(stderr, "error : %s", message);
						//close(fd);
						//return 0;
					}
				}
				if(rflag){
					printf("%s", message);
				}
				else if(nflag){
					sprintf(tmpbuf, "UINFO] \"\"%s", target);
					//printf("tmpbuf %s message = %s", tmpbuf, message);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						clean_dctc_string(message, message);
						printf("%s\n", message);
						close(fd);
						return 0;
					}
				}
				else if(sflag){
					if(!strncmp(message,"SREST]", 6)){
						//starttag = 1;
						last_output_time = time(NULL);
						clean_dctc_string(message, message);
						printf("%s\n", message);
						//printf("s#%s", message);
					}
				}
				else if(glflag){
					if(!strncmp(message, "GLSTB]", 6)){
						starttag = 1;
						//printf("s#%s", message);
					}	
					else if(starttag == 1){
						if(!strncmp(message, "GLSTE]", 6)){
							//fprintf(stderr, "the end\n");
							close(fd);
							return 0;
						}
						else {
							if(!strncmp(message, "GLSTC]",6)) {
								clean_dctc_string(message, message);
								printf("%s\n", message);
							}
						}
					}
				}
				else if(gqflag){
					if(!strncmp(message, "GQLSB]", 6)){
						starttag = 1;
						//printf("s#%s", message);
					}	
					else if(starttag == 1){
						if(!strncmp(message, "GQLSE]", 6)){
							//fprintf(stderr, "the end\n");
							close(fd);
							return 0;
						}
						else {
							if(!strncmp(message, "GQLSC]",6)) {
								printf("%s", message);
							}
						}
					}
				}
				else if(qflag || tflag){
					if(!strncmp(message, "BXFER]", 6)){
						starttag = 1;
						//printf("s#%s", message);
					}	
					else if(starttag == 1){
						if(!strncmp(message, "EXFER]", 6)){
							//fprintf(stderr, "the end\n");
							close(fd);
							return 0;
						}
						else {
							if((!strncmp(message, "XFERQ]",6)) ||
								(!strncmp(message, "XFERR]",6)))
							{
								if(tflag){
									printf("%s", message);
								}
							}
							else if(qflag){
								printf("%s", message);
							}
						}
					}
				}
				else if(dflag){
					sprintf(tmpbuf, "$DL+ ] \"\"%s", target);
					//printf("%s\n", tmpbuf);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						printf("%s", message);
					}
					sprintf(tmpbuf, "$DL= ] \"\"%s", target);
					//printf("%s\n", tmpbuf);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						printf("%s", message);
					}
					sprintf(tmpbuf, "$DL# ] \"\"%s", target);
					//printf("%s\n", tmpbuf);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						printf("%s", message);
					}
					sprintf(tmpbuf, "$DL- ] \"\"%s", target);
					//printf("%s\n", tmpbuf);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						fprintf(stderr, "download complete %s", message);
						close(fd);
						return 0;
					}
				}
				else if(lflag){
					sprintf(tmpbuf, "FLST ] \"\"%s", target);
					if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
						starttag = 1;
						printf("%s", message);
					}
					if(starttag == 1){
						sprintf(tmpbuf, "FLSTE] \"\"%s", target);
						if(!strncmp(message, tmpbuf, strlen(tmpbuf))){
							//fprintf(stderr, "the end\n");
							close(fd);
							return 0;
						}
					}
				}
				else if(uflag){
					if(!strncmp(message, "USER ]", 6) || !strncmp(message, "OP   ]", 6)){
						starttag = 1;
						clean_dctc_string(message, message);
						printf("%s\n", message);	
					}
					else if(starttag == 1){
						//fprintf(stderr, "the end\n");
						close(fd);
						return 0;
					}
				}
				else if(cflag){
					if(!strncmp(message, "CHAT ]", 6) || !strncmp(message, "PRIV ]", 6)){
						printf("%s", message);	
					}
				}
				else if(pflag){
					if(!strncmp(message, "PRIV ]", 6)){
						printf("%s", message);	
					}
				}
				else if(oflag){
					//just output everything if only oflag
					if(Nflag){
						if(strncmp(message, "ERR  ]", 6)){
							timestamp_printf("%s", message);
						}
					}
					else {
						timestamp_printf("%s", message);
					}						

					//printf("%s", message);
					fflush(stdout);
				}
				fflush(NULL);
			}
			return 0;
		}
	}
	
	//Parent socket - parent send command to dctc and waits for child to exit
	if(Cflag){
		//make sure child has started to get output.
		//can this be done wiithout sleep?
		if(oflag){
			//fprintf(stderr, "waiting for child\n");
			WAIT_CHILD();
			//fprintf(stderr, "waiting for child done\n");
		}
		sock=socket(AF_UNIX,SOCK_STREAM,0);
		if(fd==-1) {
			perror("socket");
			//return 1;
			exit(ERR_SOCKET_ERROR);
		}
	
		name.sun_family = AF_UNIX;
		strcpy(name.sun_path, 
		dctc_clients[dctc_srv_index]);
		a=connect(sock,(void *)&name,sizeof(struct sockaddr_un));
		if(a==-1){
			perror("connect");
			exit(-1);
		}
		//fprintf(stderr, "sending data to socket\n");
		ret=send(sock,dctc_command,strlen(dctc_command) + 1,MSG_DONTWAIT);
		if(ret<0){
			perror("send");
			exit(-1);
		}
		close(sock);
	}
	//wait for child
	if(oflag){
		wait(&status) == pid;
	}


	return 0;
}

//Searches never stop. We need to poll and exit after inactivity timeout has passed
void sig_alrm(){

	time_t t;

	t = time(NULL);
	if(t - last_output_time >= dctc_timeout){
		close(fd);
		exit(0);
	}
	else {
		alarm(3);
	}
}

void sig_int(int signo){
	//fprintf(stderr, "got signal %i from pid %i\n", signo, pid);
	if(pid == 0){
		close(fd);
	}
	exit(-1);
}

int timestamp_printf (const char *format, ...) {

	va_list arg;
	int done;
	time_t timestamp;
	struct tm * timeinfo;


	if(SCflag){

		timestamp = time(NULL);
		timeinfo = localtime(&timestamp);

		printf("%02d:%02d:%02d|", 
				timeinfo->tm_hour, 
				timeinfo->tm_min, 
				timeinfo->tm_sec);

	}
	else if (Sflag){
		printf("%i|", time(NULL));
	}

	va_start (arg, format);
	done = vfprintf (stdout, format, arg);
	va_end (arg);

	return done;

}


// fills our dctc_client[] with hubs and sets num_dctc_clients
void fill_running_hub_list(char *dctc_srv){

	char *path;
	DIR *dir;
	char dctc_dir[128];
	struct dirent *obj;
	// char *ent[3];
	int a;
	// char *hn;
	//int num = 0;

	path=getenv("HOME");
	sprintf(dctc_dir, "%s/.dctc/running", (path!=NULL)?path:".");

	dir=opendir(dctc_dir);
	if(dir!=NULL){
		while((obj=readdir(dir))!=NULL){
			if(strncmp(obj->d_name,"dctc-",5))
				continue;

			//ignore UDP sockets
			a=strlen(obj->d_name);
			if((a>5)&&(!strcmp(obj->d_name+a-4,".udp")))
				continue;	

			a=strlen(obj->d_name);
			if((a>5)&&(!strcmp(obj->d_name+a-5,".done")))
				continue;	

			//found a socket
			if(num_dctc_clients<128){
		
				//printf("%s\n", dctc_srv);
				if(strstr(obj->d_name, dctc_srv)){
					//printf("found match \n");
					dctc_srv_index = num_dctc_clients;
				}		
				//strcpy(dctc_clients[num_dctc_clients],obj->d_name);
				sprintf(dctc_clients[num_dctc_clients], "%s/%s", 
				dctc_dir, obj->d_name);	
				//fprintf(stderr, "%s#\n", dctc_clients[num]);
				num_dctc_clients++;	
			}
		}
	}
	else {
		fprintf(stderr, "unable to open %s\n", dctc_dir);
		exit(-1);
	}

	closedir(dir);

	//free(dctc_dir);

}



// [xxxx] ""nick| -> nick
int clean_dctc_string(char *cleaned, char *dirty){

	char *c;

	c = strstr(dirty, "\"\"");
	if(c == NULL){
		fprintf(stderr, "clean_dctc_string: unable to find  \"\" in %s", dirty);
		return 1;
	}
	c +=2;

	strcpy(cleaned,c);
	cleaned[strlen(cleaned) - 2] = '\0';

	return 0;
}


//
static void
sig_usr(int signo)	/* one signal handler for SIGUSR1 and SIGUSR2 */
{
	sigflag = 1;
	return;
}

void
TELL_WAIT() {
	if (signal(SIGUSR1, sig_usr) == SIG_ERR){
		fprintf(stderr, "signal error\n");
		exit(-1);
	}
	if (signal(SIGUSR2, sig_usr) == SIG_ERR) {
		fprintf(stderr, "signal error\n");
		exit(-1);
	}

	sigemptyset(&zeromask);

	sigemptyset(&newmask);
	sigaddset(&newmask, SIGUSR1);
	sigaddset(&newmask, SIGUSR2);
		/* block SIGUSR1 and SIGUSR2, and save current signal mask */
	if (sigprocmask(SIG_BLOCK, &newmask, &oldmask) < 0) {
		fprintf(stderr, "signal error\n");
		exit(-1);
	}

}

void
TELL_PARENT(pid_t pid) {
	kill(pid, SIGUSR2);		/* tell parent we're done */
}

void
WAIT_PARENT(void) {
	while (sigflag == 0)
		sigsuspend(&zeromask);	/* and wait for parent */

	sigflag = 0;
			/* reset signal mask to original value */
	if (sigprocmask(SIG_SETMASK, &oldmask, NULL) < 0) {
		fprintf(stderr, "SIG_SETMASK error\n");
		exit(-1);	
	
	}	
}
void
TELL_CHILD(pid_t pid) {
	kill(pid, SIGUSR1);			/* tell child we're done */
}

void
WAIT_CHILD(void) {
	while (sigflag == 0)
		sigsuspend(&zeromask);	/* and wait for child */

	sigflag = 0;
			/* reset signal mask to original value */
	if (sigprocmask(SIG_SETMASK, &oldmask, NULL) < 0) {
		fprintf(stderr, "SIG_SETMASK error\n");
		exit(-1);	
	}
}


void usage(){

/*********************************************************************
         10        20        30        40        50        60
1234567890123456789012345678901234567890123456789012345678901234567890
*********************************************************************/
fprintf(stderr, "%s", 
"CCCP - Red Connect Console Program(v0.2)\n"
"by hampa@chello.se\n"
"usage: cccp switches [arguments]\n"
"Direct Connect switches:\n"
" -d \"*nick*[localfile]*remotefilename*[start_pos]\"\n"
"             Download from a user (nick) a file\n" 
"             (remotefile) and save it (localfile).\n"
"             If localfile is omitted, the client\n"
"             uses the current directory and the\n"
"             filename part of of remotefile. If\n"
"             start_pos is (the last * must be here)\n"
"             the client uses current file size as\n"
"             value (=resume from the end)\n"
" -s pattern [filetype]\n"
"             Search for something on the current\n"
"             hub. pattern is what you search for.\n"
"             Filetype is one of the following\n"
"             values: 1=any,2=audio,3=compressed,\n"
"             4=document,5=exe,6=picture,7=videos,\n"
"             8=folder (default=1)\n"
" -m pattern [filetype]\n"
"             Multi hub search. Same syntax as -s\n"
" -t          Display transfers\n"
" -q          Display commands queue\n"
" -k id       Kill a running transfer (XFERR). id\n"
"             is the number identifying the transfer\n"
" -u          Get the list of all users of the hub\n"
" -n nick     Get the userinfo for 'nick'\n"
" -l nick     Download and display the list of files\n"
"             shared by the user named 'nick'\n"
" -r dctc_cmd send a raw command to dctc\n"
" -c message  Send chat message\n"
" -p nick message\n"
"             Send private chat message to nick\n"
"Group Download Switches:\n"
" -gq         Group Quick List\n"
" -gl         Group List\n"
" -gn gdlid filesize filename\n"
"             Group New Id\n"
" -ga gdlid nickname remotefilename remotefilesize\n"
"             Group Add download\n"
" -gd gdlid   Delete download\n"
" -ge gdlid   End group download\n"
"cccp Switches:\n"
" -h          Display this help\n"
" -o          print output from dctc to stdout.\n"
"             Default with (-s,-d,-t,-q,-n,-c,-p)\n"
" -O          No Output. Just send command and exit\n"
"             overrides default -o switch\n"
" -N          No Error Output. ERR messages are not\n"
"             printed\n"
" -H hubname  Connect to running DCTC client with\n"
"             this substring\n"
" -L          List DCTC Hubs\n"
" -T timeout  Inactivity timeout. When to kill\n"
"             searches that don't return anymore hits\n"
" -S          timeStamp output\n"
" -SC         timeStamp output in Clock format\n"
" -x          make DCTC client exit. Wait for\n"
"             downloads to complete\n"
" -X          Force DCTC to exit without waiting for\n"
"             downloads to complete\n" 

"\nFor more commands see the DCTC Documentation directory\n");


	exit(-1);
}

