/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificDoubleValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

final class ParticularDoubleValue
extends SpecificDoubleValue {
    private final double value;

    public ParticularDoubleValue(double d) {
        this.value = d;
    }

    public double value() {
        return this.value;
    }

    public DoubleValue negate() {
        return new ParticularDoubleValue(-this.value);
    }

    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    public FloatValue convertToFloat() {
        return new ParticularFloatValue((float)this.value);
    }

    public DoubleValue generalize(DoubleValue doubleValue) {
        return doubleValue.generalize(this);
    }

    public DoubleValue add(DoubleValue doubleValue) {
        return doubleValue.add(this);
    }

    public DoubleValue subtract(DoubleValue doubleValue) {
        return doubleValue.subtractFrom(this);
    }

    public DoubleValue subtractFrom(DoubleValue doubleValue) {
        return doubleValue.subtract(this);
    }

    public DoubleValue multiply(DoubleValue doubleValue) {
        return doubleValue.multiply(this);
    }

    public DoubleValue divide(DoubleValue doubleValue) {
        return doubleValue.divideOf(this);
    }

    public DoubleValue divideOf(DoubleValue doubleValue) {
        return doubleValue.divide(this);
    }

    public DoubleValue remainder(DoubleValue doubleValue) {
        return doubleValue.remainderOf(this);
    }

    public DoubleValue remainderOf(DoubleValue doubleValue) {
        return doubleValue.remainder(this);
    }

    public IntegerValue compare(DoubleValue doubleValue) {
        return doubleValue.compareReverse(this);
    }

    public DoubleValue generalize(ParticularDoubleValue particularDoubleValue) {
        return this.value == particularDoubleValue.value ? this : ValueFactory.DOUBLE_VALUE;
    }

    public DoubleValue add(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value + particularDoubleValue.value);
    }

    public DoubleValue subtract(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value - particularDoubleValue.value);
    }

    public DoubleValue subtractFrom(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value - this.value);
    }

    public DoubleValue multiply(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value * particularDoubleValue.value);
    }

    public DoubleValue divide(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value / particularDoubleValue.value);
    }

    public DoubleValue divideOf(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value / this.value);
    }

    public DoubleValue remainder(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value % particularDoubleValue.value);
    }

    public DoubleValue remainderOf(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value % this.value);
    }

    public IntegerValue compare(ParticularDoubleValue particularDoubleValue) {
        return this.value < particularDoubleValue.value ? SpecificValueFactory.INTEGER_VALUE_M1 : (this.value == particularDoubleValue.value ? SpecificValueFactory.INTEGER_VALUE_0 : SpecificValueFactory.INTEGER_VALUE_1);
    }

    public boolean isParticular() {
        return true;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularDoubleValue)object).value;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return this.value + "d";
    }
}

