/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ConcreteClassDownTraveler
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public ConcreteClassDownTraveler(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x600) != 0) {
            Clazz[] clazzArray = programClass.subClasses;
            if (clazzArray != null) {
                for (int i = 0; i < clazzArray.length; ++i) {
                    clazzArray[i].accept(this);
                }
            }
        } else {
            programClass.accept(this.classVisitor);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if ((libraryClass.getAccessFlags() & 0x600) != 0) {
            Clazz[] clazzArray = libraryClass.subClasses;
            if (clazzArray != null) {
                for (int i = 0; i < clazzArray.length; ++i) {
                    clazzArray[i].accept(this);
                }
            }
        } else {
            libraryClass.accept(this.classVisitor);
        }
    }
}

