/*******************************************************************************
FILENAME:      main.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include <qapplication.h>
#include "qterm.h"
#include "sysconfig.h"

#ifndef _OS_WIN32_
#include <sys/stat.h>
#include <stdlib.h>
#include <qdir.h>
#include <errno.h>
#endif

char fileCfg[128]="./qterm.cfg";
QString pathLib="./";

char * itemName[]= {
	"addr",	"port",	"name",
	"font","fgcolor","bgcolor",
	"autoreply","wavefile", "autologin",
	"user","password",
	"proxyenable","proxyaddr",
	"proxyport","proxyuser","proxypassword",
	"prelogin","smartmenu","hyperlink","alwayshighlight",
	"exitwarning","blinktab","escstring","antiidlestring","bbscode"};
#ifndef _OS_WIN32_
int iniWorkingDir( QString param )
{
	if(param.find('/')==-1)
		pathLib="/usr/local/lib/qterm/";
	else
	{
		param.truncate( param.findRev('/') );
		QString oldPath=QDir::currentDirPath();
		QDir::setCurrent( param );
		if( QDir::currentDirPath()=="/usr/local/bin" )
			pathLib="/usr/local/lib/qterm";
		else
			pathLib=QDir::currentDirPath();
		QDir::setCurrent( oldPath );
		pathLib+='/';
	}

	QDir dir;
	
	QString pathHome=QDir::homeDirPath()+"/.qterm";

	dir.setPath( pathHome );
	if( ! dir.exists() )
	{
		if( !dir.mkdir(pathHome) )
		{
			printf("Failed to create %s !\n",pathHome.ascii());
			return -1;
		}
	}
	
	QString file=QDir::homeDirPath()+"/.qterm/qterm.cfg";

	sprintf( fileCfg,file.ascii(),file.length() );
	
	if( !dir.exists(file) )
	{
		QString cmd;
		cmd="/bin/cp -f "+pathLib+"qterm.cfg ";
		cmd+=pathHome;
		printf( "%s\n",cmd.ascii() );
		system( cmd );
	}

	return 1;
		
}
#endif

void iniSysFont()
{
	CSysConfig  conf( fileCfg );
	QString family = conf.szReadCapItem("global","font");
	QString pointsize = conf.szReadCapItem("global","pointsize");
	int pt = pointsize.toInt();
	if( family!=NULL && pt!=0 )
	{
		QFont font(QString::fromLocal8Bit(family),pt,QFont::Normal,false);
		qApp->setFont(font,true);
	}
}
 
int main( int argc, char ** argv ) 
{
    QApplication a( argc, argv );
    qApp=&a;

#ifndef _OS_WIN32_
    if( iniWorkingDir( argv[0] )<0 )
    {
	    return -1;
    }
#endif
      //set font

    iniSysFont();
                                                                                    
   
    QTerm * mw = new QTerm();
    mw->setCaption( "QTerm" );
    
    a.setMainWidget(mw);
    mw->show();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    int res = a.exec();
    return res;
}
