/*******************************************************************************
FILENAME:      global.h
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/

#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <iostream.h>

#ifndef BUFSIZE
#define BUFSIZE (1024)
#endif

#include <qtextcodec.h>
//code convert
#define G2U(s) ( QTextCodec::codecForName("GBK")->toUnicode(s) )
#define U2G(s) ( QTextCodec::codecForName("GBK")->fromUnicode(s) )
#define B2U(s) ( QTextCodec::codecForName("Big5")->toUnicode(s) )
#define U2B(s) ( QTextCodec::codecForName("Big5")->fromUnicode(s) )


// telnet 80*24
#define LINECHARNUM 80
#define LINENUM 24

// short integer for every character
// hight byte for property
// low byte for color
// use mask to sepetate each other
#define COLORPAIR_MASK 0x00ff
#define EXTRAATTR_MASK 0xff00

// set
#define COLORPAIR(cp) ( (cp) & COLORPAIR_MASK )
#define EXTRAATTR(e) ( (e << 8 ) & EXTRAATTR_MASK )
// get
#define GET_COLORPAIR(a) ( (a) & COLORPAIR_MASK )
#define GET_EXTRAATTR(a) ( ( (a) & EXTRAATTR_MASK ) >> 8 )

// in the low byye
// 0-2 foreground
// 3	highlight
// 4-6 background
// mask for colorpair
#define FG_MASK 0x0f
#define BG_MASK 0xf0
#define HIGHLIGHT_MASK 0x08

//set
#define FG(c) ( (c) & FG_MASK )
#define BG(c) ( ( (c) << 4 ) & BG_MASK )
#define HIGHLIGHT(c) ( (c) | HIGHLIGHT_MASK );
//get
#define GET_FG(cp) ( (cp) & FG_MASK )
#define GET_BG(cp) ( ( (cp) & BG_MASK ) >> 4 )
#define GET_HIGHLIGHT(cp) ( (cp) & HIGHLIGHT_MASK )

#define REVERSECOLOR(cp) ( BG( GET_FG(cp) ) | FG( GET_BG(cp) ) | GET_HIGHLIGHT(cp) )

// mask for attr
#define BOLD_MASK 0x01
#define DIM_MASK 0x02
#define UNDERLINE_MASK 0x08
#define BLINK_MASK 0x10
#define RAPIDBLINK_MASK 0x20
#define REVERSE_MASK 0x40
#define INVISIBLE_MASK 0x80

//set
#define BOLD(e) ( (e) | BOLD_MASK )
#define DIM(e) ( (e) | DIM_MASK )
#define UNDERLINE(e) ( (e) | UNDERLINE_MASK )
#define BLINK(e) ( (e) | BLINK_MASK )
#define RAPIDBLINK(e) ( (e) | RAPIDBLINK_MASK )
#define REVERSE(e) ( (e) | REVERSE_MASK )
#define INVISIBLE(e) ( (e) | INVISIBLE_MASK )

//get
#define GET_BOLD(e) ( (e) & BOLD_MASK )
#define GET_DIM(e) ( (e) & BLINK_MASK )
#define GET_UNDERLINE(e) ( (e) & UNDERLINE_MASK )
#define GET_BLINK(e) ( (e) & BLINK_MASK )
#define GET_RAPIDBLINK(e) ( (e) & RAPIDBLINK_MASK )
#define GET_REVERSE(e) ( (e) & REVERSE_MASK )
#define GET_INVISIBLE(e) ( (e) & INVISIBLE_MASK )

//default set 
#define NO_COLOR ( FG(7) | BG(0) )	// see color defination
					// (default foreground color/default background color)
#define NO_ATTR 0x04	// In QCstring, '\0' means the end.
			// So I use this bit for the default attribute

// other definations
#ifndef NULL
#define NULL 0
#endif

#define CHAR_CR 	0x0d	// ^M
#define CHAR_LF		0x0a	// ^J
#define CHAR_FF 	0x0c	// ^L
#define CHAR_TAB 	0x09	// ^I
#define CHAR_BS		0x08	// ^H
#define CHAR_BELL	0x07	// ^G
#define CHAR_ESC	0x1b	//

#define CHAR_NORMAL	-1

#ifndef MIN
#define MIN( x, y ) ( (x) < (y) ? (x) : (y) )
#endif

#ifndef MAX
#define MAX( x, y ) ( (x) < (y) ? (y) : (x) )
#endif

#define ITEMS		25
#define ADDR		0
#define PORT		1
#define NAME		2
#define FONT		3
#define FGCOLOR		4
#define BGCOLOR		5
#define AUTOREPLY	6
#define WAVEFILE	7
#define AUTOLOGIN	8
#define USER		9
#define PASSWORD	10
#define PROXYENABLE	11
#define PROXYADDR	12
#define PROXYPORT	13
#define PROXYUSER	14
#define PROXYPASSWORD	15
#define PRELOGIN	16
#define SMARTMENU	17
#define HYPERLINK	18
#define ALWAYSHIGHLIGHT	19
#define EXITWARNING	20
#define BLINKTAB	21
#define ESCSTRING	22
#define ANTIIDLESTRING	23
#define BBSCODE		24

#define TSRESOLVING		30
#define TSHOSTFOUND		31
#define TSHOSTNOTFOUND		32
#define TSCONNECTING		33
#define TSHOSTCONNECTED		34
#define TSPROXYCONNECTED	35
#define TSPROXYAUTH		36
#define TSPROXYFAIL		38
#define TSREFUSED		39
#define TSREADERROR		40
#define TSCLOSED		41
#define TSCLOSEFINISH		42
#define TSCONNECTVIAPROXY	43
#define TSEGETHOSTBYNAME	44
#define TSEINIWINSOCK		45
#define TSERROR			46
#define TSPROXYERROR		47

#define NOPROXY			0
#define WINGATE			1
#define SOCKS4			2
#define SOCKS5			3


#endif

