# rpm skeleton rewriten by Lenny Cartier <lenny@mandrakesoft.com>
# and updated by Han Boetes <han@linux-mandrake.com>
#
# Default values are for example purpose.  You MUST tweak this specfile
# with the info found at:
#
#   http://www.linux-mandrake.com/howtos/mdk-rpm

# Basic macros
%define name    skel
%define version 0.1
%define release 6mdk

# Macros for in the menu-file.
%define section # http://www.linux-mandrake.com/en/howtos/mdk-rpm/mdk-menu-structure.html
%define title   # %name with first letter capitalized.

# SUMMARY is a SHORT one-line description of the rpm (max. 60
# characters).  Do NOT include the package name (or version number of
# the software) in the comment.  Do NOT start with an uppercase letter
# unless semantically significant, and do NOT end with a period.  DON'T
# EVER START WITH AN INDETERMINATE ARTICLE SUCH AS `a' or `as'; remove
# the article altogether.
%define Summary # SUMMARY

Summary:        %Summary
Name:           %name
Version:        %version
Release:        %release
License:        GPL # MAKE REALLY SURE YOU GOT THE LICENSE RIGHT.
Group:          # http://www.linux-mandrake.com/en/howtos/mdk-rpm/mdk-groups.html
URL:            # Homepage

# Please add comment with the right url/downloadpage.
Source0:        %name-%version.tar.bz2

# Make 3 icons %name-16,32,48.png and then tar cjf %name-icons.tar.bz2 *png
#   convert -resize 48x48 nicepic4icon.png yourprogram48.png
Source1:        %name-icons.tar.bz2

BuildRoot:      %_tmppath/%name-buildroot

# Use ldd afterwards to check for missing Requires/Buildrequires.
# DO NOT ADD IMPLICIT DEPENDENCIES; emample:
# Buildrequires: gtk+-devel XFree86-devel <- wrong!
# gtk+-devel depends on XFree86-devel so you don't have to mention XFree86-devel.
Buildrequires:       foo-devel bar-devel
Requires:            foo       bar

%description
# Put the description here.  Most of the time you can get a good
# description from the homepage.  Make sure it is terse and to the
# point.


%prep
%setup -q
%setup -q -T -D -a1 # unpack icons
#%patch1 -p0


%build
%configure
%make


%install
rm -rf %buildroot
%makeinstall


# Menu
# Every entry must be changed according package specfications
# Pay attention to "section" "command" and "longtitle"
# Use the macros at the head of this file to change the values.
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%name << EOF
?package(%name): \
command="%_bindir/%name" \
needs="X11" \
icon="%name.png" \
section="%section" \
title="%title" \
longtitle="%Summary"
EOF

# icon
# Use {curly braces} here to protect the variable name.
# ie: Is name48.png %{name}48.png or %{name48}.png?
%__install -D -m 644 %{name}48.png %buildroot/%_liconsdir/%name.png
%__install -D -m 644 %{name}32.png %buildroot/%_iconsdir/%name.png
%__install -D -m 644 %{name}16.png %buildroot/%_miconsdir/%name.png

# Macro for locales
# If your rpm does not need this you can remove it.  Also change
# ``%files -f %name.lang'' to ``%files'' below.
%find_lang %name

%post
%update_menus

%postun
%clean_menus


%clean
rm -rf %buildroot


%files -f %name.lang
%defattr(0755,root,root,0755)
%_bindir/*
%defattr(0644,root,root,0755) # No more binaries after this point.
# Add all documentation-files that are usefull for people who install
# the package.  INSTALL may not be usefull since the rpm already
# installs everything.
%doc COPYING LICENSE README INSTALL Changelog AUTHORS
%_menudir/*

%_miconsdir/*
%_iconsdir/*
%_liconsdir/*


%changelog
* Thu Jun 19 2003 Han Boetes <han@linux-mandrake.com> 0.1-6mdk
- changed macro "summary" to "Summary" to because of conflict.

* Sun Mar  9 2003 Han Boetes <han@linux-mandrake.com> 0.1-5mdk
- better order for file-list

* Mon Jan 20 2003 Han Boetes <han@linux-mandrake.com> 0.1-4mdk
- More updates from cooker@ list. Too many to mention here.

* Sun Jan 19 2003 Han Boetes <han@linux-mandrake.com> 0.1-3mdk
- More updates, thanks Geoffrey Lee <glee@gnupilgrims.org>

* Sat Jan 18 2003 Han Boetes <han@linux-mandrake.com> 0.1-2mdk
- update this thing.

* Mon Jun 10 2002 Lenny Cartier <lenny@mandrakesoft.com> 0.1-1mdk
- rewrite lost rpm.skel
