/***************************************************************************
                          alsound.h  -  description
                             -------------------
    begin                : Wed Jan 21 2004
    copyright            : (C) 2004 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef ALSOUND_H
#define ALSOUND_H

/**
  *@author Krippel Harald
  */


#include "audioenv.hpp"
// plib
#include <plib/ssg.h>


/*!

 This Class is the glue between openAL and QCake.

*/

class AlSound
{
   public:
     AlSound(void);
     void   setPosition (float x, float y, float z);
     void   Play();
     void   Stop();
     void   Loop(int flag);
     void   Relative(int flag);
     void   adjustVolume(float gain);
     void   LoadFile(const char *file);
     ~AlSound(void);

   ssgTransform *boxobjtrans;

protected:

   int          snd;     ///< holds the sound index
   sgCoord      pos;     ///< holds the position and rotating
   AudioEnv *Audio;      ///< singleton pointer to the AudioEnv
};

#endif
