//
// C++ Implementation: CFogEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CFogEdit.hpp"

CFogEditDlg::CFogEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.color, SIGNAL(released()), this, SLOT(slotEditColor()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CFogEditDlg::~CFogEditDlg() {
}

void CFogEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CFogEditDlg::slotGetData(FolderListItem *i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;

    point=i;

    ui.text->setText(i->text(0));

    ui.on->setChecked(i->GetValue("on",i).toInt());
    ui.linear->setChecked(i->GetValue("linear",i).toInt());
    ui.exp->setChecked(i->GetValue("exp",i).toInt());
    ui.exp2->setChecked(i->GetValue("exp2",i).toInt());

    ui.dontcare->setChecked(i->GetValue("dontcare",i).toInt());
    ui.fastest->setChecked(i->GetValue("fastest",i).toInt());
    ui.nicest->setChecked(i->GetValue("nicest",i).toInt());

    ui.density->setText(i->GetValue("density",i));
    ui.start->setText(i->GetValue("start",i));
    ui.end->setText(i->GetValue("end",i));
    
    strncpy(mybuff,i->GetValue("color",i).toAscii() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor.setRgb(colorr,colorg,colorb);
    if ( mycolor.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor );
      QIcon icon(pix);
      ui.color->setIcon( icon );
      QSize size(100,15);
      ui.color->setIconSize( size );      
    }

    qWarning( "CFogEditDlg::slotGetData(): Geht !" );
}

void CFogEditDlg::slotEditData()
{
    char mybuff[256];
    
    if(point != NULL)
    {
        point->setText(0,ui.text->text());

        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->SetValue("linear", ui.linear->isChecked() ? "1" : "0");
        point->SetValue("exp", ui.exp->isChecked() ? "1" : "0");
        point->SetValue("exp2", ui.exp2->isChecked() ? "1" : "0");

        point->SetValue("dontcare", ui.dontcare->isChecked() ? "1" : "0");
        point->SetValue("fastest", ui.fastest->isChecked() ? "1" : "0");
        point->SetValue("nicest", ui.nicest->isChecked() ? "1" : "0");

        point->SetValue("density",ui.density->text());
        point->SetValue("start",ui.start->text());
        point->SetValue("end",ui.end->text());

        sprintf(mybuff,"%02X%02X%02X",mycolor.red(),mycolor.green(),mycolor.blue());
        point->SetValue("color",mybuff);

	point->updategl();
    }

qWarning( "CFogEditDlg::slotEditData(): Geht !" );
}

void CFogEditDlg::slotEditColor()
{
    QColor color = QColorDialog::getColor(mycolor,this );
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
        QIcon icon(pix);
        ui.color->setIcon( icon );
        QSize size(100,15);
        ui.color->setIconSize( size );      
        mycolor = color;
    }
    qWarning( "CFogEditDlg::slotEditColorAmb(): Geht !" );
}
