# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002, 2003 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyTone; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import config
import item
import services.playlist
import events, hub
import window
import messagewin

class iteminfowin(window.window):
    def __init__(self, screen, layout, channel, player):
        self.item = None
        self.player = player
        h, w, y, x, border = layout
        window.window.__init__(self, screen, h, w, y, x,
                               config.colors.iteminfowindow,
                               _("MP3 Info"), border)

        channel.subscribe(events.selectionchanged, self.selectionchanged)
        channel.subscribe(events.songchanged, self.songchanged)

    def resize(self, layout):
        h, w, y, x, self.border = layout
        window.window.resize(self, h, w, y, x)

    def update(self):
        # update window title
        if isinstance(self.item, item.song):
            if self.item.type=="mp3":
                self.settitle(_("MP3 Info"))
            else:
                self.settitle(_("Ogg Info"))
        else:
            self.settitle(_("Directory Info"))

        window.window.update(self)

        # get lines to display
        empty= [["", "", "", ""]]
        if self.item:
            info = self.item.getinfo()
        else:
            info = []
        l = info + empty*(4-len(info))

        colsep = self.iw>45

        # calculate width of columns
        wc1 = max( len(l[0][0]), len(l[1][0]), len(l[2][0]), len(l[3][0])) + colsep
        wc3 = max( len(l[0][2]), len(l[1][2]), len(l[2][2])) + colsep
        wc4 = 5
        wc2 = self.iw-wc1-wc3-wc4-1

        for lno in range(4):
            self.move(1+lno, self.ix)
            self.addstr(l[lno][0].ljust(wc1)[:wc1], self.colors.description)
            self.addstr(l[lno][1].ljust(wc2)[:wc2], self.colors.content)
            self.addch(" ")
            if lno!=3:
                self.addstr(l[lno][2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(l[lno][3].ljust(wc4)[:wc4], self.colors.content)
            else:
                # special handling of last line
                wc3 = max(len(l[3][-2]), 5) + colsep
                wc4 = max(len(l[3][-1]), 5)
                
                self.move(1+lno, self.iw-wc3-wc4-1-self.ix)
                self.addch(" ")
                self.addstr(l[3][-2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(l[3][-1].ljust(wc4)[:wc4], self.colors.content)

    # event handler

    def selectionchanged(self, event):
        if self.player and self.item!=event.item:
            if isinstance(event.item, item.song):
                hub.notify(events.playerplaysong(self.player, event.item))
            elif isinstance(event.item, services.playlist.playlistitem):
                hub.notify(events.playerplaysong(self.player, event.item.song))
        self.item = event.item
        self.update()

    def songchanged(self, event):
        # needed only for songs, since these can be rated or updated
        # when they are played note that this may update too often (if
        # multiple songdbs are used), but who cares.
        if isinstance(self.item, item.song) and event.songdbid==self.item.songdbid and event.song==self.item.song:
            self.item.song = event.song
            self.update()


class iteminfowinlong(messagewin.messagewin):

    def __init__(self, screen, maxh, maxw, channel):
        messagewin.messagewin.__init__(self, screen, maxh, maxw, channel,
                                       config.colors.iteminfolongwindow,
                                       _("Item info"), [],
                                       config.iteminfolongwindow.autoclosetime)

        self.item = None

        channel.subscribe(events.selectionchanged, self.selectionchanged)

    def _outputlen(self, width):
        return 15

    def showitems(self):
        # get lines to display
        empty= [["", "", "", ""]]
        if self.item:
            info = self.item.getinfolong()
        else:
            info = []
        l = info + empty*(4-len(info))

        colsep = self.iw>45

        # calculate width of columns
        wc1 = 0
        wc3 = 0
        for line in info:
            wc1 = max(wc1, len(line[0]))
            wc3 = max(wc3, len(line[2]))
        wc1 += colsep
        wc3 += colsep
        wc4 = 0
        wc2 = self.iw-wc1-wc3-wc4-1
        self.clear()
        for lno in range(len(info)):
            line = l[lno]
            self.move(1+lno, self.ix)
            self.addstr(line[0].ljust(wc1)[:wc1], self.colors.description)
            self.addstr(line[1].ljust(wc2)[:wc2], self.colors.content)
            self.addch(" ")
            if lno!=self.ih:
                self.addstr(line[2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(line[3].ljust(wc4)[:wc4], self.colors.content)
            else:
                # special handling of last line
                wc3 = max(len(line[-2]), 5) + colsep
                wc4 = max(len(line[-1]), 5)
                
                self.move(1+lno, self.iw-wc3-wc4-1-self.ix)
                self.addch(" ")
                self.addstr(line[-2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(line[-1].ljust(wc4)[:wc4], self.colors.content)

    def selectionchanged(self, event):
        self.item = event.item
