// C++ interface wrapper code.
//
// Generated by SIP v2.5 on Fri Aug 10 18:47:43 2001
//
// Terms and Conditions
// 
// Copyright (c) 1998, 1999, 2000, 2001
// 	Phil Thompson <phil@river-bank.demon.co.uk>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// Except as contained in this notice, the name of the copyright holder shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from the
// copyright holder.

#include "sipqtDeclqt.h"
#include "sipqtQPointArray.h"


PyObject *sipClass_QPointArray;

static void sipDealloc_QPointArray(sipThisType *);

static PyTypeObject sipType_QPointArray = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	sipName_qt_QPointArray,
	sizeof (sipThisType),
	0,
	(destructor)sipDealloc_QPointArray,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	Py_TPFLAGS_DEFAULT,
	0,
	0,
	0,
};
#line 80 "qpointarray.sip"
// Convert a list of numbers to an array on QCOORDs on the heap.

static QCOORD *getPoints(int nrpnts,PyObject *pntlist)
{
	QCOORD *pnts, *pp;

	if ((pnts = (QCOORD *)sipMalloc(nrpnts * sizeof (QCOORD))) == NULL)
		return NULL;

	// Convert the list.

	pp = pnts;

	for (int i = 0; i < nrpnts; ++i)
	{
		*pp++ = (QCOORD)PyInt_AsLong(PyList_GetItem(pntlist,i));

		if (PyErr_Occurred() != NULL)
		{
			sipFree((ANY *)pnts);
			return NULL;
		}
	}

	return pnts;
}
#line 95 "sipqtQPointArray.cpp"

static PyObject *sipDo_QPointArray_copy(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QPointArray *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = new QPointArray(ptr -> QPointArray::copy());

			return sipNewCppToSelf(res,sipClass_QPointArray,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_copy);

	return NULL;
}

static PyObject *sipDo_QPointArray_translate(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		int a0;
		int a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"ii",&a0,&a1))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> QPointArray::translate( a0, a1);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_translate);

	return NULL;
}

static PyObject *sipDo_QPointArray_boundingRect(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QRect *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = new QRect(ptr -> QPointArray::boundingRect());

			return sipNewCppToSelf(res,sipClass_QRect,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_boundingRect);

	return NULL;
}

static PyObject *sipDo_QPointArray_point(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
#line 144 "qpointarray.sip"
		// The Python interface returns a tuple.

		int index;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&index))
		{
			int x, y;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> point((uint)index,&x,&y);

			return Py_BuildValue("(ii)",x,y);
		}
#line 216 "sipqtQPointArray.cpp"
	}

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QPoint *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = new QPoint(ptr -> QPointArray::point( a0));

			return sipNewCppToSelf(res,sipClass_QPoint,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_point);

	return NULL;
}

static PyObject *sipDo_QPointArray_setPoint(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		unsigned a0;
		int a1;
		int a2;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iii",&a0,&a1,&a2))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> QPointArray::setPoint( a0, a1, a2);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	{
		unsigned a0;
		const QPoint * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iI",&a0,sipCanConvertTo_QPoint,&a1obj))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QPoint(a1obj,(QPoint **)&a1,1,&iserr);

			if (iserr)
				return NULL;

			ptr -> QPointArray::setPoint( a0,* a1);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_setPoint);

	return NULL;
}

static PyObject *sipDo_QPointArray_setPoints(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
#line 168 "qpointarray.sip"
		// The Python interface is a list of QCOORDs.

		PyObject *pntlist;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"T",&PyList_Type,&pntlist))
		{
			int nrpnts;
			QCOORD *pnts;
			PyObject *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			nrpnts = PyList_Size(pntlist);

			if ((pnts = getPoints(nrpnts,pntlist)) == NULL)
				return NULL;

			res = sipConvertFromBool(ptr -> setPoints(nrpnts / 2,pnts));

			sipFree((ANY *)pnts);

			return res;
		}
#line 338 "sipqtQPointArray.cpp"
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_setPoints);

	return NULL;
}

static PyObject *sipDo_QPointArray_putPoints(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
#line 199 "qpointarray.sip"
		// The Python interface is a list of QCOORDs.

		int index;
		PyObject *pntlist;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iT",&index,&PyList_Type,&pntlist))
		{
			int nrpnts;
			QCOORD *pnts;
			PyObject *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			nrpnts = PyList_Size(pntlist);

			if ((pnts = getPoints(nrpnts,pntlist)) == NULL)
				return NULL;

			res = sipConvertFromBool(ptr -> putPoints(index,nrpnts,pnts));

			sipFree((ANY *)pnts);

			return res;
		}
#line 384 "sipqtQPointArray.cpp"
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_putPoints);

	return NULL;
}

static PyObject *sipDo_QPointArray_makeArc(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		int a0;
		int a1;
		int a2;
		int a3;
		int a4;
		int a5;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iiiiii",&a0,&a1,&a2,&a3,&a4,&a5))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> QPointArray::makeArc( a0, a1, a2, a3, a4, a5);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	{
		int a0;
		int a1;
		int a2;
		int a3;
		int a4;
		int a5;
		const QWMatrix * a6;
		PyObject *a6obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iiiiiiI",&a0,&a1,&a2,&a3,&a4,&a5,sipCanConvertTo_QWMatrix,&a6obj))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QWMatrix(a6obj,(QWMatrix **)&a6,1,&iserr);

			if (iserr)
				return NULL;

			ptr -> QPointArray::makeArc( a0, a1, a2, a3, a4, a5,* a6);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_makeArc);

	return NULL;
}

static PyObject *sipDo_QPointArray_makeEllipse(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		int a0;
		int a1;
		int a2;
		int a3;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iiii",&a0,&a1,&a2,&a3))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> QPointArray::makeEllipse( a0, a1, a2, a3);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_makeEllipse);

	return NULL;
}

static PyObject *sipDo_QPointArray_quadBezier(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QPointArray *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = new QPointArray(ptr -> QPointArray::quadBezier());

			return sipNewCppToSelf(res,sipClass_QPointArray,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_quadBezier);

	return NULL;
}

static PyObject *sipDo_QPointArray_nrefs(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			unsigned res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::nrefs();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_nrefs);

	return NULL;
}

static PyObject *sipDo_QPointArray_isEmpty(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::isEmpty();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_isEmpty);

	return NULL;
}

static PyObject *sipDo_QPointArray_isNull(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::isNull();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_isNull);

	return NULL;
}

static PyObject *sipDo_QPointArray_resize(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			bool res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::resize( a0);

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_resize);

	return NULL;
}

static PyObject *sipDo_QPointArray_size(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			unsigned res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::size();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_size);

	return NULL;
}

static PyObject *sipDo_QPointArray_truncate(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			bool res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = ptr -> QPointArray::truncate( a0);

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_truncate);

	return NULL;
}

static PyObject *sipDo_QPointArray_fill(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		const QPoint * a0;
		PyObject *a0obj;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QPoint,&a0obj,&a1))
		{
			bool res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QPoint(a0obj,(QPoint **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QPointArray::fill(* a0, a1);

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_fill);

	return NULL;
}

static PyObject *sipDo_QPointArray_at(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QPoint *res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			res = &ptr -> QPointArray::at( a0);

			return sipMapCppToSelf(res,sipClass_QPoint);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_at);

	return NULL;
}

static PyObject *sipDo_QPointArray_sort(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			ptr -> QPointArray::sort();

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_sort);

	return NULL;
}

static PyObject *sipDo_QPointArray_bsearch(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		const QPoint * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QPoint,&a0obj))
		{
			int res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QPoint(a0obj,(QPoint **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QPointArray::bsearch(* a0);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_bsearch);

	return NULL;
}

static PyObject *sipDo_QPointArray_find(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		const QPoint * a0;
		PyObject *a0obj;
		unsigned a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QPoint,&a0obj,&a1))
		{
			int res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QPoint(a0obj,(QPoint **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QPointArray::find(* a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_find);

	return NULL;
}

static PyObject *sipDo_QPointArray_contains(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QPointArray)) == NULL)
		return NULL;

	{
		const QPoint * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QPoint,&a0obj))
		{
			int res;
			QPointArray *ptr;

			if ((ptr = (QPointArray *)sipGetCppPtr(sipThis,sipClass_QPointArray)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QPoint(a0obj,(QPoint **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QPointArray::contains(* a0);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QPointArray,sipName_qt_contains);

	return NULL;
}

// Cast a pointer to a type somewhere in its superclass hierachy.

const void *sipCast_QPointArray(const void *ptr,PyObject *targetClass)
{
	if (targetClass == sipClass_QPointArray)
		return ptr;

	return NULL;
}

static void sipDealloc_QPointArray(sipThisType *sipThis)
{
	if (sipThis -> u.cppPtr != NULL)
	{
		if (sipIsPyOwned(sipThis))
			delete (QPointArray *)sipThis -> u.cppPtr;
	}

	sipDeleteThis(sipThis);
}

PyObject *sipNew_QPointArray(PyObject *sipSelf,PyObject *sipArgs)
{
	static sipExtraType et = {
		sipCast_QPointArray,
		(void *)sipNewProxy_qt,
		NULL
	};

	sipThisType *sipThis = NULL;
	const void *sipNew = NULL;
	int sipFlags = SIP_PY_OWNED;
	int sipArgsParsed = 0;

	// See if there is something pending.

	sipNew = sipGetPending(&sipFlags);

	if (sipNew == NULL)
	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,"-"))
		{
			sipNew = new QPointArray();
		}
	}

	if (sipNew == NULL)
	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-i",&a0))
		{
			sipNew = new QPointArray( a0);
		}
	}

	if (sipNew == NULL)
	{
		const QPointArray * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-I",sipCanConvertTo_QPointArray,&a0obj))
		{
			int iserr = 0;

			sipConvertTo_QPointArray(a0obj,(QPointArray **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QPointArray(* a0);
		}
	}

	if (sipNew == NULL)
	{
		const QRect * a0;
		PyObject *a0obj;
		long a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-I|l",sipCanConvertTo_QRect,&a0obj,&a1))
		{
			int iserr = 0;

			sipConvertTo_QRect(a0obj,(QRect **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QPointArray(* a0, (bool)a1);
		}
	}

	if (sipNew == NULL)
	{
#line 116 "qpointarray.sip"
		// The Python interface is a list of QCOORDs.

		PyObject *pntlist;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-T",&PyList_Type,&pntlist))
		{
			int nrpnts;
			QCOORD *pnts;

			nrpnts = PyList_Size(pntlist);

			if ((pnts = getPoints(nrpnts,pntlist)) == NULL)
				return NULL;

			// No wrapper class for QPointArray.

			sipNew = new QPointArray(nrpnts / 2,pnts);

			sipFree((ANY *)pnts);
		}
#line 1051 "sipqtQPointArray.cpp"
	}

	if (sipNew == NULL)
	{
		sipNoCtor(sipArgsParsed,sipName_qt_QPointArray);
		return NULL;
	}

	// Wrap the object.

	if ((sipThis = sipCreateThis(sipSelf,sipNew,&sipType_QPointArray,sipFlags,&et)) == NULL)
	{
		if (sipFlags & SIP_PY_OWNED)
			delete (QPointArray *)sipNew;

		return NULL;
	}

	Py_INCREF(Py_None);
	return Py_None;
}

PyMethodDef sipClassAttrTab_QPointArray[] = {
	{sipName_qt_copy, sipDo_QPointArray_copy, METH_VARARGS, NULL},
	{sipName_qt_translate, sipDo_QPointArray_translate, METH_VARARGS, NULL},
	{sipName_qt_boundingRect, sipDo_QPointArray_boundingRect, METH_VARARGS, NULL},
	{sipName_qt_point, sipDo_QPointArray_point, METH_VARARGS, NULL},
	{sipName_qt_setPoint, sipDo_QPointArray_setPoint, METH_VARARGS, NULL},
	{sipName_qt_setPoints, sipDo_QPointArray_setPoints, METH_VARARGS, NULL},
	{sipName_qt_putPoints, sipDo_QPointArray_putPoints, METH_VARARGS, NULL},
	{sipName_qt_makeArc, sipDo_QPointArray_makeArc, METH_VARARGS, NULL},
	{sipName_qt_makeEllipse, sipDo_QPointArray_makeEllipse, METH_VARARGS, NULL},
	{sipName_qt_quadBezier, sipDo_QPointArray_quadBezier, METH_VARARGS, NULL},
	{sipName_qt_nrefs, sipDo_QPointArray_nrefs, METH_VARARGS, NULL},
	{sipName_qt_isEmpty, sipDo_QPointArray_isEmpty, METH_VARARGS, NULL},
	{sipName_qt_isNull, sipDo_QPointArray_isNull, METH_VARARGS, NULL},
	{sipName_qt_resize, sipDo_QPointArray_resize, METH_VARARGS, NULL},
	{sipName_qt_size, sipDo_QPointArray_size, METH_VARARGS, NULL},
	{sipName_qt_truncate, sipDo_QPointArray_truncate, METH_VARARGS, NULL},
	{sipName_qt_fill, sipDo_QPointArray_fill, METH_VARARGS, NULL},
	{sipName_qt_at, sipDo_QPointArray_at, METH_VARARGS, NULL},
	{sipName_qt_sort, sipDo_QPointArray_sort, METH_VARARGS, NULL},
	{sipName_qt_bsearch, sipDo_QPointArray_bsearch, METH_VARARGS, NULL},
	{sipName_qt_find, sipDo_QPointArray_find, METH_VARARGS, NULL},
	{sipName_qt_contains, sipDo_QPointArray_contains, METH_VARARGS, NULL},
	{NULL}
};

int sipCanConvertTo_QPointArray(PyObject *sipPy)
{
	return sipIsSubClassInstance(sipPy,sipClass_QPointArray);
}

void sipConvertTo_QPointArray(PyObject *sipPy,QPointArray **sipCppPtr,int sipWillDeref,int *sipIsErr)
{
	if (*sipIsErr || sipPy == NULL)
		return;

	if (sipPy == Py_None)
	{
		sipCheckNone(sipWillDeref,sipIsErr,sipName_qt_QPointArray);
		*sipCppPtr = NULL;

		return;
	}

	*sipCppPtr = (QPointArray *)sipConvertToCpp(sipPy,sipClass_QPointArray,sipIsErr);
}

QPointArray *sipForceConvertTo_QPointArray(PyObject *valobj,int *iserrp)
{
	if (*iserrp || valobj == NULL || valobj == Py_None)
		return NULL;

	if (sipCanConvertTo_QPointArray(valobj))
	{
		QPointArray *val;

		sipConvertTo_QPointArray(valobj,&val,0,iserrp);

		return val;
	}

	sipBadClass(sipName_qt_QPointArray);

	*iserrp = 1;

	return NULL;
}
