#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DIR=enthought-chaco2-$2.orig

# cleanup the upstream sources
tar zxf $3
mv Enable-$2 $DIR

# remove freetype2 source from enthought.kiva
(cd $DIR; rm -rf enthought/kiva/agg/freetype2)

# remove non-free gpc sources
(cd $DIR; rm -rf enthought/kiva/agg/agg-24/gpc)

# create the tarball
GZIP=--best tar -c -z -f $3 $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $3 $origDir
  echo "moved $3 to $origDir"
fi
