/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __JOINTSET_H
#define __JOINTSET_H

// project includes
#include "vector3.h"

/*!
  class to store joints (i.e. surface patches) and check if a bond crosses one of them
*/
class JointSet
{
 public:
  virtual ~JointSet(){};


  virtual int isCrossing(const Vector3&, const Vector3&) const=0;
};

#endif // __JOINTSET_H
