# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .backup_entity import BackupEntity


class ApplicationBackupEntity(BackupEntity):
    """Identifies the Service Fabric application which is being backed up.

    All required parameters must be populated in order to send to Azure.

    :param entity_kind: Required. Constant filled by server.
    :type entity_kind: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    """

    _validation = {
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationBackupEntity, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.entity_kind = 'Application'
