# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EnvironmentVariableWithSecretValue(Model):
    """A collection of environment variables with secret values to set.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the environment variable to store the
     secret value.
    :type name: str
    :param value: The value of the environment variable. This value will never
     be reported back by Batch AI.
    :type value: str
    :param value_secret_reference: Specifies the location of the Azure
     KeyVault secret which will be used as the environment variable value.
     Specifies KeyVault Store and Secret which contains the value for the
     environment variable. One of value or valueSecretReference must be
     provided.
    :type value_secret_reference:
     ~azure.mgmt.batchai.models.KeyVaultSecretReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_secret_reference': {'key': 'valueSecretReference', 'type': 'KeyVaultSecretReference'},
    }

    def __init__(self, *, name: str, value: str=None, value_secret_reference=None, **kwargs) -> None:
        super(EnvironmentVariableWithSecretValue, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.value_secret_reference = value_secret_reference
