# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OcrWord(Model):
    """Information on a recognized word.

    :param bounding_box: Bounding box of a recognized word. The four integers
     represent the x-coordinate of the left edge, the y-coordinate of the top
     edge, width, and height of the bounding box, in the coordinate system of
     the input image, after it has been rotated around its center according to
     the detected text angle (see textAngle property), with the origin at the
     top-left corner, and the y-axis pointing down.
    :type bounding_box: str
    :param text: String value of a recognized word.
    :type text: str
    """

    _attribute_map = {
        'bounding_box': {'key': 'boundingBox', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(self, *, bounding_box: str=None, text: str=None, **kwargs) -> None:
        super(OcrWord, self).__init__(**kwargs)
        self.bounding_box = bounding_box
        self.text = text
