import cStringIO
from Xslt import test_harness

from Ft.Lib import ReaderBase
from Ft.Lib import pDomlette
from Ft.Lib import cDomlette
from xml.xslt import StylesheetReader
from xml.dom.ext.reader import Sax2

sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:include href='Xslt/Core/addr_book1.xsl'/>

  <xsl:template match='PHONENUM' priority='10'>
    <xsl:element name='p'>
      <xsl:attribute name='align'>center</xsl:attribute>
      <xsl:value-of select='@DESC'/><xsl:text>: </xsl:text>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>
"""

expected = """<html>
  <head>
    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>
    <title>Address Book</title>
  </head>
  <body>
    <h1>Tabulate Just Names and Phone Numbers</h1>
    <table>
      <tr>
        <td align='center'>
          <b>Pieter Aaron</b>
        </td>
        <td>
          <p align='center'>Work: 404-555-1234</p>
          <p align='center'>Fax: 404-555-4321</p>
          <p align='center'>Pager: 404-555-5555</p>
        </td>
      </tr>
      <tr>
        <td align='center'>
          <b>Emeka Ndubuisi</b>
        </td>
        <td>
          <p align='center'>Work: 767-555-7676</p>
          <p align='center'>Fax: 767-555-7642</p>
          <p align='center'>Pager: 800-SKY-PAGEx767676</p>
        </td>
      </tr>
      <tr>
        <td align='center'>
          <b>Vasia Zhugenev</b>
        </td>
        <td>
          <p align='center'>Work: 000-987-6543</p>
          <p align='center'>Cell: 000-000-0000</p>
        </td>
      </tr>
    </table>
  </body>
</html>"""

class GenericReader(ReaderBase.DomletteReader):

    def __init__(self,reader,allArgs):
        ReaderBase.DomletteReader.__init__(self)
        self._used = 0
        self._reader = reader
        self._allArgs = allArgs

    def releaseNode(self,node):
        r = pDomlette.PyExpatReader()
        r.releaseNode(node)


    def fromString(self, st, refUri='', ownerDoc=None, stripElements=None,
                   importIndex=0, importDepth=0):
        return self.fromStream(cStringIO.StringIO(st),baseUri=refUri,ownerDoc=ownerDoc,stripElements=stripElements)

    def fromUri(self, uri, baseUri='', ownerDoc=None, stripElements=None,
                   importIndex=0, importDepth=0):
        return self.fromStream(open(uri),baseUri=uri,ownerDoc=ownerDoc,stripElements=stripElements)

    def fromStream(self, stream, baseUri='', ownerDoc=None,stripElements=None):
        self._used = self._used + 1
        reader = self._reader()
        if self._allArgs:
            src = reader.fromStream(stream,baseUri,ownerDoc=ownerDoc,stripElements=stripElements)
        else:
            src = reader.fromStream(stream,ownerDoc=ownerDoc)
        
        if not ownerDoc:
            sty = StylesheetReader.FromDocument(src,baseUri = baseUri,stylesheetReader = GenericReader(self._reader,self._allArgs))
        else:
            sty = ownerDoc.createDocumentFragment()
            sty.__dict__['baseUri'] = baseUri
            StylesheetReader.DomConvert(src.firstChild,sty,ownerDoc,[],{},0)

        return sty


readers = [('pDomlette.PyExpatReader',GenericReader(pDomlette.PyExpatReader,1)),
           ('cDomlette.RawExpatReader',GenericReader(cDomlette.RawExpatReader,1)),
           ('Sax2Reader',GenericReader(Sax2.Reader,0)),
           ]


def Test(tester):


    tester.startGroup("Default reader")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml")
    sty = test_harness.FileInfo(string=sheet_str)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected,
                                    )

    xtest.test(tester)
    tester.groupDone()

    for name,reader in readers:
        tester.startGroup(name)
        source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml")
        sty = test_harness.FileInfo(string=sheet_str)
        xtest = test_harness.XsltTester(source,
                                        [sty],
                                        expected,
                                        stylesheetReader = reader
                                        )
        
        xtest.test(tester)
        
        tester.groupDone()

    return
