def hex2utf8(words):
    if (words[0] & 0xFC00) == 0xD800:
        if (words[1] & 0xFC00) == 0xDC00:
            wbits = ((words[0] & 0x03C0) >> 6) + 1
            zbits = (words[0] & 0x003C) >> 2
            ybits = (((words[0] & 0x0003) << 4) | ((words[1] & 0x03C0) >> 6))
            xbits = words[1] & 0x003F
            bytes = [(0xF0 | ((ubits & 0x1C) >> 2)),
                     (0x80 | ((ubits | 0x03) << 4) | zbits),
                     (0x80 | ybits),
                     (0x80 | xbits)]
        else:
            raise Exception("Invalid Sequence")
    elif (words[0] & 0xFF80) == 0x00:
        bytes = [words[0] & 0x007F]
    elif (words[0] & 0xF800) == 0x00:
        ybits = ((words[0] & 0x07C0) >> 6)
        xbits = words[0] & 0x003F
        bytes = [(0xC0 | ybits),
                 (0x80 | xbits)]
    else:
        zbits = ((words[0] & 0xF000) >> 12)
        ybits = ((words[0] & 0x0FC0) >> 6)
        xbits = words[0] & 0x003F
        bytes = [(0xE0 | zbits),
                 (0x80 | ybits),
                 (0x80 | xbits)]
    result = ''
    for byte in bytes:
        result = result + chr(byte)
    return result
