# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk
import consts

from dlgBase import DlgBase

class DlgSavePar2(DlgBase) :

    def __init__(self, parent) :
        DlgBase.__init__(self, parent, 'dlg-save')


    def show(self, defaultFile) :
        # set_filename() changes the current directory, if the file does not exist then nothing is selected
        # set_current_name() must be used to provide a non-existing filename
        self.mDlg.set_filename(defaultFile)
        slashIndex = defaultFile.rfind('/')
        if slashIndex != -1 :
            self.mDlg.set_current_name(defaultFile[slashIndex+1:])

        if self.mDlg.run() == gtk.RESPONSE_OK :
            return self.mDlg.get_filename()
        return None


dlg = None
def instance(parent) :
    global dlg
    if dlg == None :
        dlg = DlgSavePar2(parent)
    return dlg
