# viewattach.py
#
# Allow displaying of attachments

import utils
from gtk import *
import GtkExtra
import tempfile
import os

from pyneheaders import *

def view_attachment(msg, index, user):
	"""
	Display the attachment.
	"""
	attachment_info = msg.get_attachment_info(index)
	
	content_type = attachment_info[0]
	orig_name = attachment_info[1]
	#attach_size = attachment_into[2]
	#content_transfer_encoding = attachment_info[3]

	# Get a temporary filename
	tempfilename = tempfile.mktemp()
	# Decode attachment to this file
	msg.save_attachment(index, tempfilename)

	# if this thing is text/html open in a browser
	if content_type == "text/html":
		try:
			import webbrowser
		except ImportError:
			GtkExtra.message_box(_("Missing module"), _("Python 'webbrowser' module missing"), ("Ok",))
		else:
			webbrowser.open("file://"+tempfilename, 1)
			# remember temporary files for cleanup time :-)
			# /me kisses pyne.py
			user.tempfiles.append(tempfilename)

			return
	# Assume they are all images for the moment
	try:
		import GdkImlib
	except ImportError:
		GtkExtra.message_box(_("Missing module"), _("Pygtk 'GdkImlib' module missing"), ("Ok",))
	else:
		try:
			im = GdkImlib.Image(tempfilename)
		except:
			pass
		else:
			win = GtkWindow()
			win.set_title(attachment_info[1])
			win.set_data('user_data', im)
			im.render()
			pix = im.make_pixmap()
			pix.show()
			win.add(pix)
			win.show()
			# Remove temporary file
			os.remove(tempfilename)
			return
	# Non-image formats...
	# Read in temporary file
	f = open(tempfilename, "r")
	s = f.read()
	f.close()

	# Show file in a dodgy textual manner...
	pager = utils.ProgressWindow(_("Viewing attachment ")+orig_name)
	pager.msg_print(s)

	# Remove temporary file
	os.remove(tempfilename)

