#
# Pyne msgviewbox module.
#
# The main window is 0wned by a 'user' object,
# which contains all the smelly data.
#

import utils
from gtk import *
import GtkExtra

import string
from viewattach import *
from pyneheaders import *
import time
import pynei18n

class msg_view_box(GtkNotebook):
	"""
	Message viewing object.
	"""
	def __init__(self, user):
		GtkNotebook.__init__(self)
		self.set_tab_pos(user.tab_pos)

		# Body text
		self.body_label = GtkLabel(_("Body"))

		table = GtkTable(2, 2)
		table.set_row_spacing(0, 2)
		table.set_col_spacing(0, 2)
		self.append_page(table, self.body_label)
		table.show()

		self.body_text = GtkText()
		self.body_text.set_editable(FALSE)
		self.body_text.set_line_wrap(TRUE)
		table.attach(self.body_text, 0,1, 0,1)
		self.body_text.show()

		vscrollbar = GtkVScrollbar(self.body_text.get_vadjustment())
		table.attach(vscrollbar, 1,2, 0,1, xoptions=FILL)
		vscrollbar.show()

		# Message source
		self.source_label = GtkLabel(_("Source"))

		table = GtkTable(2, 2)
		table.set_row_spacing(0, 2)
		table.set_col_spacing(0, 2)
		self.append_page(table, self.source_label)
		table.show()

		self.source_text = GtkText()
		self.source_text.set_editable(FALSE)
		self.source_text.set_line_wrap(1)
		table.attach(self.source_text, 0,1, 0,1)
		self.source_text.show()

		vscrollbar = GtkVScrollbar(self.source_text.get_vadjustment())
		table.attach(vscrollbar, 1,2, 0,1, xoptions=FILL)
		vscrollbar.show()

		# attachments
		box = GtkVBox()
		self.attachments_label = GtkLabel(_("Attachments"))
		self.append_page(box, self.attachments_label)
		box.show()

		self.attachment_list = GtkCList(3, [ _("Type"), _("Name"), _("Size") ])
		self.attachment_list.set_column_width(0,200)
		self.attachment_list.set_column_width(1,150)
		self.attachment_list.set_column_width(2,50)

		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
		box.pack_start(swin)
		swin.show()
		swin.add(self.attachment_list)
		self.attachment_list.show()

		box2 = GtkHBox(spacing=5)
		box2.set_border_width(5)
		box.pack_start(box2, expand=FALSE)
		box2.show()

		def s_attach(_button, self=self):
			"""
			Get filename to save attachment.
			"""
			# Nothing selected
			if len(self.attachment_list.selection) == 0:
				return
			selected = self.attachment_list.selection[0] + 1

			# Open file selection box
			f = GtkFileSelection(_("Save Attachment"))
			f.set_filename(self.last_message.get_attachment_info(selected)[1])

			def do_it(_button, f=f, self=self, msg=self.last_message, selected=selected):
				filename = f.get_filename()
				f.destroy()
				msg.save_attachment(selected, filename)

			f.ok_button.connect("clicked", do_it)
			f.cancel_button.connect("clicked", f.destroy)
			f.show()

		def v_attach(_button, self=self, user=user):
			"""
			View attachment.
			"""
			# Nothing selected
			if len(self.attachment_list.selection) == 0:
				return
			selected = self.attachment_list.selection[0] + 1

			# Show attachment
			view_attachment(self.last_message, selected, user)

		button = GtkButton(" "+_("Save")+" ")
		button.connect("clicked", s_attach)
		box2.pack_end(button, expand=FALSE)
		button.show()

		button = GtkButton(" "+_("View")+" ")
		button.connect("clicked", v_attach)
		box2.pack_end(button, expand=FALSE)
		button.show()
		
		# DEBUG CODE. This is how font selection will work one day...
		#f = GtkFontSelectionDialog("sheep")
		#def something(_button, f=f):
		#	print f.get_font_name()
		#f.show()
		#f.ok_button.connect("clicked", something)

		# last shown message
		self.last_message = None

	def rot13_redisplay(self, user):
		"""
		Redisplay the current message with rot13alised body.
		"""
		if self.last_message == None:
			return
		self.last_message.parts_text[0] = utils.rot13(self.last_message.parts_text[0])
		self.dump_msg(user)

	def clear(self):
		"""
		Clear current display.
		"""
		self.last_message = None
		
		self.body_text.freeze()
		self.body_text.backward_delete(self.body_text.get_length())
		self.body_text.thaw()
		
		self.source_text.freeze()
		self.source_text.backward_delete(self.source_text.get_length())
		self.source_text.thaw()
		
		self.attachment_list.clear()
		self.source_label.set_text(_("Source"))
		self.attachments_label.set_text(_("Attachments"))

	def dump_msg(self, user, folder=None, msg_id=None):
		"""
		Dump the given message.
		"""
		if msg_id != None:
			self.last_message = folder.io.load_article(msg_id)
		message = self.last_message
		############ Message body
		# Delete prev message
		self.body_text.freeze()
		self.body_text.backward_delete(self.body_text.get_length())

		col_text = utils.make_gdk_col(user.col_text)
		col_quote = utils.make_gdk_col(user.col_quote)
		col_header = utils.make_gdk_col(user.col_header)

		# Load font
		font = utils.get_font(user.bodyfont)

		# Some message info
		if message.headers.has_key("to"):
			self.body_text.insert(font, col_header, None, _("To")+": "+message.headers["to"]+"\n")
		if message.headers.has_key("newsgroups"):
			self.body_text.insert(font, col_header, None, _("To")+": "+message.headers["newsgroups"]+"\n")
		self.body_text.insert(font, col_header, None, _("From")+": "+message.headers["from"]+"\n")
		try:
			if message.headers["reply-to"] != message.headers["from"]:
				self.body_text.insert(font, col_header, None, _("Reply-To")+": "+message.headers["reply-to"]+"\n")
		except KeyError:
			pass
		self.body_text.insert(font, col_header, None, _("Subject")+": "+message.headers["subject"]+"\n")
		self.body_text.insert(font, col_header, None, _("Date")+": "+time.strftime("%d %b %Y, %H:%M:%S", message.date)+"\n")
		# Attachment
		if len(message.parts_text) > 1:
			x = len(message.parts_text)
			a = _("Attachments")+": ("
			for y in range(1, x):
				a = a + message.get_attachment_info(y)[1]+", "
			a = a[:-2]+")"
			self.body_text.insert(font, col_header, None, a+"\n\n")
		else:
			self.body_text.insert(font, col_header, None, "\n")

		# dump all ASCII parts
		for i in range(0, len(message.parts_header)):
			content_type = message.get_attachment_info(i)[0]
			if content_type == "text/plain" or i == 0:
				# Split body text into lines
				msg = string.split(message.parts_text[i], "\n")
				if i != 0:
					# extra header for parts beyond the 1st
					self.body_text.insert(font, col_text, None, "\n\n")
					self.body_text.insert(font, col_header, None, _("Text part %d") % (i+1,)+"\n\n")
				# Dump it
				for x in range (0, len(msg)):
					# Quoted ([:1] == [0] w/o raising exception on "")
					if msg[x][:1] == '>':
						self.body_text.insert(font, col_quote, None, msg[x]+"\n")
						continue
					# Normal
					else:
						self.body_text.insert(font, col_text, None, msg[x]+"\n")
						continue

		# No body text downloaded. tell the user
		if (message.opts & MSG_NO_BODY):
			self.body_text.insert(font, col_header, None, \
			_("Body text not downloaded. Right click on message and select 'download body'.\n"))

		self.body_text.thaw()

		# Update label
		#self.body_label.set_text("Subject: "+message.headers["subject"])

		############## Message SOURCE
		# Delete prev message
		self.source_text.freeze()
		self.source_text.backward_delete(self.source_text.get_length())

		# Dump message
		style = self.source_text.get_style()

		# Do it quickly. There could be huge attachments
		x = string.find(message.body, "\n\n")
		if x != -1:
			# Make headers red
			self.source_text.insert(font, col_header, None, message.body[0:x])
			self.source_text.insert(font, col_text, None, message.body[x:])
		else:
			self.source_text.insert(font, col_text, None, message.body)

		self.source_text.thaw()

		# Update label
		self.source_label.set_text(_("Source")+" ("+str(len(message.body)/1024)+"Kb)")

		x = len(message.parts_text)
		self.attachment_list.clear()

		for y in range(1,x):
			a = message.get_attachment_info(y)
			self.attachment_list.append( [ a[0], a[1], a[2] ] )

		self.attachments_label.set_text(_("Attachments")+" ("+str(len(message.parts_text)-1)+")")

