# File: storebox.py
# Purpose: General purpose message storage box

import string
from gtk import *
import GtkExtra
import boxformats
import boxformats.configbox
from superbox import *
from ptk.big_edit_box import *

class storebox(superbox):
	"""
	Simply stores messages with no special send, receive or delete rules.
	Typical use as a 'sent' or 'saved' folder.
	"""
	def get_flags(self):
		# special ones may not be deleted
		if self.uid == "sent":
			return BOX_DEL_MESSAGE
		else:
			return BOX_ISDELETEABLE | BOX_DEL_MESSAGE

	def __init__(self, user, name, uid):
		"""
		Create new deleted mail folder.
		"""
		# Basic setup
		superbox.__init__(self, name, uid)
		self.expire_after = None
		self.export_format = (boxformats.BF_FLATFILEBOX, None)
		self.messages = []
		self.contents = []
		self.startup(user)

	def clean_4_save(self):
		"""
		Remove stuff we don't want saved to disk
		"""
		if self.__dict__.has_key("locked"):
			del self.locked
		if self.__dict__.has_key("changed"):
			del self.changed
		del self.io
		del self.messages

	def startup(self, user):
		"""
		Get an io module for loading/saving articles
		"""
		i = self.export_format[0]
		# this is a pretty piece of code :-)
		bf_class = boxformats.__dict__[boxformats.__all__[i]]. \
			   __dict__[boxformats.__all__[i]]
		self.io = bf_class(user, self)
		self.messages = self.io.get_contents()

	def get_menu(self):
		"""
		This box type specific options.
		"""
		return []

	def menu_chosen(self, _a, choice):
		"""
		Activate the chosen menu option.
		"""
		pass

	def getstats(self):
		"""
		Returns a tuple. (total msgs,).
		"""
		return (len(self.messages), )

	def setup(self, parent_user):
		"""
		Configure a sent mail box.
		"""
		win = GtkWindow()
		win.connect("delete_event", quit)
		win.set_title(_("%s Folder Setup") % self.name)

		box = GtkVBox()
		win.add(box)
		box.show()

		notebook = GtkNotebook()
		notebook.set_tab_pos(POS_TOP)
		box.pack_start(notebook)
		notebook.show()

		# first page: misc settings
		settings_box = big_edit_box(self, 
		      ( ("name", _("Name:"), VAR_TYPE_STRING, 0, 0),
			("expire_after", _("Expire after (days):"), VAR_TYPE_INTEGER, 0, None) )
		)
		label = GtkLabel(_("Settings"))
		notebook.append_page(settings_box, label)
		settings_box.show()

		# 2nd page: storage method
		label = GtkLabel(_("Mailbox Format"))
		formatbox = boxformats.configbox.configbox(self, parent_user)
		notebook.append_page(formatbox, label)
		formatbox.show()

		def save_changes(_button, self=self, parent_user=parent_user, win=win, \
				settings_box=settings_box):
			# Extract info
			settings_box.apply_changes()
			# update folder list
			self.changed = 1
			parent_user.update()
			win.destroy()

		# Buttons at bottom
		lastbox = GtkHBox(spacing=5)
		lastbox.set_border_width(10)
		box.pack_start(lastbox, expand=FALSE)
		lastbox.show()

		cancel_button = GtkButton(" "+_("Cancel")+" ")
		cancel_button.connect("clicked", win.destroy)
		lastbox.pack_end(cancel_button, expand=FALSE)
		cancel_button.show()

		ok_button = GtkButton(" "+_("Ok")+" ")
		ok_button.connect("clicked", save_changes)
		lastbox.pack_end(ok_button, expand=FALSE)
		ok_button.show()

		win.show()

