/* typecast_binary.h - definitions for binary typecaster
 *
 * Copyright (C) 2003 Federico Di Gregorio <fog@debian.org>
 *
 * This file is part of psycopg.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PSYCOPG_TYPECAST_BINARY_H
#define PSYCOPG_TYPECAST_BINARY_H 1

#include <Python.h>

#ifdef __cplusplus
extern "C" {
#endif

/** chunk type **/

extern PyTypeObject chunkType;

typedef struct {
    PyObject_HEAD

    void *base;     /* Pointer to the memory chunk. */
    int len;        /* Size in bytes of the memory chunk. */

} chunkObject;

#ifdef __cplusplus
}
#endif

#endif /* !defined(PSYCOPG_TYPECAST_BINARY_H) */
