// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_APP_STRING__HH
#define PSPELL_APP_STRING__HH

#include <string.h>

class PspellAppendableString {
public:
  virtual void append(const char *, unsigned int) = 0;
  virtual void append(const char *in) {append(in,strlen(in));}
  PspellAppendableString & operator += (const char * in) {
    append(in);
    return *this;
  }
};

#endif
