# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: error.t,v 1.1 2000/11/30 09:20:16 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::Error;
use PSP::Error::Field;
use PSP::Error::Verify;

my $n_iterations = 1;
plan tests => $n_iterations * 26;

my $error;
for (my $i=0; $i < $n_iterations; $i++) {

ok $error = PSP::Error->new("foo");
ok $error->name() eq "foo";

ok $error->add_error("This is an error message.");
ok $error->add_error("This is an bar error message","bar");
ok $error->add_error("This is an baz error message","baz");
ok $error->add_error("This is another bar error message","bar");
ok $error->add_error("This is yet another bar error message","bar");
ok $error->add_error("This is a bar,buf error message","bar","buf");
ok $error->add_error("This is the 4th bar error message","bar");
ok $error->add_error("This is the 2nd bar,buf error message","bar","buf");

ok $error->as_string() eq
"This is an error message.
  This is an bar error message
  This is another bar error message
  This is yet another bar error message
  This is the 4th bar error message
    This is a bar,buf error message
    This is the 2nd bar,buf error message
  This is an baz error message\n";

ok $error->as_bullets() eq
"This is an error message.
<ul>
<li>
  This is an bar error message<br>
  This is another bar error message<br>
  This is yet another bar error message<br>
  This is the 4th bar error message
<ul>
<li>
    This is a bar,buf error message<br>
    This is the 2nd bar,buf error message
</ul>
<li>
  This is an baz error message
</ul>\n";

ok $error->as_html() eq
"This is an error message.<br>
&nbsp; This is an bar error message<br>
&nbsp; This is another bar error message<br>
&nbsp; This is yet another bar error message<br>
&nbsp; This is the 4th bar error message<br>
&nbsp; &nbsp; This is a bar,buf error message<br>
&nbsp; &nbsp; This is the 2nd bar,buf error message<br>
&nbsp; This is an baz error message<br>\n";


ok !$error->free();

ok $error = PSP::Error::Field->new("");
ok $error->name() eq "";

ok $error->add_error("a bar error.","bar");
ok $error->add_error("a baz error.","baz");
ok $error->add_error("another bar error.","bar");
ok $error->add_error("an erf within foo error.","foo","erf");
ok $error->add_error("a crunph within foo error.","foo","crunph");
ok $error->add_error("a sigh within foo error.","foo","sigh");

ok $error->as_string() eq
"bar:
  a bar error.
  another bar error.
baz:
  a baz error.
foo:erf:
    an erf within foo error.
foo:crunph:
    a crunph within foo error.
foo:sigh:
    a sigh within foo error.\n";

ok $error->as_html() eq
"bar:
&nbsp; a bar error.<br>
&nbsp; another bar error.<br>
baz:
&nbsp; a baz error.<br>
foo:erf:
&nbsp; &nbsp; an erf within foo error.<br>
foo:crunph:
&nbsp; &nbsp; a crunph within foo error.<br>
foo:sigh:
&nbsp; &nbsp; a sigh within foo error.<br>\n";

ok $error->as_bullets() eq
"<ul>
<li>
bar:
  a bar error.<br>
  another bar error.
<li>
baz:
  a baz error.
<li>
<ul>
<li>
foo:erf:
    an erf within foo error.
<li>
foo:crunph:
    a crunph within foo error.
<li>
foo:sigh:
    a sigh within foo error.
</ul>
</ul>\n";

ok !$error->free();
#print Dumper($error);
}
