package PSP::Parser::Error;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Error.pm,v 1.2 2001/01/21 12:24:18 muaddib Exp $

use strict;

=head1 NAME

 PSP::Parser::Error - Tag extension for error handling.

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

use Error qw(:try);
use PSP::Parser;
use PSP::Utils;
use HTMLIO::Utils;

BEGIN {
  @PSP::Parser::Error::ISA = qw(PSP::Parser);
}

use vars qw(@handled @propagatable);
BEGIN {
  @handled = qw(errorreport handle throw);
};

=head1 TAG HANDLERS

=head2 begin_psperrorreport

 [private] instance
 () begin_psperrorreport (string $tag, \%attributes)

DESCRIPTION:

See PSP specification.

=cut

sub begin_psperrorreport {
  my ($this, $tag, $attr) = @_;

  $this->code('if ($fs->errors_p())');
  $this->begin_pspblock('fs->errors_p');

  $this->code('my %to_process; @to_process{ %{$fs->{errors}||{}} } = 1;');
  $this->code('for my $err (qw(field verify), sort keys %to_process)');
  $this->begin_pspblock('for(err)');

  $this->code('delete $to_process{$err} or next;');
  $this->code('my $error_obj = $fs->{errors}->{$err} or next;');
}

=head2 end_psperrorreport

 [private] instance
 () end_psperrorreport (string $tag)

DESCRIPTION:

See PSP specification.

=cut

sub end_psperrorreport {
  my ($this) = @_;

  $this->end_pspblock('while(error_obj)');
  $this->end_pspblock('if(fs->errors_p)');
}

=head2 begin_psphandle

 [private] instance
 () begin_psphandle (string $tag, \%attributes)

DESCRIPTION:

See PSP specification.

=cut

sub begin_psphandle {
  my ($this, $tag, $attr) = @_;

  my $type = $attr->{type} or throw
    Error::Simple("<$tag> requires a TYPE attribute.");

  $this->code('if (\$error_obj->isa("'.$type.'"))');
  $this->begin_pspblock('handle');
}

=head2 end_psphandle

 [private] instance
 () end_psphandle (string $tag)

DESCRIPTION:

See PSP specification.

=cut

sub end_psphandle {
  my ($this, $tag) = @_;
  $this->end_pspblock('handle');
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<HTML::Parser>, L<HTMLIO::Utils>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
