# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: Makefile.PL,v 1.1 2000/11/23 23:36:18 muaddib Exp $

require 5.004;
use strict;
use ExtUtils::MakeMaker;

my @MODULES = qw(
  Parser/Control.pm
  Parser/Error.pm
  Parser/Form.pm
  Compiler.pm
  Parser.pm
);

my %PM = map { $_ => '$(INST_LIBDIR)/PSP/'.$_ } @MODULES;

my @programs_to_install = qw(piler);

WriteMakefile(
    'NAME'         => 'PSP-Parser',
    'VERSION_FROM' => 'Parser.pm',
    'PL_FILES'     => { map {("bin/$_.PL" => "bin/$_")} @programs_to_install },
    'EXE_FILES'    => [ map {"bin/$_"} @programs_to_install ],
    'PM'	   => \%PM,
    'clean'        => { FILES => '$(EXE_FILES)' },
    'dist'         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' }
);

