/****************************************************************************
** userlist.h - higher-level version of JabRoster
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef USERLIST_H
#define USERLIST_H

#include<qptrlist.h>
#include<qstring.h>
#include<qdatetime.h>
#include"jabcommon.h"
#include"common.h"
#include"message.h"

#define USERLIST_CONTACTS       1
#define USERLIST_SERVICES       2

#define USERLIST_ALL            3


class UserListItem
{
public:
        UserListItem();
	~UserListItem();

        QString jid;
        QString nick;
        QString group;
        QString sub;
        int state;
        QString statusString;
        bool inList;
        bool isTransport;

	JabResourceList res;
};

class UserList
{
public:
        UserList();
        ~UserList();

        int size();
        void add(UserListItem *);
        void remove(UserListItem *);
        void remove(QString &jid);
        UserListItem *findByJid(const QString &jid);
        UserListItem *findServiceByJid(const QString &jid);
        UserListItem *findAnyByJid(const QString &jid);
        void clear();
        //int allQueuesEmpty();

        UserListItem *start(int);
        UserListItem *next();
        void end();

private:
        void advanceTo();

        int num;
        QPtrList<UserListItem> list;
        QPtrListIterator<UserListItem> *it;
        int searchtype;
};

class Account
{
public:
	Account();

	QString jid() const;

	QString user, pass, host, resource;
	int port, priority;
};

#endif
