/****************************************************************************
** eventdlg.h - multi-window chat dialog for sending/receiving events
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef EVENTDLG_H
#define EVENTDLG_H

#include<qwidget.h>
#include<qlayout.h>
#include<qlabel.h>
#include<qpushbutton.h>
#include<qtoolbutton.h>
#include<qlineedit.h>
#include<qpixmap.h>
#include<qgroupbox.h>
#include<qdropsite.h>
#include<qcombobox.h>

#include"message.h"
#include"msgmle.h"
#include"userlist.h"
#include"anim.h"
#include"uniquewindow.h"

class AnimatedButton : public QPushButton
{
	Q_OBJECT
public:
	AnimatedButton(QWidget *parent=0, const char *name=0);

	void setAnim(Anim *);
	bool isActive() { return v_isActive; }

private:
	Anim *anim;
	bool v_isActive;
	QTimer *t;
	int animStep;

	void changeIcon(const QPixmap &);

private slots:
	void animate();
};


class ELineEdit : public QLineEdit
{
	Q_OBJECT
public:
	ELineEdit(QWidget *parent=0, const char *name=0);

protected:
	void dragEnterEvent(QDragEnterEvent *);
	void dropEvent(QDropEvent *);
};

class EventDlg : public QWidget, public UniqueWindow
{
	Q_OBJECT
public:
	EventDlg(UserListItem *item, int localStatus, bool isUnique, bool compose=FALSE, bool urlMode=FALSE);
	EventDlg(const QStringList &to, int x_localStatus);
	~EventDlg();

	void init();

	QString & jid() { return v_jid; }
	static EventDlg *find(const QString &);
	static QSize defaultSize();

	// reimplemented
protected:
	void resizeEvent(QResizeEvent *);

signals:
	void aSend(const Message &);
	void aHistory(const QString &jid);
	void aReply(const QString &jid);
	void aReadNext(const QString &jid);
	void aAuth(const QString &jid);
	void aInfo(const QString &jid);
	void aOpenURL(const QString &url);

public slots:
	void localUpdate(const JabRosterEntry &);
	void updateContact(UserListItem *);
	void updateReadNext(int nextType, int amount);
	void updateEvent(const Message &);
	void closeAfterReply();
	void optionsUpdate();

private slots:
	void doHistory();
	void doInfo();
	void doReadNext();
	void doButton1();
	void setCurrentTime();
	void showSubject(bool);
	void showUrl(bool);
	void showMulti();
	void showSingle();
	void goToURL();

private:
	bool isCompose, isMulti;
	QString v_jid, v_nick;
	int v_status;
	int localStatus;
	Anim *eventAnim;
	int eventType;
	Message *msg;
	int numReadNext;
	int nextType;

	QBoxLayout *layout1;
	QWidget *lo_single, *lo_multi;

	QLabel *lb_statusIcon, *lb_statusStr, *lb_eventType, *lb_time;
	QLineEdit *le_nick, *le_jid;
	ELineEdit *le_to;
	QPushButton *pb_toMulti, *pb_toSingle;
	QToolButton *tb_subj, *tb_url, *tb_history, *tb_info;
	QComboBox *cb_eventType;

	// optional subject
	QGroupBox *gb_subj;
	QLabel *lb_subj;
	QLineEdit *le_subj;

	// optional URL
	QGroupBox *gb_url;
	QLabel *lb_url, *lb_desc;
	QLineEdit *le_url, *le_desc;

	QPushButton *pb_button1;
	bool flag_button1;

	AnimatedButton *pb_next;
	MsgMle *mle;

	void setButton1();
	void setTime(const QDateTime &);

	void keyPressEvent(QKeyEvent *e);
};

#endif
