/****************************************************************************
** browsedb.h - maintains a database of the Jabber browsing system
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef BROWSEDB_H
#define BROWSEDB_H

#include<qstring.h>
#include<qstringlist.h>
#include<qptrlist.h>

class JidEntry
{
public:
	JidEntry();

	QString jid;
	QString name;
	QString type;

	bool isRegisterable, isSearchable, isGateway;

	QStringList children;
};

class BrowseDb
{
public:
	BrowseDb();

	void add(const JidEntry &);
	void remove(const QString &);
	JidEntry *find(const QString &);
	void clear();

private:
	QPtrList<JidEntry> list;
};

#endif
