/****************************************************************************
** adduserdlg.cpp - a dialog for adding a contact
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"adduserdlg.h"

#include<qlabel.h>
#include<qlayout.h>
#include<qpushbutton.h>
#include<qpixmap.h>
#include<qframe.h>
#include<qmessagebox.h>
#include<qgroupbox.h>
#include"common.h"


static AddUserDlg *add_ptr = 0;

AddUserDlg::AddUserDlg(const QStringList &_services, const QStringList &names, const QStringList &groups, int _localStatus, QWidget *parent, const char *name)
:AddUserUI(parent, name, FALSE, WDestructiveClose)
{
	add_ptr = this;

	services = _services;
	localStatus = _localStatus;

	active = FALSE;

	setCaption(CAP(tr("Add User")));
	setIcon(*pix_add);

	busy = new BusyWidget(this);
	hb_bottom->insertWidget(0, busy);

	QStringList::ConstIterator it1 = services.begin();
	QStringList::ConstIterator it2 = names.begin();
	for(; it1 != services.end(); ++it1, ++it2)
		cb_service->insertItem(transport2icon(*it1, STATUS_ONLINE), *it2);
	connect(cb_service, SIGNAL(activated(int)), SLOT(serviceActivated(int)));

	QString str = tr("<None>");
	cb_group->insertItem(str);
	cb_group->insertStringList(groups);
	cb_group->setAutoCompletion(TRUE);

	pb_add->setDefault(TRUE);
	connect(pb_add, SIGNAL(clicked()), SLOT(ok()));
	connect(pb_close, SIGNAL(clicked()), SLOT(reject()));
	connect(pb_transGet, SIGNAL(clicked()), SLOT(getTransID()));
	//connect(le_transPrompt, SIGNAL(returnPressed()), SLOT(getTransID()));

	cb_service->setFocus();
}

AddUserDlg::~AddUserDlg()
{
	add_ptr = 0;

	if(active)
		signalCancelTransaction(id);
}

/* static */ AddUserDlg *AddUserDlg::find()
{
	return add_ptr;
}

void AddUserDlg::ok()
{
	if(le_jid->text().isEmpty()) {
		QMessageBox::information(this, tr("Add User: Error"), tr("Please fill in the Jabber ID of the person you wish to add."));
		return;
	}
	if(le_jid->text().find('@') == -1) {
		QMessageBox::information(this, tr("Add User: Error"), tr("The Jabber ID you entered does not contain a '@' symbol.\nMake sure you enter a fully qualified Jabber ID in the form \"user@hostname\"."));
		return;
	}

	Info info;
	info.jid = le_jid->text();
	info.nick = le_nick->text();

	QString gname = cb_group->currentText();
	if(gname == tr("<None>"))
		gname = "";
	info.group = gname;

	add(info);

	accept();
}

void AddUserDlg::serviceActivated(int x)
{
	if(active) {
		signalCancelTransaction(id);
		active = FALSE;
		busy->stop();
	}
	gb_trans->setEnabled(FALSE);
	le_transPrompt->setText("");

	// Jabber entry
	if(x == 0)
		return;
	--x;

	if(x >= 0 && x < (int)services.count()) {
		//printf("Selected: [%s]\n", services[x].latin1());
		signalGetGateway(services[x], &id);
		active = TRUE;
		busy->start();
	}
}

void AddUserDlg::localUpdate(const JabRosterEntry &e)
{
	localStatus = e.localStatus();

	if(localStatus == STATUS_OFFLINE)
		close();
}

void AddUserDlg::slotGetGatewayResponse(const QString &_id, bool ok, const QString &desc)
{
	if(!active)
		return;

	if(_id == id) {
		busy->stop();
		active = FALSE;
		if(ok) {
			gb_trans->setEnabled(TRUE);
			lb_transDesc->setText(desc);
		}
		else {
			errorGateway();
		}
	}
}

void AddUserDlg::slotSetGatewayResponse(const QString &_id, bool ok, const QString &jid)
{
	if(!active)
		return;

	if(_id == id) {
		cb_service->setEnabled(TRUE);
		le_transPrompt->setEnabled(TRUE);
		pb_transGet->setEnabled(TRUE);
		busy->stop();
		active = FALSE;

		if(ok) {
			le_jid->setText(jid);
			le_nick->setText(le_transPrompt->text());
			le_transPrompt->setText("");
			le_jid->setCursorPosition(0);
			le_nick->setCursorPosition(0);

			le_nick->setFocus();
			le_nick->selectAll();
		}
		else {
			errorGateway();
			le_transPrompt->setFocus();
		}
	}
}

void AddUserDlg::getTransID()
{
	cb_service->setEnabled(FALSE);
	le_transPrompt->setEnabled(FALSE);
	pb_transGet->setEnabled(FALSE);

	signalSetGateway(services[cb_service->currentItem()-1], le_transPrompt->text(), &id);
	active = TRUE;
	busy->start();
}

void AddUserDlg::errorGateway()
{
	QMessageBox::information(this, CAP(tr("Error")), tr("<qt>\n"
	  "There was an error getting the Service ID translation information. "
	  "The \"%1\" service may not support this feature.  In this case you "
	  "will need to enter the Jabber ID manually for the contact you wish "
	  "to add.  Examples:<br>\n"
	  "<br>\n"
	  "&nbsp;&nbsp;jabberuser@somehost.com<br>\n"
	  "&nbsp;&nbsp;aoluser@[Jabber ID of AIM Transport]<br>\n"
	  "&nbsp;&nbsp;1234567@[Jabber ID of ICQ Transport]<br>\n"
	  "&nbsp;&nbsp;joe%hotmail.com@[Jabber ID of MSN Transport]<br>\n"
	).arg(cb_service->currentText())
	);
}
