#!/bin/sh

if [ ! -f ./psi ]; then
  echo "The program 'psi' doesn't exist.  Perhaps this is a source package and you have not yet compiled the program?  Go read the INSTALL file."
  exit 1
fi

export PSIDIR=/usr/local/psi

echo [Installing Psi]

mkdir -p $PSIDIR

echo Copying program files to /usr/local/psi
cp -r ./image $PSIDIR
cp -r ./iconsets $PSIDIR
cp -r ./sound $PSIDIR

cp ./psi $PSIDIR
cp ./README $PSIDIR
cp ./COPYING $PSIDIR

mkdir -p /usr/local/bin
if [ -e /usr/local/bin/psi ]; then
  rm /usr/local/bin/psi
fi

echo Putting a link in /usr/local/bin
ln -s $PSIDIR/psi /usr/local/bin/psi

echo [Finished]

