#ifndef BFILE_H_INCLUDED
#define BFILE_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: bfile.h,v 1.6 2004/01/09 20:29:28 type2 Exp $ */

/*
 * This is the binary trace file output and input functions header.
 */

/*
 * ---------------------------- Includes --------------------------------
 */
#include "linux_module.h"
#include "linux_model.h"

/*
 * ----------------------- Global type definitions --------------------------
 */
typedef uint32_t bfile_version_t; 

typedef enum _bfile_buf_type {
    BBUF_INVALID=129,
    BBUF_EOF,
    BBUF_SAMPLES,
    BBUF_NOTES,
    BBUF_FILE_PATH,
    BBUF_GOP_STRUCT,
    BBUF_GCONF_STRUCT,
    BBUF_PROC_STRUCT,
    BBUF_KERN_SYMS,
    BBUF_CHILD_STRUCT,
    BBUF_MAX_NAME
} tBBUFTYPE;

typedef struct _bfile_bufhead {
    ssize_t             size;
    tBBUFTYPE           type;
    ssize_t             dcount;
    char                data[0];
} __attribute__ ((packed)) bfile_bufhead_t;

typedef struct _bfile_filehead {
    ssize_t             size;
    tBBUFTYPE           type;
    pid_t               pid;
    char               *start;
    ssize_t             dcount;
    char                data[0];
} __attribute__ ((packed)) bfile_filehead_t;

typedef struct _bfile_prochead {
    ssize_t             size;
    tBBUFTYPE           type;
    pid_t               pid;
    unsigned int        numregions;
    unsigned int        numstrings;
    ssize_t             dcount;
    char                data[0];
} __attribute__ ((packed)) bfile_prochead_t;

/*
 * ----------------------- Globaly exported data  --------------------------
 */

/* this gets incremented when bfile abi changes */
extern bfile_version_t bfile_version;
/* use this for buffer names with the enum above */
extern char *bbuf_name[];

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void bfile_init_out(void);
void bfile_init_in(void);
void bfile_write(tBBUFTYPE, void *buf, ssize_t size);
void bfile_write_configs(void);
void bfile_write_child(void);
void bfile_write_rpath(region_t *r);
ssize_t bfile_read_fromfile(void *buf, size_t size);
void bfile_process_rpath(bfile_filehead_t *buf, ssize_t size);
void * bfile_read(tBBUFTYPE *bt, ssize_t *size);
void bfile_write_proc(pid_t pid);
void bfile_process_proc(bfile_prochead_t *buf, ssize_t size);

#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif  /* !BFILE_H_INCLUDED */

