/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.FileReader;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.gui.Messages;
import weka.gui.visualize.PrintableComponent;
import weka.gui.visualize.PrintablePanel;

public class AttributeVisualizationPanel
extends PrintablePanel {
    private static final long serialVersionUID = -8650490488825371193L;
    protected Instances m_data;
    protected AttributeStats m_as;
    protected AttributeStats[] m_asCache;
    protected int m_attribIndex;
    protected int m_maxValue;
    protected int[] m_histBarCounts;
    SparseInstance[] m_histBarClassCounts;
    protected double m_barRange;
    protected int m_classIndex;
    private Thread m_hc;
    private boolean m_threadRun = false;
    private boolean m_doneCurrentAttribute = false;
    private boolean m_displayCurrentAttribute = false;
    protected JComboBox m_colorAttrib;
    private FontMetrics m_fm;
    private Integer m_locker = new Integer(1);
    private FastVector m_colorList = new FastVector();
    private static final Color[] m_defaultColors = new Color[]{Color.blue, Color.red, Color.cyan, new Color(75, 123, 130), Color.pink, Color.green, Color.orange, new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0)};

    public AttributeVisualizationPanel() {
        this(false);
    }

    public AttributeVisualizationPanel(boolean showColouringOption) {
        this.setFont(new Font("Default", 0, 9));
        this.m_fm = this.getFontMetrics(this.getFont());
        this.setToolTipText("");
        FlowLayout fl = new FlowLayout(0);
        this.setLayout(fl);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                if (AttributeVisualizationPanel.this.m_data != null) {
                    // empty if block
                }
            }
        });
        this.m_colorAttrib = new JComboBox();
        this.m_colorAttrib.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    AttributeVisualizationPanel.this.m_classIndex = AttributeVisualizationPanel.this.m_colorAttrib.getSelectedIndex() - 1;
                    if (AttributeVisualizationPanel.this.m_as != null) {
                        AttributeVisualizationPanel.this.setAttribute(AttributeVisualizationPanel.this.m_attribIndex);
                    }
                }
            }
        });
        if (showColouringOption) {
            this.add(this.m_colorAttrib);
            this.validate();
        }
    }

    public void setInstances(Instances newins) {
        this.m_attribIndex = 0;
        this.m_as = null;
        this.m_data = new Instances(newins);
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.removeAllItems();
            Messages.getInstance();
            this.m_colorAttrib.addItem(Messages.getString("AttributeVisualizationPanel_SetInstances_ColorAttrib_Text_First"));
            for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                String type = "";
                switch (this.m_data.attribute(i).type()) {
                    case 1: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeNOMINAL_Text");
                        break;
                    }
                    case 0: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeNUMERIC_Text");
                        break;
                    }
                    case 2: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeSTRING_Text");
                        break;
                    }
                    case 3: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeDATE_Text");
                        break;
                    }
                    case 4: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeRELATIONAL_Text");
                        break;
                    }
                    default: {
                        Messages.getInstance();
                        type = Messages.getString("AttributeVisualizationPanel_SetInstances_AttributeDEFAULT_Text");
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                this.m_colorAttrib.addItem(new String(stringBuilder.append(Messages.getString("AttributeVisualizationPanel_SetInstances_ColorAttrib_Text_Second")).append(this.m_data.attribute(i).name()).append(" ").append(type).toString()));
            }
            if (this.m_data.classIndex() >= 0) {
                this.m_colorAttrib.setSelectedIndex(this.m_data.classIndex() + 1);
            } else {
                this.m_colorAttrib.setSelectedIndex(this.m_data.numAttributes());
            }
        }
        this.m_classIndex = this.m_data.classIndex() >= 0 ? this.m_data.classIndex() : this.m_data.numAttributes() - 1;
        this.m_asCache = new AttributeStats[this.m_data.numAttributes()];
    }

    public JComboBox getColorBox() {
        return this.m_colorAttrib;
    }

    public int getColoringIndex() {
        return this.m_classIndex;
    }

    public void setColoringIndex(int ci) {
        this.m_classIndex = ci;
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.setSelectedIndex(ci + 1);
        } else {
            this.setAttribute(this.m_attribIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int index) {
        Integer n = this.m_locker;
        synchronized (n) {
            this.m_threadRun = false;
            this.m_doneCurrentAttribute = false;
            this.m_displayCurrentAttribute = true;
            this.m_attribIndex = index;
            if (this.m_asCache[index] != null) {
                this.m_as = this.m_asCache[index];
            } else {
                this.m_asCache[index] = this.m_data.attributeStats(index);
                this.m_as = this.m_asCache[index];
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcGraph(int panelWidth, int panelHeight) {
        Integer n = this.m_locker;
        synchronized (n) {
            this.m_threadRun = true;
            if (this.m_as.nominalCounts != null) {
                this.m_hc = new BarCalc(panelWidth, panelHeight);
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else if (this.m_as.numericStats != null) {
                this.m_hc = new HistCalc();
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else {
                this.m_histBarCounts = null;
                this.m_histBarClassCounts = null;
                this.m_doneCurrentAttribute = true;
                this.m_threadRun = false;
                this.repaint();
            }
        }
    }

    public String getToolTipText(MouseEvent ev) {
        if (this.m_as != null && this.m_as.nominalCounts != null) {
            float intervalWidth = (float)this.getWidth() / (float)this.m_as.nominalCounts.length;
            int x = 0;
            int y = 0;
            int barWidth = intervalWidth > 5.0f ? (int)Math.floor(intervalWidth * 0.8f) : 1;
            x += (int)(Math.floor(intervalWidth * 0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.1f));
            if (this.getWidth() - (this.m_as.nominalCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_as.nominalCounts.length) > 2) {
                x += (this.getWidth() - (this.m_as.nominalCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_as.nominalCounts.length)) / 2;
            }
            for (int i = 0; i < this.m_as.nominalCounts.length; ++i) {
                float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                y = this.getHeight() - Math.round((float)this.m_as.nominalCounts[i] * heightRatio);
                if (ev.getX() >= x && ev.getX() <= x + barWidth && ev.getY() >= this.getHeight() - Math.round((float)this.m_as.nominalCounts[i] * heightRatio)) {
                    return this.m_data.attribute(this.m_attribIndex).value(i) + " [" + this.m_as.nominalCounts[i] + "]";
                }
                x = x + barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f));
            }
        } else if (!(this.m_threadRun || this.m_histBarCounts == null && this.m_histBarClassCounts == null)) {
            int x = 0;
            boolean y = false;
            double bar = this.m_as.numericStats.min;
            if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                int barWidth = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                x = 3;
                if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                    x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                }
                float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                if (ev.getX() - x >= 0) {
                    int temp = (int)((double)(ev.getX() - x) / ((double)barWidth + 1.0E-10));
                    if (temp == 0) {
                        int sum = 0;
                        for (int k = 0; k < this.m_histBarClassCounts[0].numValues(); ++k) {
                            sum = (int)((double)sum + this.m_histBarClassCounts[0].valueSparse(k));
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_First")).append(sum);
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Second")).append(Utils.doubleToString(bar + this.m_barRange * (double)temp, 3)).append(", ").append(Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3));
                        Messages.getInstance();
                        return stringBuilder3.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Fourth")).toString();
                    }
                    if (temp < this.m_histBarClassCounts.length) {
                        int sum = 0;
                        for (int k = 0; k < this.m_histBarClassCounts[temp].numValues(); ++k) {
                            sum = (int)((double)sum + this.m_histBarClassCounts[temp].valueSparse(k));
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Fifth")).append(sum);
                        Messages.getInstance();
                        StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Sixth")).append(Utils.doubleToString(bar + this.m_barRange * (double)temp, 3)).append(", ").append(Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3));
                        Messages.getInstance();
                        return stringBuilder5.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Eighth")).toString();
                    }
                }
            } else {
                int barWidth = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                x = 3;
                if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                    x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                }
                float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                if (ev.getX() - x >= 0) {
                    int temp = (int)((double)(ev.getX() - x) / ((double)barWidth + 1.0E-10));
                    if (temp == 0) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder6 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Nineth")).append(this.m_histBarCounts[0]);
                        Messages.getInstance();
                        StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Texth")).append(Utils.doubleToString(bar + this.m_barRange * (double)temp, 3)).append(", ").append(Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3));
                        Messages.getInstance();
                        return stringBuilder7.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Twelveth")).toString();
                    }
                    if (temp < this.m_histBarCounts.length) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder8 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Thirteenth")).append(this.m_histBarCounts[temp]);
                        Messages.getInstance();
                        StringBuilder stringBuilder9 = stringBuilder8.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Fourteenth")).append(Utils.doubleToString(bar + this.m_barRange * (double)temp, 3)).append(", ").append(Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3));
                        Messages.getInstance();
                        return stringBuilder9.append(Messages.getString("AttributeVisualizationPanel_GetToolTipText_Text_Sixteenth")).toString();
                    }
                }
            }
        }
        return PrintableComponent.getToolTipText(this.m_Printer);
    }

    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.m_as != null) {
            if (!this.m_doneCurrentAttribute && !this.m_threadRun) {
                this.calcGraph(this.getWidth(), this.getHeight());
            }
            if (!this.m_threadRun && this.m_displayCurrentAttribute) {
                int buttonHeight = 0;
                if (this.m_colorAttrib != null) {
                    buttonHeight = this.m_colorAttrib.getHeight() + this.m_colorAttrib.getLocation().y;
                }
                if (this.m_as.nominalCounts != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int x = 0;
                    int y = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        float intervalWidth = (float)this.getWidth() / (float)this.m_histBarClassCounts.length;
                        int barWidth = intervalWidth > 5.0f ? (int)Math.floor(intervalWidth * 0.8f) : 1;
                        x += (int)(Math.floor(intervalWidth * 0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.1f));
                        if (this.getWidth() - (this.m_histBarClassCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_histBarClassCounts.length) > 2) {
                            x += (this.getWidth() - (this.m_histBarClassCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_histBarClassCounts.length)) / 2;
                        }
                        int sum = 0;
                        for (int i = 0; i < this.m_histBarClassCounts.length; ++i) {
                            float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight) / (float)this.m_maxValue;
                            y = this.getHeight();
                            if (this.m_histBarClassCounts[i] != null) {
                                for (int j = 0; j < this.m_histBarClassCounts[i].numAttributes(); ++j) {
                                    sum = (int)((double)sum + this.m_histBarClassCounts[i].value(j));
                                    y = (int)((long)y - Math.round(this.m_histBarClassCounts[i].value(j) * (double)heightRatio));
                                    g.setColor((Color)this.m_colorList.elementAt(j));
                                    g.fillRect(x, y, barWidth, (int)Math.round(this.m_histBarClassCounts[i].value(j) * (double)heightRatio));
                                    g.setColor(Color.black);
                                }
                            }
                            if ((float)this.m_fm.stringWidth(Integer.toString(sum)) < intervalWidth) {
                                g.drawString(Integer.toString(sum), x, y - 1);
                            }
                            x = x + barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f));
                            sum = 0;
                        }
                    } else {
                        float intervalWidth = (float)this.getWidth() / (float)this.m_histBarCounts.length;
                        int barWidth = intervalWidth > 5.0f ? (int)Math.floor(intervalWidth * 0.8f) : 1;
                        x += (int)(Math.floor(intervalWidth * 0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.1f));
                        if (this.getWidth() - (this.m_histBarCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_histBarCounts.length) > 2) {
                            x += (this.getWidth() - (this.m_histBarCounts.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_histBarCounts.length)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarCounts.length; ++i) {
                            float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight) / (float)this.m_maxValue;
                            y = this.getHeight() - Math.round((float)this.m_histBarCounts[i] * heightRatio);
                            g.fillRect(x, y, barWidth, Math.round((float)this.m_histBarCounts[i] * heightRatio));
                            if ((float)this.m_fm.stringWidth(Integer.toString(this.m_histBarCounts[i])) < intervalWidth) {
                                g.drawString(Integer.toString(this.m_histBarCounts[i]), x, y - 1);
                            }
                            x = x + barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f));
                        }
                    }
                } else if (this.m_as.numericStats != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int x = 0;
                    int y = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        int barWidth = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarClassCounts.length; ++i) {
                            if (this.m_histBarClassCounts[i] == null) continue;
                            float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight - 19.0f) / (float)this.m_maxValue;
                            y = this.getHeight() - 19;
                            int sum = 0;
                            for (int j = 0; j < this.m_histBarClassCounts[i].numValues(); ++j) {
                                y = (int)((long)y - Math.round(this.m_histBarClassCounts[i].valueSparse(j) * (double)heightRatio));
                                g.setColor((Color)this.m_colorList.elementAt(this.m_histBarClassCounts[i].index(j)));
                                if (barWidth > 1) {
                                    g.fillRect(x, y, barWidth, (int)Math.round(this.m_histBarClassCounts[i].valueSparse(j) * (double)heightRatio));
                                } else if (this.m_histBarClassCounts[i].valueSparse(j) * (double)heightRatio > 0.0) {
                                    g.drawLine(x, y, x, (int)((long)y + Math.round(this.m_histBarClassCounts[i].valueSparse(j) * (double)heightRatio)));
                                }
                                g.setColor(Color.black);
                                sum = (int)((double)sum + this.m_histBarClassCounts[i].valueSparse(j));
                            }
                            if (this.m_fm.stringWidth(" " + Integer.toString(sum)) < barWidth) {
                                g.drawString(" " + Integer.toString(sum), x, y - 1);
                            }
                            x += barWidth;
                        }
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                        }
                        g.drawLine(x, this.getHeight() - 17, barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 17);
                        g.drawLine(x, this.getHeight() - 16, x, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), x, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(x + barWidth * this.m_histBarClassCounts.length / 2, this.getHeight() - 16, x + barWidth * this.m_histBarClassCounts.length / 2, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), x + barWidth * this.m_histBarClassCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 16, barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : x + barWidth * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    } else {
                        int barWidth = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarCounts.length; ++i) {
                            float heightRatio = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight - 19.0f) / (float)this.m_maxValue;
                            y = this.getHeight() - Math.round((float)this.m_histBarCounts[i] * heightRatio) - 19;
                            if (barWidth > 1) {
                                g.drawRect(x, y, barWidth, Math.round((float)this.m_histBarCounts[i] * heightRatio));
                            } else if ((float)this.m_histBarCounts[i] * heightRatio > 0.0f) {
                                g.drawLine(x, y, x, y + Math.round((float)this.m_histBarCounts[i] * heightRatio));
                            }
                            if (this.m_fm.stringWidth(" " + Integer.toString(this.m_histBarCounts[i])) < barWidth) {
                                g.drawString(" " + Integer.toString(this.m_histBarCounts[i]), x, y - 1);
                            }
                            x += barWidth;
                        }
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                        }
                        g.drawLine(x, this.getHeight() - 17, barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 17);
                        g.drawLine(x, this.getHeight() - 16, x, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), x, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(x + barWidth * this.m_histBarCounts.length / 2, this.getHeight() - 16, x + barWidth * this.m_histBarCounts.length / 2, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), x + barWidth * this.m_histBarCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 16, barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : x + barWidth * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    }
                } else {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    Messages.getInstance();
                    String string = Messages.getString("AttributeVisualizationPanel_PaintComponent_G_DrawString_Text_First");
                    int n = this.getWidth() / 2;
                    Messages.getInstance();
                    g.drawString(string, n - this.m_fm.stringWidth(Messages.getString("AttributeVisualizationPanel_PaintComponent_StringWidth_Text_First")) / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
                }
            } else if (this.m_displayCurrentAttribute) {
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                Messages.getInstance();
                String string = Messages.getString("AttributeVisualizationPanel_PaintComponent_G_DrawString_Text_Second");
                int n = this.getWidth() / 2;
                Messages.getInstance();
                g.drawString(string, n - this.m_fm.stringWidth(Messages.getString("AttributeVisualizationPanel_PaintComponent_StringWidth_Text_Second")) / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
            } else if (!this.m_displayCurrentAttribute) {
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                Messages.getInstance();
                String string = Messages.getString("AttributeVisualizationPanel_PaintComponent_G_DrawString_Text_Third");
                int n = this.getWidth() / 2;
                Messages.getInstance();
                g.drawString(string, n - this.m_fm.stringWidth(Messages.getString("AttributeVisualizationPanel_PaintComponent_StringWidth_Text_Third")) / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            Messages.getInstance();
            JFrame jf = new JFrame(Messages.getString("AttributeVisualizationPanel_Main_JFrame_Text"));
            AttributeVisualizationPanel ap = new AttributeVisualizationPanel();
            try {
                Instances ins = new Instances(new FileReader(args[0]));
                ap.setInstances(ins);
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_Main_Text_First")).append(args[0]);
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("AttributeVisualizationPanel_Main_Text_Second")).append(ap.m_data.relationName());
                Messages.getInstance();
                System.out.println(stringBuilder3.append(Messages.getString("AttributeVisualizationPanel_Main_Text_Third")).append(ap.m_data.numAttributes()).toString());
                ap.setAttribute(Integer.parseInt(args[1]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            Messages.getInstance();
            System.out.println(Messages.getString("AttributeVisualizationPanel_Main_Text_Fourth"));
            for (int i = 0; i < ap.m_data.numAttributes(); ++i) {
                System.out.println(ap.m_data.attribute(i).name());
            }
            jf.setSize(500, 300);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)ap, "Center");
            jf.setDefaultCloseOperation(3);
            jf.setVisible(true);
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("AttributeVisualizationPanel_Main_Text_Fifth"));
        }
    }

    private class HistCalc
    extends Thread {
        private HistCalc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    int i;
                    double intervalWidth = 0.0;
                    intervalWidth = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int intervals = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / intervalWidth));
                    if (intervals > AttributeVisualizationPanel.this.getWidth() && (intervals = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        intervals = 1;
                    }
                    int[][] histClassCounts = new int[intervals][AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                    double barRange = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)histClassCounts.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0;
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.addElement(Color.black);
                    }
                    for (i = AttributeVisualizationPanel.this.m_colorList.size(); i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++i) {
                        Color pc = m_defaultColors[(i - 1) % 10];
                        int ija = (i - 1) / 10;
                        ija *= 2;
                        for (int j = 0; j < ija; ++j) {
                            pc = pc.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.addElement(pc);
                    }
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        int t = 0;
                        try {
                            if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                            t = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange));
                            if (t == 0) {
                                if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                    int[] nArray = histClassCounts[t];
                                    nArray[0] = nArray[0] + 1;
                                    continue;
                                }
                                int[] nArray = histClassCounts[t];
                                int n2 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                                nArray[n2] = nArray[n2] + 1;
                                continue;
                            }
                            if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                int[] nArray = histClassCounts[t - 1];
                                nArray[0] = nArray[0] + 1;
                                continue;
                            }
                            int[] nArray = histClassCounts[t - 1];
                            int n3 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                            nArray[n3] = nArray[n3] + 1;
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ae) {
                            System.out.println("t:" + t + " barRange:" + barRange + " histLength:" + histClassCounts.length + " value:" + AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) + " min:" + AttributeVisualizationPanel.this.m_as.numericStats.min + " sumResult:" + (AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) + " divideResult:" + (float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange) + " finalResult:" + Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange)));
                        }
                    }
                    for (i = 0; i < histClassCounts.length; ++i) {
                        int sum = 0;
                        for (int j = 0; j < histClassCounts[i].length; ++j) {
                            sum += histClassCounts[i][j];
                        }
                        if (AttributeVisualizationPanel.this.m_maxValue >= sum) continue;
                        AttributeVisualizationPanel.this.m_maxValue = sum;
                    }
                    SparseInstance[] histClassCountsSparse = new SparseInstance[histClassCounts.length];
                    for (int i2 = 0; i2 < histClassCounts.length; ++i2) {
                        SparseInstance tempS;
                        int numSparseValues = 0;
                        for (int j = 0; j < histClassCounts[i2].length; ++j) {
                            if (histClassCounts[i2][j] <= 0) continue;
                            ++numSparseValues;
                        }
                        double[] sparseValues = new double[numSparseValues];
                        int[] sparseIndices = new int[numSparseValues];
                        int count = 0;
                        for (int j = 0; j < histClassCounts[i2].length; ++j) {
                            if (histClassCounts[i2][j] <= 0) continue;
                            sparseValues[count] = histClassCounts[i2][j];
                            sparseIndices[count++] = j;
                        }
                        histClassCountsSparse[i2] = tempS = new SparseInstance(1.0, sparseValues, sparseIndices, histClassCounts[i2].length);
                    }
                    AttributeVisualizationPanel.this.m_histBarClassCounts = histClassCountsSparse;
                    AttributeVisualizationPanel.this.m_barRange = barRange;
                } else {
                    double intervalWidth = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int intervals = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / intervalWidth));
                    if (intervals > AttributeVisualizationPanel.this.getWidth() && (intervals = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        intervals = 1;
                    }
                    int[] histCounts = new int[intervals];
                    double barRange = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)histCounts.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0;
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        int t = 0;
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        try {
                            t = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange));
                            if (t == 0) {
                                int n4 = t;
                                histCounts[n4] = histCounts[n4] + 1;
                                if (histCounts[t] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                                AttributeVisualizationPanel.this.m_maxValue = histCounts[t];
                                continue;
                            }
                            int n5 = t - 1;
                            histCounts[n5] = histCounts[n5] + 1;
                            if (histCounts[t - 1] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = histCounts[t - 1];
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ae) {
                            ae.printStackTrace();
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_First")).append(t);
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Second")).append(barRange);
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Third")).append(histCounts.length);
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Fourth")).append(AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex));
                            Messages.getInstance();
                            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Fifth")).append(AttributeVisualizationPanel.this.m_as.numericStats.min);
                            Messages.getInstance();
                            StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Sixth")).append(AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min);
                            Messages.getInstance();
                            StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Seventh")).append((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange));
                            Messages.getInstance();
                            System.out.println(stringBuilder8.append(Messages.getString("AttributeVisualizationPanel_HistCalc_Run_ArrayIndexOutOfBoundsException_Text_Eighth")).append(Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange))).toString());
                        }
                    }
                    AttributeVisualizationPanel.this.m_histBarCounts = histCounts;
                    AttributeVisualizationPanel.this.m_barRange = barRange;
                }
                AttributeVisualizationPanel.this.m_threadRun = false;
                AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                AttributeVisualizationPanel.this.repaint();
            }
        }
    }

    private class BarCalc
    extends Thread {
        private int m_panelWidth;
        private int m_panelHeight;

        public BarCalc(int panelWidth, int panelHeight) {
            this.m_panelWidth = panelWidth;
            this.m_panelHeight = panelHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues() > this.m_panelWidth) {
                    AttributeVisualizationPanel.this.m_histBarClassCounts = null;
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = false;
                    AttributeVisualizationPanel.this.repaint();
                    return;
                }
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    int i;
                    SparseInstance[] histClassCounts = new SparseInstance[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()];
                    if (AttributeVisualizationPanel.this.m_as.nominalCounts.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[0];
                        for (i = 0; i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++i) {
                            if (AttributeVisualizationPanel.this.m_as.nominalCounts[i] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[i];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0;
                    }
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.addElement(Color.black);
                    }
                    for (i = AttributeVisualizationPanel.this.m_colorList.size(); i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++i) {
                        Color pc = m_defaultColors[(i - 1) % 10];
                        int ija = (i - 1) / 10;
                        ija *= 2;
                        for (int j = 0; j < ija; ++j) {
                            pc = pc.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.addElement(pc);
                    }
                    AttributeVisualizationPanel.this.m_data.sort(AttributeVisualizationPanel.this.m_attribIndex);
                    double[] tempClassCounts = null;
                    int tempAttValueIndex = -1;
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        if (AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) != (double)tempAttValueIndex) {
                            if (tempClassCounts != null) {
                                SparseInstance tempS;
                                int numNonZero = 0;
                                for (int z = 0; z < tempClassCounts.length; ++z) {
                                    if (!(tempClassCounts[z] > 0.0)) continue;
                                    ++numNonZero;
                                }
                                double[] nonZeroVals = new double[numNonZero];
                                int[] nonZeroIndices = new int[numNonZero];
                                int count = 0;
                                for (int z = 0; z < tempClassCounts.length; ++z) {
                                    if (!(tempClassCounts[z] > 0.0)) continue;
                                    nonZeroVals[count] = tempClassCounts[z];
                                    nonZeroIndices[count++] = z;
                                }
                                histClassCounts[tempAttValueIndex] = tempS = new SparseInstance(1.0, nonZeroVals, nonZeroIndices, tempClassCounts.length);
                            }
                            tempClassCounts = new double[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                            tempAttValueIndex = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex);
                        }
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                            tempClassCounts[0] = tempClassCounts[0] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                            continue;
                        }
                        int n2 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                        tempClassCounts[n2] = tempClassCounts[n2] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                    }
                    if (tempClassCounts != null) {
                        SparseInstance tempS;
                        int numNonZero = 0;
                        for (int z = 0; z < tempClassCounts.length; ++z) {
                            if (!(tempClassCounts[z] > 0.0)) continue;
                            ++numNonZero;
                        }
                        double[] nonZeroVals = new double[numNonZero];
                        int[] nonZeroIndices = new int[numNonZero];
                        int count = 0;
                        for (int z = 0; z < tempClassCounts.length; ++z) {
                            if (!(tempClassCounts[z] > 0.0)) continue;
                            nonZeroVals[count] = tempClassCounts[z];
                            nonZeroIndices[count++] = z;
                        }
                        histClassCounts[tempAttValueIndex] = tempS = new SparseInstance(1.0, nonZeroVals, nonZeroIndices, tempClassCounts.length);
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_histBarClassCounts = histClassCounts;
                    AttributeVisualizationPanel.this.repaint();
                } else {
                    int[] histCounts = new int[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()];
                    if (AttributeVisualizationPanel.this.m_as.nominalCounts.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[0];
                        for (int i = 0; i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++i) {
                            if (AttributeVisualizationPanel.this.m_as.nominalCounts[i] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[i];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0;
                    }
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        int n3 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex);
                        histCounts[n3] = histCounts[n3] + 1;
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_histBarCounts = histCounts;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                    AttributeVisualizationPanel.this.repaint();
                }
            }
        }
    }
}

