package Gtk::CList;

sub new_with_titles {
  my $class = shift;
  my @headers = @_;

  my $self = {header => \@headers,
	      rows => []};
  
  return bless $self, $class;
}

sub quote {
  my $s = shift;

  $s =~ s/</&lt;/g;
  $s =~ s/>/&gt;/g;
  return $s;
}

sub insert {
  my $self = shift;
  my $id = shift; #remove the first entry
  my @columns = @_;

  my @c = map { quote($_) } @columns;
  push @{$self->{rows}}, [\@c];
}

sub set_row_data {
  my ($self, $row, $data) = @_;

  $self->{rows}->[$row]->[1] = $data;
}

sub get_row_data {
  my ($self, $row) = @_;

  return ${$self->{rows}->[$row]->[1]};
}

sub set_column_widget {
  my ($self, $column, $widget) = @_;

  $self->{header}->[$column] = $widget;
}

sub set_pixtext {
  my ($self, $row, $column, $text, $spacing, $pixmap, $mask) = @_;
  $self->{rows}->[$row]->[0]->[$column] = "<img src=\"$pixmap\"></img>" . " " . $text;
}

sub set_pixmap {
  my ($self, $row, $column, $pixmap, $mask) = @_;

  $self->{rows}->[$row]->[0]->[$column] = "<img src=\"$pixmap\"></img>";
}

sub draw {
  my $self = shift;
  my $session = shift;
  
  my @rows;
  my $counter = 0;
  foreach my $row (@{$self->{rows}}) {
    my $newrow = [];
    for (my $i = 0; $i < @{$row->[0]}; $i++) {
      unless ($self->{invisible}->{$i}) {
	if ($i == 5) {
	  push @$newrow, "<a href=\"/cgi-bin/view.pl?message=" . $self->get_row_data($counter) . 
	      "&session=$session\" target=\"view\">" . $row->[0]->[$i] . "</a>";
	}
	else {
	  push @$newrow, $row->[0]->[$i];
	}
      }
    }
    push @rows, $newrow;
    $counter++;
  }
  
  my @header;
  for (my $i = 0; $i < @{$self->{header}}; $i++) {
    push @header, $self->{header}->[$i] unless $self->{invisible}->{$i};
  }


  $self->{template}->process("messages.html", {title => 'Messages',
					       rows => \@rows,
					       headers => \@header});
}

sub set_compare_func {
  my $self = shift;

  $self->{compare_func} = $_[0];
}

sub set_sort_column {
  my $self = shift;

  $self->{sortcol} = $_[0];
}

sub set_sort_type {
  my ($self, $type) = @_;

  $self->{sortdir} = $type;
}

sub set_column_visibility {
  my ($self, $column, $visibility) = @_;

  if (!$visibility) {
    $self->{invisible}->{$column} = 1;
  }
  elsif (exists $self->{invisible}->{$column}) {
    delete $self->{invisible}->{$column}
  }
}

sub sort {
  my $self = shift;

  my @sorted = sort { 
    $self->{compare_func}->(undef, $a->[0]->[$self->{sortcol}], $b->[0]->[$self->{sortcol}])
      } @{$self->{rows}};

  if ($self->{sortdir} eq "ascending") {
    $self->{rows} = \@sorted;
  }
  else {
    my @r = reverse @sorted;
    $self->{rows} = \@r;
  }
					  
}

sub clear {
  $self->{rows} = [];
}

sub style {
  return new Dummy;
}

sub AUTOLOAD {
  return;
}

1;

package Dummy;
  
sub new {
  my $class = shift;

  my $self = {};

  return bless $self, $class;
}

sub bg {
  return;
}
