/**
 ** Standalone startup code for Linux PROM emulator.
 ** Copyright 1999 Pete A. Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
/*
 * $Id: head.S,v 1.12 2002/07/23 05:47:09 zaitcev Exp $
 */

#include <psr.h>
#include <asi.h>
#include <crs.h>
/* #include <asm/head.h> */	/* Trap entries. Do not use. */
#include "phys_jj.h"

#define C_LABEL(name)	name
#define REGWIN_SZ   0x40

#define WRITE_PAUSE    nop; nop; nop; /* Have to do this after %wim/%psr chg */

  /* 22 is 24-2, (va)>>(SRMMU_PGDIR_SHIFT-PTESIZESHFT) */
#define VATOPGDOFF(va) (((va)>>22)&0x3FC)
#define VATOPMDOFF(va) (((va)>>16)&0xFC)

#define NOP_INSN       0x01000000     /* Used to patch sparc_save_state */

/* Here are some trap goodies */

#if 0
/* Generic trap entry. */
#define TRAP_ENTRY(type, label) \
	rd %psr, %l0; b label; rd %wim, %l3; nop;
#endif

/* Data/text faults. */
#define SRMMU_TFAULT rd %psr, %l0; rd %wim, %l3; b C_LABEL(srmmu_fault); mov 1, %l7;
#define SRMMU_DFAULT rd %psr, %l0; rd %wim, %l3; b C_LABEL(srmmu_fault); mov 0, %l7;

#if 0
/* This is for traps we should NEVER get. */
#define BAD_TRAP(num) \
        rd %psr, %l0; mov num, %l7; b bad_trap_handler; rd %wim, %l3;

/* This is for traps when we want just skip the instruction which caused it */
#define SKIP_TRAP(type, name) \
	jmpl %l2, %g0; rett %l2 + 4; nop; nop;

/* Notice that for the system calls we pull a trick.  We load up a
 * different pointer to the system call vector table in %l7, but call
 * the same generic system call low-level entry point.  The trap table
 * entry sequences are also HyperSparc pipeline friendly ;-)
 */

/* Software trap for Linux system calls. */
#define LINUX_SYSCALL_TRAP \
        sethi %hi(C_LABEL(sys_call_table)), %l7; \
        or %l7, %lo(C_LABEL(sys_call_table)), %l7; \
        b linux_sparc_syscall; \
        rd %psr, %l0;

/* Software trap for SunOS4.1.x system calls. */
#define SUNOS_SYSCALL_TRAP \
        rd %psr, %l0; \
        sethi %hi(C_LABEL(sunos_sys_table)), %l7; \
        b linux_sparc_syscall; \
        or %l7, %lo(C_LABEL(sunos_sys_table)), %l7;

/* Software trap for Slowaris system calls. */
#define SOLARIS_SYSCALL_TRAP \
        b solaris_syscall; \
        rd %psr, %l0; \
        nop; \
        nop;

#define INDIRECT_SOLARIS_SYSCALL(x) \
	mov x, %g1; \
	b solaris_syscall; \
	rd %psr, %l0; \
	nop;

#define BREAKPOINT_TRAP \
	b breakpoint_trap; \
	rd %psr,%l0; \
	nop; \
	nop;

/* Software trap for Sparc-netbsd system calls. */
#define NETBSD_SYSCALL_TRAP \
        sethi %hi(C_LABEL(sys_call_table)), %l7; \
        or %l7, %lo(C_LABEL(sys_call_table)), %l7; \
        b bsd_syscall; \
        rd %psr, %l0;

/* The Get Condition Codes software trap for userland. */
#define GETCC_TRAP \
        b getcc_trap_handler; mov %psr, %l0; nop; nop;

/* The Set Condition Codes software trap for userland. */
#define SETCC_TRAP \
        b setcc_trap_handler; mov %psr, %l0; nop; nop;

/* This is for hard interrupts from level 1-14, 15 is non-maskable (nmi) and
 * gets handled with another macro.
 */
#define TRAP_ENTRY_INTERRUPT(int_level) \
        mov int_level, %l7; rd %psr, %l0; b real_irq_entry; rd %wim, %l3;

/* NMI's (Non Maskable Interrupts) are special, you can't keep them
 * from coming in, and basically if you get one, the shows over. ;(
 * On the sun4c they are usually asynchronous memory errors, on the
 * the sun4m they could be either due to mem errors or a software
 * initiated interrupt from the prom/kern on an SMP box saying "I
 * command you to do CPU tricks, read your mailbox for more info."
 */
#define NMI_TRAP \
        rd %wim, %l3; b linux_trap_nmi_sun4c; mov %psr, %l0; nop;

#endif

/* Window overflows/underflows are special and we need to try to be as
 * efficient as possible here....
 */
#define WINDOW_SPILL \
        rd %psr, %l0; rd %wim, %l3; b spill_window_entry; nop;

#define WINDOW_FILL \
        rd %psr, %l0; rd %wim, %l3; b fill_window_entry; nop;

#define STUB_TRAP	ba stub_trap; nop; nop; nop;

#define TRAP_ENTRY(a,b)		STUB_TRAP
#define SKIP_TRAP(a,b)		STUB_TRAP
#define SUNOS_SYSCALL_TRAP	STUB_TRAP
#define SOLARIS_SYSCALL_TRAP	STUB_TRAP
#define NETBSD_SYSCALL_TRAP	STUB_TRAP
#define LINUX_SYSCALL_TRAP	STUB_TRAP
#define BREAKPOINT_TRAP		STUB_TRAP
#define NMI_TRAP		STUB_TRAP
#define GETCC_TRAP		STUB_TRAP
#define SETCC_TRAP		STUB_TRAP
#define BAD_TRAP(n)		STUB_TRAP
#define	TRAP_ENTRY_INTERRUPT(i)		STUB_TRAP
#define	INDIRECT_SOLARIS_SYSCALL(i)	STUB_TRAP

	.section ".text"
	.globl start, _start
_start:
start:
	.globl spill_window_entry, fill_window_entry
C_LABEL(trapbase):
t_zero:	b goprol; nop; nop; nop;
t_tflt:	SRMMU_TFAULT                        /* Inst. Access Exception        */
t_bins:	TRAP_ENTRY(0x2, bad_instruction)    /* Illegal Instruction           */
t_pins:	TRAP_ENTRY(0x3, priv_instruction)   /* Privileged Instruction        */
t_fpd:	TRAP_ENTRY(0x4, fpd_trap_handler)   /* Floating Point Disabled       */
t_wovf:	WINDOW_SPILL                        /* Window Overflow               */
t_wunf:	WINDOW_FILL                         /* Window Underflow              */
t_mna:	TRAP_ENTRY(0x7, mna_handler)        /* Memory Address Not Aligned    */
t_fpe:	TRAP_ENTRY(0x8, fpe_trap_handler)   /* Floating Point Exception      */
t_dflt:	SRMMU_DFAULT                        /* Data Miss Exception           */
t_tio:	TRAP_ENTRY(0xa, do_tag_overflow)    /* Tagged Instruction Ovrflw     */
t_wpt:	TRAP_ENTRY(0xb, do_watchpoint)      /* Watchpoint Detected           */
t_badc:	BAD_TRAP(0xc) BAD_TRAP(0xd) BAD_TRAP(0xe) BAD_TRAP(0xf) BAD_TRAP(0x10)
t_irq1:	TRAP_ENTRY_INTERRUPT(1)             /* IRQ Software/SBUS Level 1     */
t_irq2:	TRAP_ENTRY_INTERRUPT(2)             /* IRQ SBUS Level 2              */
t_irq3:	TRAP_ENTRY_INTERRUPT(3)             /* IRQ SCSI/DMA/SBUS Level 3     */
t_irq4:	TRAP_ENTRY_INTERRUPT(4)             /* IRQ Software Level 4          */
t_irq5:	TRAP_ENTRY_INTERRUPT(5)             /* IRQ SBUS/Ethernet Level 5     */
t_irq6:	TRAP_ENTRY_INTERRUPT(6)             /* IRQ Software Level 6          */
t_irq7:	TRAP_ENTRY_INTERRUPT(7)             /* IRQ Video/SBUS Level 5        */
t_irq8:	TRAP_ENTRY_INTERRUPT(8)             /* IRQ SBUS Level 6              */
t_irq9:	TRAP_ENTRY_INTERRUPT(9)             /* IRQ SBUS Level 7              */
t_irq10:TRAP_ENTRY_INTERRUPT(10)            /* IRQ Timer #1 (one we use)     */
t_irq11:TRAP_ENTRY_INTERRUPT(11)            /* IRQ Floppy Intr.              */
t_irq12:TRAP_ENTRY_INTERRUPT(12)            /* IRQ Zilog serial chip         */
t_irq13:TRAP_ENTRY_INTERRUPT(13)            /* IRQ Audio Intr.               */
t_irq14:TRAP_ENTRY_INTERRUPT(14)            /* IRQ Timer #2                  */
t_nmi:	NMI_TRAP                            /* Level 15 (NMI)                */
t_racc:	TRAP_ENTRY(0x20, do_reg_access)     /* General Register Access Error */
t_iacce:BAD_TRAP(0x21)                      /* Instr Access Error            */
t_bad22:BAD_TRAP(0x22) BAD_TRAP(0x23)
t_cpdis:TRAP_ENTRY(0x24, do_cp_disabled)    /* Co-Processor Disabled         */
t_uflsh:SKIP_TRAP(0x25, unimp_flush)        /* Unimplemented FLUSH inst.     */
t_bad26:BAD_TRAP(0x26) BAD_TRAP(0x27)
t_cpexc:TRAP_ENTRY(0x28, do_cp_exception)   /* Co-Processor Exception        */
t_dacce:SRMMU_DFAULT                        /* Data Access Error             */
t_hwdz:	TRAP_ENTRY(0x2a, do_hw_divzero)     /* Division by zero, you lose... */
t_dserr:BAD_TRAP(0x2b)                      /* Data Store Error              */
t_daccm:BAD_TRAP(0x2c)                      /* Data Access MMU-Miss          */
t_bad2d:               BAD_TRAP(0x2d) BAD_TRAP(0x2e) BAD_TRAP(0x2f)
        BAD_TRAP(0x30) BAD_TRAP(0x31) BAD_TRAP(0x32) BAD_TRAP(0x33)
        BAD_TRAP(0x34) BAD_TRAP(0x35) BAD_TRAP(0x36) BAD_TRAP(0x37)
        BAD_TRAP(0x38) BAD_TRAP(0x39) BAD_TRAP(0x3a) BAD_TRAP(0x3b)
t_iaccm:BAD_TRAP(0x3c)                      /* Instr Access MMU-Miss         */
 BAD_TRAP(0x3d) BAD_TRAP(0x3e) BAD_TRAP(0x3f)
 BAD_TRAP(0x40) BAD_TRAP(0x41) BAD_TRAP(0x42) BAD_TRAP(0x43)
 BAD_TRAP(0x44) BAD_TRAP(0x45) BAD_TRAP(0x46) BAD_TRAP(0x47)
 BAD_TRAP(0x48) BAD_TRAP(0x49) BAD_TRAP(0x4a) BAD_TRAP(0x4b)
 BAD_TRAP(0x4c) BAD_TRAP(0x4d) BAD_TRAP(0x4e) BAD_TRAP(0x4f)
 BAD_TRAP(0x50) BAD_TRAP(0x51) BAD_TRAP(0x52) BAD_TRAP(0x53)
 BAD_TRAP(0x54) BAD_TRAP(0x55) BAD_TRAP(0x56) BAD_TRAP(0x57)
 BAD_TRAP(0x58) BAD_TRAP(0x59) BAD_TRAP(0x5a) BAD_TRAP(0x5b)
 BAD_TRAP(0x5c) BAD_TRAP(0x5d) BAD_TRAP(0x5e) BAD_TRAP(0x5f)
 BAD_TRAP(0x60) BAD_TRAP(0x61) BAD_TRAP(0x62) BAD_TRAP(0x63)
 BAD_TRAP(0x64) BAD_TRAP(0x65) BAD_TRAP(0x66) BAD_TRAP(0x67)
 BAD_TRAP(0x68) BAD_TRAP(0x69) BAD_TRAP(0x6a) BAD_TRAP(0x6b)
 BAD_TRAP(0x6c) BAD_TRAP(0x6d) BAD_TRAP(0x6e) BAD_TRAP(0x6f)
 BAD_TRAP(0x70) BAD_TRAP(0x71) BAD_TRAP(0x72) BAD_TRAP(0x73)
 BAD_TRAP(0x74) BAD_TRAP(0x75) BAD_TRAP(0x76) BAD_TRAP(0x77)
 BAD_TRAP(0x78) BAD_TRAP(0x79) BAD_TRAP(0x7a) BAD_TRAP(0x7b)
 BAD_TRAP(0x7c) BAD_TRAP(0x7d) BAD_TRAP(0x7e) BAD_TRAP(0x7f)
t_sunos:SUNOS_SYSCALL_TRAP                  /* SunOS System Call             */
t_sbkpt:BREAKPOINT_TRAP                     /* Software Breakpoint/KGDB      */
t_divz:	BAD_TRAP(0x82)                      /* Divide by zero trap           */
t_flwin:TRAP_ENTRY(0x83, do_flush_windows)  /* Flush Windows Trap            */
t_clwin:BAD_TRAP(0x84)                      /* Clean Windows Trap            */
t_rchk:	BAD_TRAP(0x85)                      /* Range Check                   */
t_funal:BAD_TRAP(0x86)                      /* Fix Unaligned Access Trap     */
t_iovf:	BAD_TRAP(0x87)                      /* Integer Overflow Trap         */
t_slowl:SOLARIS_SYSCALL_TRAP                /* Slowaris System Call          */
t_netbs:NETBSD_SYSCALL_TRAP                 /* Net-B.S. System Call          */
t_bad8a:BAD_TRAP(0x8a) BAD_TRAP(0x8b) BAD_TRAP(0x8c) BAD_TRAP(0x8d)
 BAD_TRAP(0x8e) BAD_TRAP(0x8f)
t_linux:LINUX_SYSCALL_TRAP                  /* Linux System Call             */
t_bad91:BAD_TRAP(0x91) BAD_TRAP(0x92) BAD_TRAP(0x93)
 BAD_TRAP(0x94) BAD_TRAP(0x95) BAD_TRAP(0x96) BAD_TRAP(0x97)
 BAD_TRAP(0x98) BAD_TRAP(0x99) BAD_TRAP(0x9a) BAD_TRAP(0x9b) BAD_TRAP(0x9c) BAD_TRAP(0x9d) BAD_TRAP(0x9e) BAD_TRAP(0x9f)
t_getcc:GETCC_TRAP                          /* Get Condition Codes           */
t_setcc:SETCC_TRAP                          /* Set Condition Codes           */
t_bada2:BAD_TRAP(0xa2) BAD_TRAP(0xa3)
 BAD_TRAP(0xa4) BAD_TRAP(0xa5) BAD_TRAP(0xa6)
t_slowi:INDIRECT_SOLARIS_SYSCALL(156)
 BAD_TRAP(0xa8) BAD_TRAP(0xa9) BAD_TRAP(0xaa) BAD_TRAP(0xab)
 BAD_TRAP(0xac) BAD_TRAP(0xad) BAD_TRAP(0xae) BAD_TRAP(0xaf)
 BAD_TRAP(0xb0) BAD_TRAP(0xb1) BAD_TRAP(0xb2) BAD_TRAP(0xb3)
 BAD_TRAP(0xb4) BAD_TRAP(0xb5) BAD_TRAP(0xb6) BAD_TRAP(0xb7)
 BAD_TRAP(0xb8) BAD_TRAP(0xb9) BAD_TRAP(0xba) BAD_TRAP(0xbb)
 BAD_TRAP(0xbc) BAD_TRAP(0xbd) BAD_TRAP(0xbe) BAD_TRAP(0xbf)
t_badc0:BAD_TRAP(0xc0) BAD_TRAP(0xc1) BAD_TRAP(0xc2) BAD_TRAP(0xc3)
 BAD_TRAP(0xc4) BAD_TRAP(0xc5) BAD_TRAP(0xc6) BAD_TRAP(0xc7)
 BAD_TRAP(0xc8) BAD_TRAP(0xc9) BAD_TRAP(0xca) BAD_TRAP(0xcb)
 BAD_TRAP(0xcc) BAD_TRAP(0xcd) BAD_TRAP(0xce) BAD_TRAP(0xcf)
 BAD_TRAP(0xd0) BAD_TRAP(0xd1) BAD_TRAP(0xd2) BAD_TRAP(0xd3)
t_badd4:BAD_TRAP(0xd4) BAD_TRAP(0xd5) BAD_TRAP(0xd6) BAD_TRAP(0xd7)
 BAD_TRAP(0xd8) BAD_TRAP(0xd9) BAD_TRAP(0xda) BAD_TRAP(0xdb)
 BAD_TRAP(0xdc) BAD_TRAP(0xdd) BAD_TRAP(0xde) BAD_TRAP(0xdf)
 BAD_TRAP(0xe0) BAD_TRAP(0xe1) BAD_TRAP(0xe2) BAD_TRAP(0xe3)
 BAD_TRAP(0xe4) BAD_TRAP(0xe5) BAD_TRAP(0xe6) BAD_TRAP(0xe7)
t_bade8:BAD_TRAP(0xe8) BAD_TRAP(0xe9) BAD_TRAP(0xea) BAD_TRAP(0xeb)
 BAD_TRAP(0xec) BAD_TRAP(0xed) BAD_TRAP(0xee) BAD_TRAP(0xef)
 BAD_TRAP(0xf0) BAD_TRAP(0xf1) BAD_TRAP(0xf2) BAD_TRAP(0xf3)
 BAD_TRAP(0xf4) BAD_TRAP(0xf5) BAD_TRAP(0xf6) BAD_TRAP(0xf7)
 BAD_TRAP(0xf8) BAD_TRAP(0xf9) BAD_TRAP(0xfa) BAD_TRAP(0xfb)
t_badfc:BAD_TRAP(0xfc) BAD_TRAP(0xfd)
dbtrap:	BAD_TRAP(0xfe)                      /* Debugger/PROM breakpoint #1   */
dbtrap2:BAD_TRAP(0xff)                      /* Debugger/PROM breakpoint #2   */	

stub_trap:
   set (PHYS_JJ_TCX_FB + 0xbf0), %g5	/* 2 cells from side */
   set 0x00ffffff, %g4
   sta %g4, [%g5] ASI_M_BYPASS
1:	ba 1b; nop

	.section ".bss"
	.align 8
bss_start:

	.section ".text"

goprol:
	! Verify that we are on a known hardware.
	rd %psr, %g1
	srl %g1, 24, %g7
	subcc %g7, 0x42, %g0	! MicroSPARC-II by TI
	be 2f
	subcc %g7, 0x04, %g0	! MicroSPARC-II by Fujitsu
	be 2f
	 nop
3:
	ba 3b
	 nop
2:

	! Map us high
	! From this point on PROM is not available
	rd %psr, %g1
	or %g1, PSR_PIL, %g1
	wr %g1, 0, %psr
	WRITE_PAUSE

	set     AC_M_CTPR, %g1
	lda     [%g1] ASI_M_MMUREGS, %g1	! get ctx table ptr
	sll     %g1, 0x4, %g1			! make physical addr
	lda     [%g1] ASI_M_BYPASS, %g1		! ptr to level 1 pg_table
	srl     %g1, 0x4, %g1
	sll     %g1, 0x8, %g1			! make phys addr for l1 tbl

	lda	[%g1] ASI_M_BYPASS, %g2		! get l1 entry for 0x0
	srl     %g2, 0x4, %g2
	sll     %g2, 0x8, %g2			! make phys addr for l2 tbl
	lda	[%g2] ASI_M_BYPASS, %g4		! get l2 entry for 0x0

	add	%g1, VATOPGDOFF(PROLBASE), %g3
	lda	[%g3] ASI_M_BYPASS, %g3		! get l1 entry for PROLBASE
	srl     %g3, 0x4, %g3
	sll     %g3, 0x8, %g3			! make phys addr for l2 tbl

	add     %g3, VATOPMDOFF(PROLBASE), %g5
	sta     %g4, [%g5] ASI_M_BYPASS		! place at PROLBASE entry

	/*
	 * Flush cache
	 */
	mov	%g0, %g1		! addr
	set	0x2000, %o0		! const(0x2000)
2:
	subcc	%g1, %o0, %g0
	bcc	1f
	 nop

	sta	%g0, [%g1] ASI_M_DATAC_TAG
	sll	%g1, 1, %g2
	sta	%g0, [%g2] ASI_M_TXTC_TAG

	add	%g1, 0x10, %g1
	ba	2b
	 nop
1:

	/*
	 * Flush old page table references from TLB
	 */
	set	0x400, %g1
	sta %g0, [%g1] ASI_M_FLUSH_PROBE

	/*
	 * Now we can jump.
	 */
	set himem1, %g1
	jmpl %g1 + 0, %g0
	 nop

	.section ".data"

	.align 4
	.globl  C_LABEL(cputyp)
        .globl  C_LABEL(nwindows)
        .globl  C_LABEL(nwindowsm1)
C_LABEL(cputyp):			.word   1
C_LABEL(nwindows):			.word   8
C_LABEL(nwindowsm1):			.word   7

	.align	0x1000		! PAGE_SIZE
	.globl C_LABEL(bootup_user_stack)
C_LABEL(bootup_user_stack):		.skip 0x2000

	.section ".text"
himem1:				! We can use relocated labels now.
	sethi	%hi( C_LABEL(cputyp) ), %o0
	st	%g7, [%o0 + %lo( C_LABEL(cputyp) )]

	/*
	 * Clear trap reporting for good luck.
	 */
	set AC_M_SFAR, %g2
	lda [%g2] ASI_M_MMUREGS, %g0
	set AC_M_SFSR, %g1
	lda [%g1] ASI_M_MMUREGS, %g0

	/*
	 * The code which enables traps is a simplified version of
	 * kernel head.S.
	 *
	 * We know number of windows as 8 so we do not calculate them.
	 * The deadwood is here for any case.
	 */

	/* Turn on Supervisor, EnableFloating, and all the PIL bits.
	 * Also puts us in register window zero with traps off.
	 */
	set	(PSR_PS | PSR_S | PSR_PIL | PSR_EF), %g2
	wr	%g2, 0x0, %psr
	WRITE_PAUSE

	/* I want a kernel stack NOW! */
	set	C_LABEL(bootup_user_stack), %g1
	set	(0x2000 - REGWIN_SZ), %g2
	add	%g1, %g2, %sp
	mov	0, %fp			/* And for good luck */

	/* Zero out our BSS section. */
	set	C_LABEL(bss_start) , %o0	! First address of BSS
	set	C_LABEL(end) , %o1		! Last address of BSS
	ba	2f
	 nop
1:
	st	%g0, [%o0]
2:
	subcc	%o0, %o1, %g0
	bl	1b
	 add	%o0, 0x4, %o0

	mov	2, %g1
	wr	%g1, 0x0, %wim			! make window 1 invalid
	WRITE_PAUSE

#if 0
	wr  %g0, 0x0, %wim
	WRITE_PAUSE
	save
	rd  %psr, %g3
	restore
	and  %g3, PSR_CWP, %g3
	add  %g3, 0x1, %g3
#else
	or	%g0, 8, %g3
#endif

	sethi	%hi( C_LABEL(nwindows) ), %g4
	st	%g3, [%g4 + %lo( C_LABEL(nwindows) )]

	sub	%g3, 0x1, %g3
	sethi	%hi( C_LABEL(nwindowsm1) ), %g4
	st	%g3, [%g4 + %lo( C_LABEL(nwindowsm1) )]

	/* Here we go, start using Linux's trap table... */
	set	C_LABEL(trapbase), %g3
	wr	%g3, 0x0, %tbr
	WRITE_PAUSE

	/* Finally, turn on traps so that we can call c-code. */
	rd	%psr, %g3
	wr	%g3, 0x0, %psr
	WRITE_PAUSE

	wr	%g3, PSR_ET, %psr
	WRITE_PAUSE

	.globl prolmain
	call C_LABEL(prolmain)
	 nop

3:
	b       3b
	 nop

/*
 * Memory access trap handler
 *   %l0  program %psr from trap table entry
 *   %l1  program %pc from hardware
 *   %l2  program %npc from hardware
 *   %l3  program %wim from trap table entry
 *   %l4
 *   %l5
 *   %l6
 *   %l7  text flag from trap table entry
 */
	.section ".data"
	.align 4
	.globl ignore_fault, fault_ignored
C_LABEL(ignore_fault):		.word 0
C_LABEL(fault_ignored):		.word 0

	.section ".text"
	.globl srmmu_fault
C_LABEL(srmmu_fault):

	set AC_M_SFAR, %l6
	set AC_M_SFSR, %l5
	lda [%l6] ASI_M_MMUREGS, %l6
	lda [%l5] ASI_M_MMUREGS, %l5

	set ignore_fault, %l5
	ld [%l5], %l5
	subcc %l5, %g0, %g0		/* NULL pointer trap faults always */
	be 3f
	 nop
	subcc %l5, %l6, %g0
	be 2f
	 nop
3:

   set (PHYS_JJ_TCX_FB + 0xbf0), %g5	/* 2 cells from side */
   set 0x00ffffff, %g4
   sta %g4, [%g5] ASI_M_BYPASS
   add %g5, 8, %g5			/* On right side */
   sta %g4, [%g5] ASI_M_BYPASS
1:	ba 1b; nop

2:
	set C_LABEL(fault_ignored), %l5
	mov 1, %l6
	st %l6, [%l5]

	/*
	 * Skip the faulting instruction.
	 * I think it works when next instruction is a branch even.
	 */
	or %l2, 0, %l1
	add %l2, 4, %l2

	wr %l0, 0, %psr
	WRITE_PAUSE
	jmp %l1
	rett %l2

/*
 * Slow external versions of st_bypass and ld_bypass.
 * rconsole.c uses inlines. We call these in places which are not speed
 * critical, to avoid compiler bugs.
 */
	.globl C_LABEL(st_bypass)
C_LABEL(st_bypass):
	retl
	 sta %o1, [%o0] ASI_M_BYPASS
	.globl C_LABEL(ld_bypass)
C_LABEL(ld_bypass):
	retl
	 lda [%o0] ASI_M_BYPASS, %o0
	.globl C_LABEL(sth_bypass)
C_LABEL(sth_bypass):
	retl
	 stha %o1, [%o0] ASI_M_BYPASS
	.globl C_LABEL(ldh_bypass)
C_LABEL(ldh_bypass):
	retl
	 lduha [%o0] ASI_M_BYPASS, %o0
	.globl C_LABEL(stb_bypass)
C_LABEL(stb_bypass):
	retl
	 stba %o1, [%o0] ASI_M_BYPASS
	.globl C_LABEL(ldb_bypass)
C_LABEL(ldb_bypass):
	retl
	 lduba [%o0] ASI_M_BYPASS, %o0

/*
 * move_phys_high(unsigned newpa, int size)
 * Here we move ourselves from low physical to high physical.
 * We are in a position of a man who stands on a rag which
 * he wants to move somewhere else.
 */
	.globl C_LABEL(move_phys_high)
C_LABEL(move_phys_high):
	save	%sp, -64, %sp

	/*
	 * We jump low so high mappings are free for abuse.
	 */
	set (PROLBASE-0x4000), %l1		! PROLBASE-LOADBASE
	set move_phys_high_atlow, %l0
	sub %l0, %l1, %l0
	jmp %l0
	 nop
move_phys_high_atlow:

	set     AC_M_CTPR, %l1
	lda     [%l1] ASI_M_MMUREGS, %l1	! get ctx table ptr
	sll     %l1, 0x4, %l1			! make physical addr
	lda     [%l1] ASI_M_BYPASS, %l1		! ptr to level 1 pg_table
	srl     %l1, 0x4, %l1
	sll     %l1, 0x8, %i5		! rpa:%i5

	set PROLBASE, %i2		! va:%i2
	set 0x1000, %i3			! PAGE_SIZE:%i3
	mov %i1, %i4			! size:%i4
w_3:
	subcc %i4, %g0, %g0		! while (size > 0)
	ble w_2
	 nop
	sub %i4, %i3, %i4

	/*
	 * Walk tables down to a page, move it.
	 */

	srl %i2, 24, %l0
	and %l0, 0xFF, %l0
	sll %l0, 2, %l0
	add %i5, %l0, %l0
	lda [%l0] ASI_M_BYPASS, %l1
	andcc %l1, 0x03, %g0
	bne i_1
	 nop

1: ba 1b; nop

i_1:
	srl %l1, 4, %l0
	sll %l0, 8, %l0

	srl %i2, 18, %l1
	and %l1, 0x3F, %l1
	sll %l1, 2, %l1
	add %l0, %l1, %l0
	lda [%l0] ASI_M_BYPASS, %l0
	andcc %l0, 0x03, %g0
	bne i_2
	 nop

1: ba 1b; nop

i_2:
	srl %l0, 4, %l0
	sll %l0, 8, %l0

	srl %i2, 12, %l1
	and %l1, 0x3F, %l1
	sll %l1, 2, %l1
	add %l0, %l1, %l0

	srl %i0, 4, %l1
	or %l1, 0xBE, %l1
	sta %l1, [%l0] ASI_M_BYPASS

	add %i3, %i2, %i2	! va += PAGE_SIZE
	add %i3, %i0, %i0	! newpa += PAGE_SIZE
	ba w_3
	 nop
w_2:

	/*
	 * Flush TLB
	 * We lazy to flush cache because we are about to copy anyways.
	 */
	set	0x400, %l1
	sta %g0, [%l1] ASI_M_FLUSH_PROBE

	/*
	 * Copy the stuff over
	 */
	set PROLBASE, %i2		! va:%i2
	set 0x4000, %i3			! ova:%i3 = LOADBASE
	mov %i1, %i4			! size:%i4
	ba w_5
	 nop
w_4:
	ld [%i3], %i5
	add %i3, 4, %i3
	st %i5, [%i2]
	add %i2, 4, %i2
w_5:
	cmp %i4, 0			! while (size > 0)
	bg w_4
	 sub %i4, 4, %i4

	/*
	 * All done, return to high virt and high phys.
	 */
	set move_phys_high_athigh, %l0
	jmp %l0
	 nop
move_phys_high_athigh:

	ret
	 restore
