/***************************************************************************
                 job_queryplaylist_tracks.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de

    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_queryplaylist_tracks.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#include <iostream>

Job_QueryPlaylist_Tracks::Job_QueryPlaylist_Tracks(int _id)
  : id(_id)
{}

void Job_QueryPlaylist_Tracks::run()
{
  int error;

  QList<PLAYLIST_TRACK> *list;

  database->lock();

  list = database->getPlaylistTracksBasis(id);
  error = database->getError();

  database->unlock();

  if(!error) {
    app->lock();

    datadispatcher->eventNewPlaylistTracksBasis(list, id);

    app->unlock();
  }

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_QueryPlaylist_Tracks::~Job_QueryPlaylist_Tracks() {}
