/* Generated by Together */

#ifndef GUI_SELECTOR_H
#define GUI_SELECTOR_H

#include "prokyon.h"

#include "lvi_artist.h"
#include "lvi_album.h"
#include "lvi_medium.h"

#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qlistview.h>
#include <qmap.h>
#include <qlayout.h>

/**
 * Implementiert einen <tt>ISelector</tt> als KDE2-GUI-Interface
 * @version 0.1
 * @author Holger Sattel
 * @since 28.04.2001 
 */
class GUI_Selector: public QTabWidget {
  Q_OBJECT
 public:
  
  GUI_Selector(QWidget *parent=0, const char *name=0);
  
  void setConnectionState(bool state);
  
  void notifyAddReadWriteLock() { rwLock++; }
  void notifyRemoveReadWriteLock() { rwLock--; }

  void notifyMediumAvailabilityChanged(int id, bool state);
  void notifyNewSamplerBasis(QList<ARTISTALBUM> *tracklist);
  void notifyNewFavouritesBasis(QList<ARTISTALBUM> *tracklist);
  void notifyNewArtistAlbumBasis(QList<ARTISTALBUM> *tracklist);
  void notifyNewArtistDelta(QMap<int, QMap<int, DELTAINFO*> > *deltamap);
  void notifyNewMediumBasis(QList<MEDIUM> *mediumlist);
  void notifyNewMedium(MEDIUM *medium);
  void notifyMediumRemoved(int id);
  void notifyNewLocalDeltaBasis(QMap<int, QMap<int, int> > *deltalist);
  void notifyNewLocalDelta(int id, QMap<int, int> delta);
  void notifyNewLocalAlbumDeltaBasis(QMap<int, QMap<QString, int> > *deltalist);
  void notifyNewLocalAlbumDelta(int id, QMap<QString, int> delta);
  void notifyFavouriteChanged(int id, bool state);
  void notifySelectArtistAlbum();
  void clear();
  
  void correctSize();

  ~GUI_Selector();
  
 private:
  int rwLock;
  
  void addButton(QString text, int id, int x1, int x2, int y1, int y2);
  
  void updateStatusBar();
  void resort(QListView*);
  
  void applyLocalDelta(int id, bool isAvailable);
  void applyLocalAlbumDelta(int id, bool isAvailable);

  void showLetter(QString letter);
  void setNewBasisOnTab(QList<ARTISTALBUM>*, QListView*, bool);
  void adjustIconsOnTab(QListView*);

  QMap<int, LVI_Artist*> mapArtistAll;
  QMap<QString, LVI_Album*> mapAllTree;
  QMap<int, LVI_Artist*> mapArtistSplitted;
  QMap<int, LVI_Artist*> mapArtistFavourites;
  QMap<int, LVI_Medium*> mapMediumByID;
  
  QMap<int, QMap<int, int> > *localDelta;
  QMap<int, QMap<QString, int> > *localAlbumDelta;
  
  QMap<int, bool> mapIsAvailable;

  QWidgetStack* artistStack;
  QFrame* artistButtonFrame;
  QGridLayout* artistButtonFrameLayout;
  QFrame* tabArtists;
  QListView* tabCDROM;
  QListView* tabSampler;
  QListView* tabFavourites;
  QListViewItem* lastLVI;
  
  QMap<QString, QListView*> mapArtistList;
  
  bool isConnected;
  bool isLocked;
  


 private slots:
  void slot_contextMenu(QListViewItem* item, const QPoint &point, int);
  void slot_menuAddFavourite(int);
  void slot_menuDeleteFavourite(int);
  void slot_menuDeleteMediumFromDatabase();

  void slot_lviSelected(QListViewItem* lvi);
  void slot_tabSelected(QWidget* widget);
  
//  void slot_buttonSelected_All();
  void slot_buttonSelected_AllTree(); 
  void slot_buttonSelected_Favourites();
  void slot_buttonSelected_0();
  void slot_buttonSelected_A();
  void slot_buttonSelected_B();
  void slot_buttonSelected_C();
  void slot_buttonSelected_D();
  void slot_buttonSelected_E();
  void slot_buttonSelected_F();
  void slot_buttonSelected_G();
  void slot_buttonSelected_H();
  void slot_buttonSelected_I();
  void slot_buttonSelected_J();
  void slot_buttonSelected_K();
  void slot_buttonSelected_L();
  void slot_buttonSelected_M();
  void slot_buttonSelected_N();
  void slot_buttonSelected_O();
  void slot_buttonSelected_P();
  void slot_buttonSelected_Q();
  void slot_buttonSelected_R();
  void slot_buttonSelected_S();
  void slot_buttonSelected_T();
  void slot_buttonSelected_U();
  void slot_buttonSelected_V();
  void slot_buttonSelected_W();
  void slot_buttonSelected_X();
  void slot_buttonSelected_Y();
  void slot_buttonSelected_Z();
};

#endif
