/***************************************************************************
                          gui_searcher.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gui_searcher.h"

#include "jobmanager.h"

#include "job_querydatabase.h"

#include <qlayout.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <libintl.h>
#define _(String) gettext (String)

// ##############################################
// # initialize search gui
// ##############################################
GUI_Searcher::GUI_Searcher(QWidget *parent, const char *name)
	: QFrame(parent, name)
{
	QHBoxLayout *searchblay = new QHBoxLayout(this);

	QVGroupBox *searchbox = new QVGroupBox(_("Search Parameter"), this);
	searchblay->addWidget(searchbox);

	// text Input
	QFrame *phraseframe = new QFrame(searchbox);
	QHBoxLayout *vlay = new QHBoxLayout(phraseframe);
	QLabel *phraselabel = new QLabel("<b>" + QString(_("Phrase")) + ": </b>", phraseframe);
	vlay->addWidget(phraselabel);
	phrase = new QLineEdit("", phraseframe);
	vlay->addWidget(phrase);

	// where to search
	QGroupBox *parabox = new QGroupBox(1, Qt::Horizontal, _("Fields"), searchbox);
	QFrame *paraframe = new QFrame(parabox);
	QGridLayout *grid = new QGridLayout(paraframe, 2, 3);
	filenamecheck = new QCheckBox(_("Path/Filename"), paraframe);
	grid->addWidget(filenamecheck, 0, 0);	
	artistcheck = new QCheckBox(_("Artist"), paraframe);
	grid->addWidget(artistcheck, 0, 1);
	titlecheck = new QCheckBox(_("Title"), paraframe);
	grid->addWidget(titlecheck, 0, 2);
	albumcheck = new QCheckBox(_("Album"), paraframe);
	grid->addWidget(albumcheck, 1, 0);
	commentcheck = new QCheckBox(_("Comment"), paraframe);
	grid->addWidget(commentcheck, 1, 1);

	// the buttons
	QFrame *buttonframe = new QFrame(this);
	searchblay->addWidget(buttonframe);
	QGridLayout *buttongrid = new QGridLayout(buttonframe, 3, 3);
	buttongrid->addColSpacing(0, 10);
	buttongrid->addColSpacing(2, 10);
	button_search = new QPushButton(_("Search"), buttonframe);
	buttongrid->addWidget(button_search, 0, 1);
	QPushButton *button_reset = new QPushButton(_("Reset"), buttonframe);
	buttongrid->addWidget(button_reset, 1, 1);
	QPushButton *button_defaults = new QPushButton(_("Defaults"), buttonframe);
	buttongrid->addWidget(button_defaults, 2, 1);

	connect(phrase, SIGNAL(returnPressed()), this, SLOT(slot_buttonSearch()));
	connect(button_search, SIGNAL(clicked()), this, SLOT(slot_buttonSearch()));
	connect(button_reset, SIGNAL(clicked()), this, SLOT(slot_buttonReset()));
	connect(button_defaults, SIGNAL(clicked()), this, SLOT(slot_buttonDefaults()));

	// set defaults
	defaults[0] = 2;
	defaults[1] = 2;
	defaults[2] = 2;
	defaults[3] = 0;
	defaults[4] = 0;

	slot_buttonDefaults();
}

// ##############################################
// # sallbacks for the buttons
// ##############################################
// search
void GUI_Searcher::slot_buttonSearch()
{
	if(phrase->text() == "") return;
 	jobman->addJob(new Job_QueryDatabase(QUERY_BY_PHRASE, phrase->text(),
 		filenamecheck->isChecked(),
 		artistcheck->isChecked(),
 		titlecheck->isChecked(),
 		albumcheck->isChecked(),
 		commentcheck->isChecked()));
}

// reset phrase
void GUI_Searcher::slot_buttonReset()
{
	phrase->setText("");
}

// set default checks
void GUI_Searcher::slot_buttonDefaults()
{
	filenamecheck->setChecked(defaults[0]);
	artistcheck->setChecked(defaults[1]);
	titlecheck->setChecked(defaults[2]);
	albumcheck->setChecked(defaults[3]);
	commentcheck->setChecked(defaults[4]);
}

void GUI_Searcher::setConnectionState(bool state)
{
	button_search->setEnabled(state);
}

GUI_Searcher::~GUI_Searcher(){
}
