/*
   GNUstep ProjectCenter - http://www.gnustep.org

   Copyright (C) 2000-2004 Free Software Foundation

   Authors: Philippe C.D. Robert
            Serg Stoyan

   This file is part of GNUstep.

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "PCEditor.h"
#include "PCEditorView.h"
#include "PCEditorView+Highlighting.h"

@implementation PCEditorView

static BOOL shouldHighlight = NO;
static int  _tabFlags       = PCTab4Sp;

- (BOOL)becomeFirstResponder
{
  return [editor becomeFirstResponder];
}

- (BOOL)resignFirstResponder
{
  return [editor resignFirstResponder];
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
  return YES;
}

//=============================================================================
// ==== Class methods
//=============================================================================

+ (void)setTabBehaviour:(int)tabFlags
{
    _tabFlags = tabFlags;
}

+ (int)tabBehaviour
{
    return _tabFlags;
}

+ (void)setShouldHighlight:(BOOL)yn
{
    shouldHighlight = yn;
}

+ (BOOL)shouldHighlight
{
    return shouldHighlight;
}

//=============================================================================
// ==== Init
//=============================================================================

- (id)initWithFrame:(NSRect)frameRect textContainer:(NSTextContainer*)tc
{
  if ((self = [super initWithFrame:frameRect textContainer:tc])) 
  {
    shouldHighlight = NO;

    _keywords = [[NSArray alloc] initWithObjects:@"@class",
                                                 @"@selector",
						 @"@interface",
						 @"@implementation",
						 @"@end",
						 @"@protocol",
						 @"#import",
						 @"#include",
						 @"#define",
				                 @"#ifdef",
						 @"#ifndef",
						 @"#if defined",
						 @"#else",
						 @"#elif",
						 @"#endif",
						 @"#pragma",
						 @"#warning",
						 nil];
#ifndef GNUSTEP_BASE_VERSION
      _textStorage = [self textStorage];
#endif

  }
  return self;
}

- (void)dealloc
{
  if (scanner) 
    {
      [scanner release];
    }

  [_keywords release];

  [super dealloc];
}

//=============================================================================
// ==== Accessor methods
//=============================================================================

- (void)setEditor:(PCEditor *)anEditor
{
  editor = anEditor;
}

- (void)setString:(NSString *)aString
{
  [scanner autorelease];
  scanner = [[NSScanner alloc] initWithString:aString];

  [super setString:aString];

  if( shouldHighlight )
    {
      [self highlightText];
    }
}

//=============================================================================
// ==== Text handling
//=============================================================================

- (void)insertText:(id)aString
{
  NSRange txtRange = NSMakeRange(0, [[self textStorage] length]);

  [super insertText:aString];

  if( shouldHighlight )
    {
      [[self textStorage] invalidateAttributesInRange:txtRange];
      [self highlightTextInRange:txtRange];
    }
}

- (void)highlightText
{
  NSRange txtRange = NSMakeRange(0, [[self textStorage] length]);

  [self highlightTextInRange:txtRange];
}

- (void)highlightTextInRange:(NSRange)txtRange
{
  //NSDictionary *aDict;
  //NSArray      *keywords;

/*
  aDict = [NSDictionary dictionaryWithObjectsAndKeys:
			  editorFont, NSFontAttributeName,
			@"UnknownCodeType", @"PCCodeTypeAttributeName",
			nil];
*/

  [_textStorage beginEditing];  
  [_textStorage setAttributes:nil range:txtRange];
  
  // Scan the CodeType first...

  [self colouriseKeywords:_keywords];
  [self colouriseStrings];
  [self colouriseCharStrings];
  [self colouriseComments];
  [self colouriseCPPComments];

  /*
   * BIG HACK!
   */
  
  NS_DURING
    [_textStorage endEditing];
  NS_HANDLER
    NSLog(@"Excpetion: %@",[localException description]);
  NS_ENDHANDLER

  [self setNeedsDisplay:YES];
}

- (void)keyDown:(NSEvent *)anEvent
{
    /*
    NSString *chars = [anEvent charactersIgnoringModifiers];
    int modifiers = [anEvent modifierFlags];

    if(([chars lossyCString][0] == 's') && (modifiers & NSCommandKeyMask))
    {
	[editor saveFile];
	return;
    }
    */

    if( [[anEvent characters] isEqualToString:@"\t"] )
    {
        switch( _tabFlags )
	{
	    case PCTabTab:
	        [self insertText: @"\t"];
	        break;
	    case PCTab2Sp:
	        [self insertText: @"  "];
	        break;
	    case PCTab4Sp:
	        [self insertText: @"    "];
	        break;
	    case PCTab8Sp:
	        [self insertText: @"        "];
	        break;
            default:
	        break;
	}
    }
    else
    {
	[super keyDown:anEvent];
    }
}

@end

