/* $Cambridge: hermes/src/prayer/accountd/config.h,v 1.3 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2002 */
/* See the file NOTICE for conditions of use and distribution. */

/* External interface prototypes to config.c */

typedef enum {
    AUTHTYPE_UNKNOWN,
    AUTHTYPE_PWD,
    AUTHTYPE_PWD_MD5,
    AUTHTYPE_SHADOW,
    AUTHTYPE_SHADOW_MD5,
    AUTHTYPE_PAM
} AUTHTYPE;

struct config {
    /* General options */
    struct pool *pool;          /* Pool for configuration */
    unsigned long accountd_port;        /* Port to run on 0 => none */
    BOOL log_debug;             /* Enable debug logging */
    unsigned long child_timeout;        /* For interaction with children */
    AUTHTYPE authtype;          /* Authenication method */

    /* Location of filter files */
    char *msforward_name;       /* Name of MSforward file on server */
    char *forward_name;         /* Name of .forward  file on server */
    char *aliases_name;         /* Names of vacation aliases on server */
    BOOL filter_restricted;     /* T => restrict filters to "mail/" */

    /* Password changing */
    char *pwd_cmdline;          /* Program to run to change passwords */
    char *pwd_script;           /* Script to run */
    BOOL  pwd_pty;              /* Needs PTY? */

    /* Fullname checking */
    char *checkfull_cmdline;    /* Program to run to change passwords */
    char *checkfull_script;     /* Script to run */
    BOOL  checkfull_pty;        /* Needs PTY? */

    /* Fullname changing */
    char *full_cmdline;         /* Program to run to change passwords */
    char *full_script;          /* Script to run */
    BOOL  full_pty;             /* Needs PTY? */

    /* Quota check */
    char *quota_cmdline;        /* Command line for check quota   */
    BOOL quota_hermes;          /* T => interpret fquota output   */

    /* SSL support stuff */
    BOOL use_ssl;
    char *ssl_cert_file;
    char *ssl_privatekey_file;
    char *ssl_dh_file;
    char *egd_socket;
    unsigned long ssl_rsakey_lifespan;
    unsigned long ssl_rsakey_freshen;
    unsigned long ssl_session_timeout;
    char *ssl_session_dir;
};

struct config *config_create(void);

void config_free(struct config *config);

BOOL config_parse_option(struct config *config, char *option);

BOOL config_parse_file(struct config *config, char *filename);

BOOL config_check(struct config *config);

void config_extract_ssl(struct config *config, struct ssl_config *ssl_config);
