#ifndef	_PPXP_ENV_H
#define	_PPXP_ENV_H

typedef u_int16_t	env_t;

struct env_s {
    const char *name;
    union {
	void *entry;
	bool_t (*set)();
    } d;
    env_t type;
    uid_t user;
    gid_t group;
    u_int16_t mode;
/*    u_int8_t attr;*/
};

#define ENV_MODEMASK    0777

#define	ENV_SYSLOCK	1
#define	ENV_USRLOCK	2

#define	ENV_SECRET	0x20
#define	ENV_PRIVATE	0x40
#define	ENV_HIDE	(ENV_SECRET|ENV_PRIVATE)

#define	ENV_RDONLY	0x80
#define	ENV_SECURE	0x100

#define	ENV_HEX		0x10
#define	ENV_MASK	0x1F

#define	ENV_SET		0
#define	ENV_BOOL	1
#define	ENV_STRING	2
#define	ENV_INT8	3
#define	ENV_INT16	4
#define	ENV_INT32	5
#define	ENV_INT8X	(ENV_INT8|ENV_HEX)
#define	ENV_INT16X	(ENV_INT16|ENV_HEX)
#define	ENV_INT32X	(ENV_INT32|ENV_HEX)

extern int RegisterEnvs();

#endif	/* _PPXP_ENV_H */
