#
#
#
#

proc icon:update_connect_label {label active disabled} {
    global PPxPStatus

    if {$PPxPStatus >= 4} {
	$label configure -foreground $active
    } else {
	$label configure -foreground $disabled
    }
}

proc icon:time {frame} {
    label $frame -textvariable icon_connect_time
    PPxP:UpdateInfoWidget $frame connect \
	{set icon_connect_time [PPxP:ConnectTime]}

    set active   [option get $frame activeForeground   {}]
    set disabled [option get $frame disabledForeground {}]
    PPxP:UpdateStatusWidget $frame \
	[list icon:update_connect_label $frame $active $disabled]

    return $frame
}

proc icon:ind {frame} {
    global TKPPXPDIR IMAGEDIR
    set in_image [image create bitmap \
	-file [file join $IMAGEDIR in6x6.xbm] -foreground blue]
    set out_image [image create bitmap \
	-file [file join $IMAGEDIR out6x6.xbm] -foreground blue]

    Indicator $frame $in_image $out_image 1

    $in_image configure -foreground \
	[option get $frame.inLabel foreground Foreground]
    $out_image configure -foreground \
	[option get $frame.outLabel foreground Foreground]

    return $frame
}

set icon_idle_blink 0

proc icon:update_status_panel {blink_call} {
    global PPxPStatus PPxPInfo icon_status_label_list
    global icon_idle_blink

    if [catch {
	set idle $PPxPInfo(idle)
	set mode $PPxPInfo(mode)
    }] {
	foreach i $icon_status_label_list {
	    [lindex $i 0] configure -foreground [lindex $i 3]
	}
	return
    }
    if {[PPxP:OnLine] && $idle <= 60 && $idle > 0} {
	if {!($icon_idle_blink % 2)} {
	    set fg 5
	} else {
	    set fg 3
	}
	foreach i $icon_status_label_list {
	    [lindex $i 0] configure -foreground [lindex $i $fg]
	}
	if {$idle <= 10} {
	    if !$blink_call {
		set icon_idle_blink 0
	    } else {
		incr icon_idle_blink
	    }
	    if {$icon_idle_blink < 3} {
		after 250 icon:update_status_panel 1
	    }
	} elseif {$idle <= 20} {
	    if !$blink_call {
		set icon_idle_blink 0
		after 500 icon:update_status_panel 1
	    } else {
		set icon_idle_blink 1
	    }
	} elseif {$idle <= 30} {
	    set icon_idle_blink [expr !$icon_idle_blink]
	}
	return
    }
    set icon_idle_blink 0

    foreach i $icon_status_label_list {
	if {$PPxPStatus >= [lindex $i 1]} {
	    set fg 2
	} elseif {$mode == "auto"} {
	    set fg 4
	} else {
	    set fg 3
	}
	[lindex $i 0] configure -foreground [lindex $i $fg]
    }
}

proc icon:stat {frame} {
    global icon_status_label_list

    set f [frame $frame]

    set status_level 1
    foreach i {dialLabel chatLabel authLabel networkLabel} {
	label $f.$i

	set active   [option get $f.$i activeColor   {}]
	set disabled [option get $f.$i disabledColor {}]
	set auto     [option get $f.$i autoColor     {}]
	set idle     [option get $f.$i idleColor     {}]

	lappend icon_status_label_list \
	    [list $f.$i $status_level $active $disabled $auto $idle]
	pack $f.$i -side left -fill x -expand yes

	incr status_level
    }
    PPxP:UpdateStatusWidget $f {icon:update_status_panel 0}
    PPxP:UpdateInfoWidget $f idle {icon:update_status_panel 0}
    PPxP:UpdateInfoWidget $f mode {icon:update_status_panel 0}

    return $f
}

proc icon:update_auto_menu {menu index} {
    global PPxPInfo

    if {$PPxPInfo(mode) == "auto"} {
	set label "Auto OFF"
	set cmd {$PPxP auto off}
    } else {
	set label "Auto ON"
	set cmd {$PPxP auto on}
    }
    $menu entryconfigure $index -under 0 -label $label -command $cmd
}

proc icon:update_connect_menu {menu index} {
    global PPxPStatus

    if {$PPxPStatus > 0} {
	set label "Disconnect"
	set cmd {$PPxP disconnect}
    } else {
	set label "Connect"
	set cmd {$PPxP connect}
    }
    $menu entryconfigure $index -under 0 -label $label -command $cmd
}

proc icon:select_load_conf {window} {
    global PPxP

    set file [Conf:SelectDialog $window.select conf]
    if {$file != ""} {
	$PPxP source $file
	$PPxP env
    }
}

proc icon:create_standard_popup {popup} {
    Popup $popup

    $popup add command -under 0 -label "Auto ON" \
	-command {$PPxP auto on}
    $popup add command -under 0 -label "Connect" \
	-command {$PPxP connect}
    $popup add command -under 0 -label "Load..." \
	-command [list icon:select_load_conf [winfo parent $popup]]
    $popup add command -under 0 -label "Bye" \
	-command {Toplevel:Close .}
    $popup add command -under 0 -label "Quit" \
	-command {Toplevel:Quit .}

    PPxP:UpdateInfoWidget [winfo parent $popup] mode \
	[list icon:update_auto_menu $popup 0]
    PPxP:UpdateStatusWidget [winfo parent $popup] \
	[list icon:update_connect_menu $popup 1]
}

proc icon:toggle_main_window {} {
    global icon_manage_window

    if {[wm state $icon_manage_window] == "normal"} {
	wm withdraw $icon_manage_window
    } else {
	wm deiconify $icon_manage_window
    }
}

proc icon:bind_main_window_state {popup index} {
    global icon_manage_window

    bind $icon_manage_window <Map> \
	[list icon:update_panel_menu $popup $index]
    bind $icon_manage_window <Unmap> \
	[list icon:update_panel_menu $popup $index]
}

proc icon:unbind_main_window_state {} {
    global icon_manage_window

    bind $icon_manage_window <Map> {}
    bind $icon_manage_window <UnMap> {}
}

set icon_panel_menu_updating 0

proc icon:update_panel_menu {popup index} {
    global icon_panel_menu_updating

    if $icon_panel_menu_updating {
	return
    }
    set icon_panel_menu_updating 1

    icon:unbind_main_window_state
    update
    after idle icon:update_panel_menu_idle $popup $index
}

proc icon:update_panel_menu_idle {popup index} {
    global icon_manage_window
    set state [wm state $icon_manage_window]

    if {$state == "normal"} {
	set label "Hide Panel"
    } else {
	set label "Show Panel"
    }
    $popup entryconfigure $index -underline 5 -label $label

    icon:bind_main_window_state $popup $index

    global icon_panel_menu_updating
    set icon_panel_menu_updating 0
}

proc icon:add_panel_menu {popup} {
    $popup add separator
    $popup add command -under 5 -label "Show Panel" \
	-command icon:toggle_main_window

    set index [$popup index "Show Panel"]

    icon:bind_main_window_state $popup $index
}

proc icon:bindtags_all {w} {
    bindtags $w {IconButton all}

    set children [winfo children $w]
    foreach c $children {
	icon:bindtags_all $c
    }
}

proc icon:start_window {w args} {
    set toplevel [winfo toplevel $w]

    set width  [option get $w width {}]
    set height [option get $w height {}]
    if {$width  == ""} {set width  48}
    if {$height == ""} {set height 48}
    wm geometry $toplevel ${width}x${height}
    wm resizable $toplevel false false

    set time [icon:time $w.timePanel]
    set ind  [icon:ind  $w.indicatorPanel]
    set stat [icon:stat $w.statusPanel]

    icon:bindtags_all $w

    icon:create_standard_popup $w.popup
    icon:add_panel_menu $w.popup

    bind IconButton <Button-1> icon:toggle_main_window
    bind IconButton <Button-3> [list Popup:Post $w.popup %X %Y]

    if {[info commands Cmd:CreateMenu] != ""} {
	Popup $w.commandPopup
	Cmd:CreateMenu $w.commandPopup
	bind IconButton <Button-2> [list Popup:Post $w.commandPopup %X %Y]
    }
    pack $w.timePanel -side top
    pack $w.indicatorPanel -side top -fill x
    pack $w.statusPanel -side bottom -fill x
}

proc Icon:Start {main_flag manage_window} {
    global icon_manage_window
    set icon_manage_window $manage_window

    Toplevel:Start .tkppxpIcon TkppxpIcon "tkPPxP" $main_flag \
	icon:start_window {}
}
