/* ui.c
 *
 * Copyright (C) 1999-2000 Yurika.
 *
 * Copyright (C) 2000 Takuo Kitame <kitame@northeye.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <math.h>

#include "all.h"
#include "xpms.h"

#define NONE   (-1)
#define TOGGLE (-2)
#define ACTIVE_TOGGLE (-3)

#ifdef DISABLE_GDK_PIXBUF

#define ANCHOR_SETTING "anchor",GTK_ANCHOR_NORTH_WEST,
#define IMAGE_NAME     "image"
#define IMAGE_TYPE     gnome_canvas_image_get_type()
#define WIDTH_HEIGHT_SET /* */

#else  /* !DISABLE_GDK_PIXBUF */

#define ANCHOR_SETTING /* */
#define IMAGE_NAME     "pixbuf"
#define IMAGE_TYPE     gnome_canvas_pixbuf_get_type()
#define WIDTH_HEIGHT_SET "width_set", TRUE, "height_set", TRUE,

#endif /* !DISABLE_GDK_PIXBUF */

static GtkWidget *widget;

static GnomeCanvasPoints *start_big_points;
static GnomeCanvasPoints *start_small_points;
static GnomeCanvasPoints *start_points;

static GnomeCanvasItem *start;
static GnomeCanvasItem *stop;
static GnomeCanvasItem *start_stop_box;
static GnomeCanvasItem *stats[4];
static GnomeCanvasItem *auto_item;
static GnomeCanvasItem *auto_box_item;
static GnomeCanvasItem *in[12];
static GnomeCanvasItem *out[12];
static GnomeCanvasItem *hm[8];

#ifndef DISABLE_GDK_PIXBUF

static GdkPixbuf *auto_image;
static GdkPixbuf *auto_image_a;
static GdkPixbuf *suuji_image[11];
static GdkPixbuf *suuji_image_a[11];

#else /* DISABLE_GDK_PIXBUF */

static GdkImlibImage *auto_image;
static GdkImlibImage *auto_image_a;
static GdkImlibImage *suuji_image[11];
static GdkImlibImage *suuji_image_a[11];

#endif

enum {
    SIZE_SMALL,
    SIZE_NORMAL,
    SIZE_BIG
};

static gint hm_start_stop_set_blink_mode(gint mode);
static void hm_set(gint connect, gint idle, gint if_show_connect, gint lev);
static void start_stop_set_size (gint lev); /* 0:small 1:normal 2:big */
static void start_stop_set(gint if_start, gint lev);
static void auto_set_size (gint lev); /* 0:small 1:normal 2:big */
static void auto_set(gint yn);
static void stats_set(gint lev);
static void in_set(gint lev);
static void out_set(gint lev);
static gint start_stop_event_cb(GnomeCanvasItem *item, GdkEvent *event, gpointer data);
static gint auto_event_cb(GnomeCanvasItem *item, GdkEvent *event, gpointer data);

void
ui_set_orient(PanelOrientType orient)
{
    return;
}

void
ui_set_size(gint size)
{
    if (!widget) return;
    
    gnome_canvas_set_pixels_per_unit (GNOME_CANVAS(widget), size / 48.0);

    return;
}

void
ui_update(Ppxp *ppxp)
{

    auto_set(ppxp->if_auto);
    stats_set(ppxp->stat);
    in_set(log10(ppxp->inrate) * 3.0);
    out_set(log10(ppxp->outrate) * 3.0);
    hm_set(ppxp->connect, ppxp->idle, NONE, NONE);
    if(ppxp->stat == 0)
        start_stop_set(1, NONE);
    if(ppxp->stat == 4)
        start_stop_set(0, NONE);
    
    switch(ppxp->stat) {
    case 0:
        hm_start_stop_set_blink_mode(0);
        break;
    case 1:
    case 2:
    case 3:
        hm_start_stop_set_blink_mode(1);
        break;
    case 4:
        if(ppxp->idle <= 0 || ppxp->idle > 60){
            hm_start_stop_set_blink_mode(0);
        } else if(ppxp->idle > 30){
            hm_start_stop_set_blink_mode(2);
        } else if(ppxp->idle > 10){
            hm_start_stop_set_blink_mode(3);
        } else {
            hm_start_stop_set_blink_mode(4);
        }
        break;
    }
    
  return;
}

static gint
blink_cb1(gpointer data)
{
    start_stop_set(NONE, TOGGLE);

    return TRUE;
}

static gint
blink_cb2(gpointer data)
{
    start_stop_set(NONE, ACTIVE_TOGGLE);

    return TRUE;
}

static gint
blink_cb3(gpointer data)
{
    hm_set(NONE, NONE, NONE, TOGGLE);
    start_stop_set(NONE, TOGGLE);

    return TRUE;
}

static gint
hm_start_stop_set_blink_mode(gint mode)
{
    gint speeds[] = { 1000, 700, 500 };
    static gint tag = -1;
    static gint stat = 0;

    if(mode == stat) return 0;
    
    if(tag != -1 )
        gtk_timeout_remove(tag);
    switch(mode){
    case 0:
        hm_set(NONE, NONE, 1, 0);
        start_stop_set(NONE,1);
        break;
    case 1:
        hm_set(NONE, NONE, 1, 0);
        tag = gtk_timeout_add(speeds[1], (GtkFunction)blink_cb2, NULL);
        break;
    case 2:
        hm_set(NONE, NONE, 1, 0);
        tag = gtk_timeout_add(speeds[0], (GtkFunction)blink_cb1, NULL);
        break;
    case 3:
        hm_set(NONE, NONE, 0, NONE);
        start_stop_set(NONE, 1);
        tag = gtk_timeout_add(speeds[1], (GtkFunction)blink_cb3, NULL);
        break;
    case 4:
        hm_set(NONE, NONE, 0, NONE);
        tag = gtk_timeout_add(speeds[2], (GtkFunction)blink_cb3, NULL);
        break;
    }
    stat = mode;

    return 0;
}

static void
hm_set_sub(gint time, gint lev)
{
    static gint stat[] = { 0, 0, 0, 0, 0, 0, 0 };
    gint c,t[6];
    gint h,m,s;
    
    h = time / 3600;
    m = (time - h * 3600) / 60;
    s = (time - h * 3600 - m * 60);
    
    if( h >= 100 ) {
        h = 99;
        m = 99;
        s = 99;
    }
    
    t[0] = h / 10;
    t[1] = h - ( t[0] * 10 );
    t[2] = m / 10;
    t[3] = m - ( t[2] * 10 );
    t[4] = s / 10;
    t[5] = s - ( t[4] * 10 );

    for(c = 0; c <= 5; c++) {
        if(t[c] != stat[c] || lev != stat[6] ) {
            if(lev) {
                gnome_canvas_item_set(hm[c],
                                      IMAGE_NAME, suuji_image_a[t[c]], NULL);
            } else {
                gnome_canvas_item_set(hm[c],
                                      IMAGE_NAME, suuji_image[t[c]], NULL);
            }
            stat[c] = t[c];
        }
    }
    if( lev != stat[6] ) {
        if(lev){
            gnome_canvas_item_set(hm[6], IMAGE_NAME, suuji_image_a[10], NULL);
            gnome_canvas_item_set(hm[7], IMAGE_NAME, suuji_image_a[10], NULL);
        } else {
            gnome_canvas_item_set(hm[6], IMAGE_NAME, suuji_image[10], NULL);
            gnome_canvas_item_set(hm[7], IMAGE_NAME, suuji_image[10], NULL);
        }
    }
    stat[6] = lev;

    return;
}

static void
hm_set(gint connect, gint idle, gint if_show_connect, gint lev)
{
    static gint stat[] = { 0, 0, 1, 0 };
    
    if(connect != NONE) stat[0] = connect;
    if(idle != NONE) stat[1] = idle;
    if(if_show_connect != NONE) stat[2] = if_show_connect;
    if(lev == TOGGLE) lev = (stat[3] ? 0 : 1);
    if(lev != NONE) stat[3] = lev;
    
    if(stat[2])
        hm_set_sub(stat[0], stat[3]);
    else
        hm_set_sub(stat[1], stat[3]);

    return;
}

static void
start_stop_set_size (gint lev) /* 0:small 1:normal 2:big */
{
    static gint stat = 1;
    
    if (stat == lev)
        return;
    
    switch (lev) {
    case SIZE_SMALL:
        gnome_canvas_item_set (start, "points", start_small_points, NULL);
        gnome_canvas_item_set (stop, 
                               "x1", 31.5, "y1", 17.5,
                               "x2", 43.5, "y2", 28.5,
                               NULL);
        break;
        
    case SIZE_BIG:
        gnome_canvas_item_set (start, "points", start_big_points, NULL);
        gnome_canvas_item_set (stop, 
                               "x1", 30.5, "y1", 16.5,
                               "x2", 44.5, "y2", 29.5,
                               NULL);
        break;
    case SIZE_NORMAL:
    default:
        gnome_canvas_item_set (start, "points", start_points, NULL);
        gnome_canvas_item_set (stop, 
                               "x1", 31.0, "y1", 17.0,
                               "x2", 44.0, "y2", 29.0,
                               NULL);
        break;
        
    }

    stat = lev;
    
    return;
}

static void
start_stop_set(gint if_start, gint lev)
{
    static gint stat[] = { 1, 1 };
    
    if(if_start != NONE && if_start != stat[0]) {
        if(if_start) {
            gnome_canvas_item_show(start);
            gnome_canvas_item_hide(stop);
        } else {
            gnome_canvas_item_show(stop);
            gnome_canvas_item_hide(start);
        }
        stat[0] = if_start;
    }
    if(lev != NONE && lev != stat[1]) {
        if(lev == TOGGLE) lev = ((stat[1] == 1) ? 2 : 1);
        if(lev == ACTIVE_TOGGLE) lev = ((stat[1] == 1) ? 0 : 1);
        if(lev == 0) {
            gnome_canvas_item_set(start,
                                  "fill_color", NULL,
                                  "outline_color", NULL,
                                  NULL);
            gnome_canvas_item_set(stop,
                                  "fill_color", NULL,
                                  "outline_color", NULL,
                                  NULL);
        } else if(lev == 1) {
            gnome_canvas_item_set(start,
                                  "fill_color", "black",
                                  "outline_color", "black",
                                  NULL);
            gnome_canvas_item_set(stop,
                                  "fill_color", "black",
                                  "outline_color", "black",
                                  NULL);
        } else if(lev == 2) {
            gnome_canvas_item_set(start,
                                  "fill_color", "red",
                                  "outline_color", "red",
                                  NULL);
            gnome_canvas_item_set(stop,
                                  "fill_color", "red",
                                  "outline_color", "red",
                                  NULL);
        }
        stat[1] = lev;
    }

    return;
}

static void
auto_set_size (gint lev) /* 0:small 1:normal 2:big */
{
    static gint stat = 1;
    
    if (stat == lev)
        return;
    
    switch (lev) {
    case SIZE_SMALL: 
        gnome_canvas_item_set (auto_item,
                               "x", 30.5, "y", 10.5,
                               "width", 16.0, "height", 5.0,
                               NULL);
        break;
    
    case SIZE_BIG:
        gnome_canvas_item_set (auto_item,
                               "x", 29.5, "y", 9.5,
                               "width", 18.0, "height", 7.0,
                               NULL);
        break;

    case SIZE_NORMAL:
    default:        
        gnome_canvas_item_set (auto_item,
                               "x", 30.0, "y", 10.0,
                               "width", 17.0, "height", 6.0,
                               NULL);
        break;
        
    }
    
    stat = lev;

    return;
}

static void
auto_set(gint yn)
{
    static gint stat = 0;

    if (stat == yn) return;
    
    if(yn == 0)
        gnome_canvas_item_set(auto_item, IMAGE_NAME, auto_image, NULL);
    else
        gnome_canvas_item_set(auto_item, IMAGE_NAME, auto_image_a, NULL);
    
    stat = yn;

    return;
}

static void
stats_set(gint lev)
{
    static gint pstat[] = { 0, 0, 0, 0 };
    static gchar *colors[] = { "orange", "yellow", "green", "blue" };
    gint c;
    
    if( lev > 4 ) lev = 4;

    for(c = 0; c < lev; c++) {
        if(pstat[c] == 0) {
            gnome_canvas_item_set(stats[c],
                                  "fill_color", colors[c],
                                  "outline_color", colors[c],
                                  NULL);
            pstat[c] = 1;
        }
    }
    
    for(c = lev; c < 4; c++) {
        if(pstat[c] == 1) {
            gnome_canvas_item_set(stats[c],
                                  "fill_color", "gray",
                                  "outline_color", "gray",
                                  NULL);
            pstat[c] = 0;
        }
    }

    return;
}

static void
in_set(gint lev)
{
    static gint stat[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    gint c;
    
    if( lev > 12 ) lev = 12;
    if( lev < 0 ) lev = 0; 
    for(c = 0; c < lev; c++) {
        if(stat[c] == 0) {
            gnome_canvas_item_set(in[c],
                                  "fill_color","yellow",
                                  "outline_color","yellow",
                                  NULL);
            stat[c] = 1;
        }
    }
    for(c = lev; c < 12; c++) {
        if(stat[c] == 1) {
            gnome_canvas_item_set(in[c],
                                  "fill_color", "gray",
                                  "outline_color", "gray",
                                  NULL);
            stat[c] = 0;
        }
    }

    return;
}

static void
out_set(gint lev)
{
    static gint stat[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    gint c;
    
    if( lev > 12 ) lev = 12;
    if( lev < 0 ) lev = 0;
    for(c = 0; c < lev; c++) {
        if(stat[c] == 0) {
            gnome_canvas_item_set(out[c],
                                  "fill_color", "yellow",
                                  "outline_color", "yellow",
                                  NULL);
            stat[c] = 1;
        }
    }
    for(c = lev; c<  12; c++) {
        if(stat[c] == 1) {
            gnome_canvas_item_set(out[c],
                                  "fill_color", "gray",
                                  "outline_color", "gray",
                                  NULL);
            stat[c] = 0;
        }
    }

    return;
}

static gint
auto_event_cb(GnomeCanvasItem *item, GdkEvent *event, gpointer data)
{
    Ppxp *ppxp = (Ppxp *) data;
    static gboolean pointer_in = FALSE;
    static gboolean press = FALSE;
    GdkEventMask mask = GDK_BUTTON_RELEASE_MASK | GDK_LEAVE_NOTIFY_MASK;
  
    switch (event->type) {
    case GDK_BUTTON_PRESS:
        if (event->button.button != 1)
            break;
        gnome_canvas_item_grab (item, mask, NULL, event->button.time);
        press = TRUE;
        if (pointer_in)
            auto_set_size(SIZE_SMALL);
        else
            auto_set_size(SIZE_NORMAL);
        return TRUE;
    case GDK_BUTTON_RELEASE:
        if (event->button.button != 1 || !press)
            break;
        gnome_canvas_item_ungrab (item, event->button.time);
        press = FALSE;
        if (pointer_in) {
            auto_set_size(SIZE_BIG);
            ppxp_toggle_auto(ppxp);
        } else
            auto_set_size(SIZE_NORMAL);
      return TRUE;
      
    case GDK_ENTER_NOTIFY:
        pointer_in = TRUE;
        if (press)
            auto_set_size(SIZE_SMALL);
        else
            auto_set_size(SIZE_BIG);
        return TRUE;
        
    case GDK_LEAVE_NOTIFY:
        pointer_in = FALSE;
        auto_set_size(SIZE_NORMAL);
        return TRUE;
    default:
    }

    return FALSE;
}

static gint
start_stop_event_cb(GnomeCanvasItem *item, GdkEvent *event, gpointer data)
{
    Ppxp *ppxp = (Ppxp *) data;
    static gboolean pointer_in = FALSE;
    static gboolean press = FALSE;
    GdkEventMask mask = GDK_BUTTON_RELEASE_MASK | GDK_LEAVE_NOTIFY_MASK;
    
    switch (event->type) {
    case GDK_BUTTON_PRESS:
        if (event->button.button != 1)
            break;
        gnome_canvas_item_grab (item, mask, NULL, event->button.time);
        press = TRUE;
        if (pointer_in)
            start_stop_set_size(SIZE_SMALL);
        else
            start_stop_set_size(SIZE_NORMAL);
        return TRUE;
        
    case GDK_BUTTON_RELEASE:
        if (event->button.button != 1 || !press)
            break;
        gnome_canvas_item_ungrab (item, event->button.time);
        press = FALSE;
        if (pointer_in) {
            start_stop_set_size(SIZE_BIG);
            if (ppxp->stat)
                ppxp_disconnect (ppxp);
            else
                ppxp_connect (ppxp);
        } else
            start_stop_set_size(SIZE_NORMAL);
        return TRUE;
        
    case GDK_ENTER_NOTIFY:
        pointer_in = TRUE;
        if (press)
            start_stop_set_size(SIZE_SMALL);
        else
            start_stop_set_size(SIZE_BIG);
        return TRUE;
        
    case GDK_LEAVE_NOTIFY:
        pointer_in = FALSE;
        start_stop_set_size(SIZE_NORMAL);
        return TRUE;
    default:
    }
    
    return FALSE;
}

GtkWidget *
ui_make_widget(Ppxp *ppxp){
    GnomeCanvas *canvas;
    GnomeCanvasGroup *root;
    gint i;
    double t;
    gchar *tmpstr;

#ifdef DISABLE_GDK_PIXBUF
    gtk_widget_push_visual(gdk_imlib_get_visual());
    gtk_widget_push_colormap(gdk_imlib_get_colormap());
#endif /* DISABLE_GDK_PIXBUF */
#ifdef ENABLE_AA
    canvas = GNOME_CANVAS(gnome_canvas_new_aa());
#else
    canvas = GNOME_CANVAS(gnome_canvas_new());
#endif
#ifdef DISABLE_GDK_PIXBUF
    gtk_widget_pop_colormap();
    gtk_widget_pop_visual();
#endif /* DISABLE_GDK_PIXBUF */
    
    gnome_canvas_set_scroll_region (canvas, 0.0, 0.0, 48.0, 48.0);
    
#ifdef DISABLE_GDK_PIXBUF
    auto_image   = gdk_imlib_create_image_from_xpm_data(auto_xpm);
    tmpstr = auto_xpm[2]; auto_xpm[2] = "XX	c red";
    auto_image_a = gdk_imlib_create_image_from_xpm_data(auto_xpm);
    auto_xpm[2] = tmpstr;
    
    for(i = 0; i <= 10; i++) {
        suuji_image[i]   = gdk_imlib_create_image_from_xpm_data(suuji_xpm[i]);
        tmpstr = suuji_xpm[i][2]; suuji_xpm[i][2] = "xx	c red";
        suuji_image_a[i] = gdk_imlib_create_image_from_xpm_data(suuji_xpm[i]);
        suuji_xpm[i][2]  = tmpstr;
    }
#else  /* !DISABLE_GDK_PIXBUF */
    auto_image   = gdk_pixbuf_new_from_xpm_data ((const gchar **)auto_xpm);
    tmpstr = auto_xpm[2]; auto_xpm[2] = "XX	c red";
    auto_image_a = gdk_pixbuf_new_from_xpm_data ((const gchar **)auto_xpm);
    auto_xpm[2] = tmpstr;
    
    for(i = 0; i <= 10; i++) {
        suuji_image[i]  = gdk_pixbuf_new_from_xpm_data((const gchar **)suuji_xpm[i]);
        tmpstr = suuji_xpm[i][2]; suuji_xpm[i][2] = "xx	c red";
        suuji_image_a[i] = gdk_pixbuf_new_from_xpm_data((const gchar **)suuji_xpm[i]);
        suuji_xpm[i][2]  = tmpstr;
    }
#endif /* !DISABLE_GDK_PIXBUF */
    

    root = gnome_canvas_root(canvas);
    
    /* START */
    start_points = gnome_canvas_points_new(3);
    start_points->coords[0] = 32.0; start_points->coords[1] = 17.0;
    start_points->coords[2] = 45.0; start_points->coords[3] = 23.0;
    start_points->coords[4] = 32.0; start_points->coords[5] = 29.0;
    
    start_big_points = gnome_canvas_points_new(3);
    start_big_points->coords[0] = 31.0; start_big_points->coords[1] = 16.0;
    start_big_points->coords[2] = 46.0; start_big_points->coords[3] = 23.0;
    start_big_points->coords[4] = 31.0; start_big_points->coords[5] = 30.0;
    
    start_small_points = gnome_canvas_points_new(3);
    start_small_points->coords[0] = 33.0; start_small_points->coords[1] = 18.0;
    start_small_points->coords[2] = 44.0; start_small_points->coords[3] = 23.0;
    start_small_points->coords[4] = 33.0; start_small_points->coords[5] = 28.0;
    
    start = gnome_canvas_item_new(root, gnome_canvas_polygon_get_type(),
                                  "points", start_points,
                                  "fill_color", "black",
                                  "outline_color", "black",
                                  "width_units", 0.0,
                                  NULL);
    gnome_canvas_item_show(start);
    
    /* STOPܥ */
    stop = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                 "x1", 31.0, "y1", 17.0,
                                 "x2", 44.0, "y2", 29.0,
                                 "fill_color", "black",
                                 "outline_color", "black",
                                 "width_units", 0.0,
                                 NULL);
    gnome_canvas_item_hide(stop);
    
    start_stop_box = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                           "x1", 30.0, "y1", 16.0,
                                           "x2", 45.0, "y2", 30.0,
                                           "fill_color", NULL,
                                           "outline_color", NULL,
                                            "width_units", 0.0,
                                           NULL);
    gnome_canvas_item_show(start_stop_box);
    
    start_stop_set_size(SIZE_NORMAL);
    
    /* connectability */
    for(i = 0; i <= 3; i++) {
        stats[i] = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                         "x1", 3.0 + 6.0 * i, "y1", 16.0,
                                         "x2", 6.0 + 6.0 * i, "y2", 26.0,
                                         "fill_color", "gray",
                                         "outline_color", "gray",
                                         "width_units", 0.0,
                                         NULL);
        gnome_canvas_item_show(stats[i]);
    }
    
    /* meter */
    for(i = 0; i <= 11; i++) {
        double y1[] = { 6, 4, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        double y2[] = { 11, 9, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7 };

        /* out */
        out[i] = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                       "x1", 1.0 + 4.0 * i, "y1", y1[i],
                                       "x2", 2.0 + 4.0 * i, "y2", y2[i],
                                       "fill_color", "gray",
                                       "outline_color", "gray",
                                       "width_units", 0.0,
                                       NULL);
        gnome_canvas_item_show(out[i]);

        /* in */
        in[i] = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                      "x1", 45.0 - 4.0 * i, "y1", 47.0 - y2[i],
                                      "x2", 46.0 - 4.0 * i, "y2", 47.0 - y1[i],
                                      "fill_color", "gray",
                                      "outline_color", "gray",
                                      "width_units", 0.0,
                                      NULL);
        gnome_canvas_item_show(in[i]);
    }
    
    /* timer */
    /* hm[] = {h,h,m,m,s,s,:,:}; */
    t = 0.0;
    for(i = 0; i <= 5; i++) {
        double x_sa[] = { 2, 6, 7, 6, 7, 6 };

        t += x_sa[i];
        hm[i] = gnome_canvas_item_new(root, IMAGE_TYPE,
                                      "x", t, "y", 31.0,
                                      IMAGE_NAME, suuji_image[0],
                                      "width", 4.0, "height", 7.0,
                                      ANCHOR_SETTING
                                      WIDTH_HEIGHT_SET
                                      NULL);
        gnome_canvas_item_show(hm[i]);
    }
    /*  */
    hm[6] = gnome_canvas_item_new(root, IMAGE_TYPE,
                                  "x", 13.0, "y", 31.0,
                                  IMAGE_NAME, suuji_image[10],
                                  "width", 1.0, "height", 7.0,
                                  ANCHOR_SETTING
                                  WIDTH_HEIGHT_SET
                                  NULL);
    gnome_canvas_item_show(hm[6]);
    hm[7] = gnome_canvas_item_new(root, IMAGE_TYPE,
                                  "x", 26.0, "y", 31.0,
                                  IMAGE_NAME, suuji_image[10],
                                  "width", 1.0, "height", 7.0,
                                  ANCHOR_SETTING
                                  WIDTH_HEIGHT_SET
                                  NULL);
    gnome_canvas_item_show(hm[7]);
    
    /* AUTOܥ */
    auto_item = gnome_canvas_item_new(root, IMAGE_TYPE,
                                      IMAGE_NAME, auto_image,
                                      "x", 30.0, "y", 10.0,
                                      "width", 17.0, "height", 6.0,
                                      ANCHOR_SETTING
                                      WIDTH_HEIGHT_SET
                                      NULL);
    gnome_canvas_item_show(auto_item);
    
    auto_box_item = gnome_canvas_item_new(root, gnome_canvas_rect_get_type(),
                                          "x1", 29.0, "y1", 9.0,
                                          "x2", 48.0, "y2", 17.0,
                                          "fill_color", NULL,
                                          "outline_color", NULL,
                                          "width_units", 0.0,
                                          NULL);
    gnome_canvas_item_show(auto_box_item);
    
    auto_set_size(SIZE_NORMAL);
    
    gtk_signal_connect(GTK_OBJECT(start_stop_box),"event",
                       GTK_SIGNAL_FUNC(start_stop_event_cb), ppxp);
    gtk_signal_connect(GTK_OBJECT(auto_box_item),"event",
                       GTK_SIGNAL_FUNC(auto_event_cb), ppxp);
    
    gtk_widget_show(GTK_WIDGET(canvas));
    
    widget = GTK_WIDGET(canvas);
    
    return GTK_WIDGET(canvas);
}
