#!/bin/bash
#
# convert powersave configuration files from version < 0.15
# to 0.15 or greater. All privileges are now handled by PolicyKit
#
# variables:
#     DISABLE_USER_SUSPEND_TO_DISK
#     DISABLE_USER_SUSPEND_TO_RAM
#     DISABLE_USER_STANDBY
#

PS_CONF=/etc/powersave
POLKIT_CONF=/etc/PolicyKit/privilege.d

if [ ! -e $PS_CONF/common ]; then
    # nothing to do...
    exit 0
fi

if [ ! -e $PS_CONF/sleep ]; then
    # nothing to do...
    exit 0
fi

MSG="#\n# This setting has been moved to PolicyKit below /etc/PolicyKit/privilege.d/"

. $PS_CONF/sleep

if [ "$DISABLE_USER_SUSPEND2DISK" = "yes" ]; then
    echo "Disabled suspend to disk for users in PolicyKit"
    sed -e 's/Allow=uid:__all__/Allow=uid:root/' -i $POLKIT_CONF/hal-power-hibernate.privilege
    sed -e "s:DISABLE_USER_SUSPEND2DISK:$MSG\n#DISABLE_USER_SUSPEND2DISK:" -i $PS_CONF/sleep
fi

if [ "$DISABLE_USER_SUSPEND2RAM" = "yes" ]; then
    echo "Disabled suspend to ram for users in PolicyKit"
    sed -e 's/Allow=uid:__all__/Allow=uid:root/' -i $POLKIT_CONF/hal-power-suspend.privilege
    sed -e "s:DISABLE_USER_SUSPEND2RAM:$MSG\n#DISABLE_USER_SUSPEND2RAM:" -i $PS_CONF/sleep
fi

if [ "$DISABLE_USER_STANDBY" = "yes" ]; then
    echo "Disabled standby to disk for users in PolicyKit"
    sed -e 's/Allow=uid:__all__/Allow=uid:root/' -i $POLKIT_CONF/hal-power-standby.privilege
    sed -e "s:DISABLE_USER_STANDBY:$MSG\n#DISABLE_USER_STANDBY:" -i $PS_CONF/sleep
fi
