/*
ClientFileBrowser.h
*/

#ifndef __CLIENTFILEBROWSER_H
#define __CLIENTFILEBROWSER_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <values.h>
       
#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"

#define NEWDIRSMODE  0770

typedef struct 
  {
  TFileName FileName;
  xulong size;
  time_t stmtime;
  int type; //DIR, NORMAL FILE, etc.
  bool Cortado, Copiado; 
  } XFile, *PXFile;    
typedef XVector<XFile> FileList;

typedef struct 
  {
  TBuffer DiskName, Label, mount_dir, umount_cmd, restricted_dir, mount_cmd;
  bool mounted;
  long quota, diskusage;
  } XDisk, *PXDisk;    
typedef XVector<XDisk> DiskList;

void CFB_FlipEntries (const void *e1, const void *e2);
int CFB_CompareEntriesByFileName  (const void *e1, const void *e2);
int CFB_CompareEntriesByFileNameCS (const void *e1, const void *e2);
int CFB_CompareEntriesByFileSize  (const void *e1, const void *e2);
int CFB_CompareEntriesByFileDate  (const void *e1, const void *e2);

class ClientFileBrowser
  {
  private:
    TBuffer RestrictedPath, CurrentFullDir, CurrentRelDir, ErrorMsg;
    long DiskUsage, QUOTA;
    int CurrentDisk;
    const char *getExtension (const char *afile, TBuffer extension);
    bool isFullDirectory (const char *adirname);
  public:
    FileList FLAllFiles;                   
    ClientFileBrowser (int aCurrentDisk, const char *aRestrictedPath, long aDiskUsage, long aQUOTA);
    virtual ~ClientFileBrowser ();
    void init (int aCurrentDisk, const char *aRestrictedPath, long aDiskUsage, long aQUOTA);
    bool isCorrectFullDir (const char *apath);
    const char *getCurrentFullDir (void);
    const char *getCurrentRelDir (void);
    const char *getErrorMsg (void);
    char *escape_input (const char *source, TBuffer dest);
    char *unescape_input (const char *source, TBuffer dest);    
    const char *obtainOldCurrentRelDir (void);    
    const char *obtainRelDir (const char *FullDir, TBuffer reldir);
    bool obtainFullName (const char *afile, TBuffer fullfilename);    
    bool isEditableFile (const char *afile);
    int getCurrentDisk (void);
    void setCurrentDisk (int aCurrentDisk);
    bool setCurrentRelDir (const char *aCurrentRelDir);    
    bool obtainFileList (void);

    bool changeAbsDir (const char *newdir);
    bool changeRelDir (const char *newdir);
    bool CwdUp (void);
    bool CwdNonRelative (const char *anewdir);
    bool Cwd (const char *newdir);
    const char *getFileDate (time_t *tt, TBuffer abuf);
    const char *getFilenameFromFullFilename (const char *fullname, TBuffer filename);          
    bool dumpFile (const char *afile, char *fullfilename, char *CT);
    bool saveFile (const char *afilename, const char *filetext);
    bool makeDir (const char *adirname);
    bool makeFile (const char *afilename);
    bool deleteItems (StringList *SLMulti, int *itemsdeleted);
    bool rmFullDir (const char *adirname, int *itemsdeleted);
    bool listFullDir (const char *adirname, StringList *SLFileList);
    bool cpFullDir (const char *src_dirname, const char *dest_dirname);
    bool isDirectory (const char *adirname);
    bool pasteItems (StringList *SLPapeleraCopy, StringList *SLPapeleraCut);
    const char *FormatCountBytes (long count, TBuffer abuf);    
    void parseIncrementalPath (const char *adir, StringList *SL, StringList *SLInc);
    bool renameItems (const char *oldfilename, const char *newfilename);
    bool sortName (void);       
    bool sortDate (void);
    bool sortSize (void);
    long getDiskUsage (void);
    void addDiskUsage (long morebytes);
    void delDiskUsage (long lessbytes);
    float getPercQuotaUsage (void);
    long getQuota (void);
  };

#endif

