
#ifndef __RUTINAS_DB_H
#define __RUTINAS_DB_H

/* 
* Para compilar en el POSTAL:
*   -ldb -I/usr/local/include/db -lsec
*
*  en el POST:
*   -lsec
*
*/       

#ifdef __cplusplus
  extern "C" {
#endif  

#include <pwd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>
#include <crypt.h>
#include <unistd.h>
#include <syslog.h>
#include <stdlib.h>
       
#define XLOGFACILITY LOG_MAIL
#define XLOGOPTIONS  LOG_PID
#define XLOGPRIORITY LOG_INFO

#define XBUFSIZE 300

#if defined(HP)
#include <hpsecurity.h>
#include <prot.h>
#include <db.h>
#elif defined(LINUX)
#include <db1/db.h>           
//#include <db_185.h>           
#elif defined(SUN)
#include <db_185.h>           
#endif

#define MAXDATUM  256  /* maxima longitud e una entrada passwd en DB */
#define MAXUSUNOM  20  /* maxima longitud de nombre de usuario */
#define MAXCAM     10  /* maximo numero de campos en la DB */
#define isdebug     0

struct passwd *sm_getpwnam(char *dbfile, char *user);
int verify_user_POST (char *user, char *pass);
int verify_user_POSTAL (char *dbfile, char *user, char *pass);
int exist_user_POSTAL (char *dbfile, char *user);
int exist_user (char *dbfile, char *user);
void db_get_data_from_user (char *dbfile, char *user, char *imapserver, int *imapport, char *smtpserver, char *maildomain, char *trueemail);
      
#ifdef __cplusplus
  }
#endif
   
#endif
   


