/*
 * ratStdFolder.h --
 *
 *      Declarations of functions used in the Std folder and messages
 *
 * TkRat software and its included text is Copyright 1996,1997,1998
 * by Martin Forssn
 *
 * Postilion software and its included text and images
 * Copyright (C) 1998 Nic Bernstein
 *
 * The full text of the legal notices is contained in the files called
 * COPYING and COPYRIGHT.TkRat, included with this distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _RATSTDFOLDER
#define _RATSTDFOLDER

#include "ratFolder.h"

/*
 * This list correlates to the ratStdTypeNames array in ratStdFolder.c
 */
typedef enum {RAT_BERKELY, RAT_IMAP, RAT_POP, RAT_MH} RatStdFolderType;

RatGetHeadersProc Std_GetHeadersProc;
RatGetEnvelopeProc Std_GetEnvelopeProc;
RatCreateBodyProc Std_CreateBodyProc;
RatFetchTextProc Std_FetchTextProc;
RatEnvelopeProc Std_EnvelopeProc;
RatSetIndexProc Std_SetIndexProc;
RatMsgDeleteProc Std_MsgDeleteProc;
RatMakeChildrenProc Std_MakeChildrenProc;
RatFetchBodyProc Std_FetchBodyProc;
RatBodyDeleteProc Std_BodyDeleteProc;
RatInfoProc Std_GetInfoProc;

/* ratStdMessage.c */
extern char *RatStdMessageCreate (Tcl_Interp *interp, RatFolderInfoPtr infoPtr,
	MAILSTREAM *stream, int msgNo, RatStdFolderType type, char *host,
	char *user);

#endif /* _RATSTDFOLDER */
