/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxedit-ui-polseq-prop.h"
#include "polyxedit-ui-seqed-wnd.h"


GtkWidget *
polyxedit_ui_polseq_prop_setup_wnd (PxmEditCtxt *editctxt)
{
  GtkWidget *window = NULL;
  GtkWidget *widget = NULL;


  PxmPolchemdefCtxt *polchemdefctxt = NULL;
  PxmPolymer *polymer = NULL;
  
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  gchar *help = NULL;




  g_assert (editctxt != NULL);

  polymer = editctxt->polymer;
  g_assert (polymer != NULL);
  
  polchemdefctxt = editctxt->polchemdefctxt;
  g_assert (polchemdefctxt != NULL);
  

  gui_file = 
    g_strdup_printf ("%s/polyxedit-sequence-prop.glade", 
		     userspec->gladedir);
  
  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "polymer_sequence_properties_wnd", 
		       PACKAGE);

  g_free (gui_file);
  
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "polymer_sequence_properties_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to create the polymer sequence "
		    "properties definition window\n"),
	     __FILE__, __LINE__);

      g_object_unref (G_OBJECT (xml));

      return NULL;
    }


  /* Immediately set to the window a pointer to the editctxt:
   */
  g_object_set_data (G_OBJECT (window), "editctxt", editctxt);


  /* We may need to tell something to the user, which will be 
     written here:
  */
  widget = glade_xml_get_widget (xml, "messages_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "messages_entry",
		     widget);


  /* Immediately set the type of the polymer chemistry definition
     to its entry:
  */
  widget = glade_xml_get_widget (xml, "polchemdef_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polchemdef_entry",
		     widget);

  g_assert (polchemdefctxt->polchemdef != NULL);
  g_assert (polchemdefctxt->polchemdef->type != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polchemdefctxt->polchemdef->type);
  
  /* And now fill-in the polymer sequence details.
   */
  g_assert (polymer->plminfo != NULL);

  /* The name of the polymer sequence.
   */
  widget = glade_xml_get_widget (xml, "polseq_name_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polseq_name_entry",
		     widget); 

  g_assert (polymer->plminfo->name != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->name);
  
  /* The code of the polymer sequence.
   */
  widget = glade_xml_get_widget (xml, "polseq_code_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polseq_code_entry",
		     widget); 

  g_assert (polymer->plminfo->code != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->code);
  
  /* The author of the polymer sequence.
   */
  widget = glade_xml_get_widget (xml, "polseq_author_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polseq_author_entry",
		     widget); 

  g_assert (polymer->plminfo->author != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->author);

  
  /* The date of last modification.
   */
  widget = glade_xml_get_widget (xml, "last_modif_year_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "last_modif_year_entry",
		     widget); 

  g_assert (polymer->plminfo->date_year != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->date_year);
  
  widget = glade_xml_get_widget (xml, "last_modif_month_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "last_modif_month_entry",
		     widget); 

  g_assert (polymer->plminfo->date_month != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->date_month);
  
  widget = glade_xml_get_widget (xml, "last_modif_day_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "last_modif_day_entry",
		     widget); 

  g_assert (polymer->plminfo->date_day != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      polymer->plminfo->date_day);
  
  widget = glade_xml_get_widget (xml, "validate_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "validate_button",
		     widget);  

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxedit_ui_polseq_prop_validate_button), 
		    window);

  /*
  widget = glade_xml_get_widget (xml, "");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "",
		     widget);  
  */


  gtk_widget_show_all (GTK_WIDGET (window));
  
  /* We have finished setting up the window, and so also using
   * the xml data, unref them
   */
  g_object_unref (G_OBJECT (xml));



  /* The signal of the window itself.
   */
  /* Signal / callback connections.
   */
  g_signal_connect 
    (G_OBJECT (window),
     "delete_event",
     G_CALLBACK (polyxedit_ui_polseq_prop_wnd_delete_event), 
     editctxt);

  g_signal_connect 
    (G_OBJECT (window),
     "destroy_event",
     G_CALLBACK (polyxedit_ui_polseq_prop_wnd_destroy_event), 
     editctxt);

  /* Set this window pointer as a full datum to the polymer sequence
     editor window, so that when it is closed this window is closed
     also. 

     There might be more than one monomer modification window opened
     for a given polymer seqence editing window, and we do not want
     that the second window destroys the datum name of the first
     window, so we create an uambiguous datum name each time.
  */
  help = g_strdup_printf ("polseq_prop_wnd-%p", window);
  
  g_object_set_data_full 
    (G_OBJECT (editctxt->sequence_editor_wnd),
     help, GTK_WIDGET (window), 
     (GDestroyNotify) polyxedit_ui_polseq_prop_wnd_really_close);
  
  g_free (help);
 

  return window;
}



void
polyxedit_ui_polseq_prop_validate_button (GtkWidget *button,
					  gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *widget = NULL;

  PxmEditCtxt *editctxt = NULL;
  PxmPolymer *polymer = NULL;

  gchar *help = NULL;
  

  g_assert (window != NULL);
  
  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  polymer = editctxt->polymer;
  g_assert (polymer != NULL);

  /* We are asked to update the values for the name and code.
   */
  

  /* The name.
   */
  widget = g_object_get_data (G_OBJECT (window), "polseq_name_entry");
  g_assert (widget != NULL);

  help = (gchar *) gtk_entry_get_text (GTK_ENTRY (widget));
  g_assert (help != NULL);
  
  g_assert (TRUE == 
	    pxmchem_polymer_plminfo_set_name (polymer->plminfo, help));

  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);
    
  
  /* The code.
   */
  widget = g_object_get_data (G_OBJECT (window), "polseq_code_entry");
  g_assert (widget != NULL);

  help = (gchar *) gtk_entry_get_text (GTK_ENTRY (widget));
  g_assert (help != NULL);
  
  g_assert (TRUE == 
	    pxmchem_polymer_plminfo_set_code (polymer->plminfo, help));
  
  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);

  /* Ask that the data be updated in the polymer sequence editor
     window's widgets !
   */
  polyxedit_seqed_wnd_update_polseq_prop (editctxt);
  

  polyxmass_timeoutmsg_message_set
    ((GtkWindow *) window,
     _("All data were set correctly."),
     POLYXMASS_NORM_MSG_TIMEOUT);
}



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_ui_polseq_prop_wnd_really_close (GtkWidget *window)
{
  gint count = 0;

  
  g_assert (window != NULL);
  

  /* 
     Prior to closing the window, we want to make sure that no
     pending timed-out messages are there...
  */
  count = polyxmass_timeoutmsg_messages_remove ((GtkWindow *) window);
  
  gtk_widget_destroy (window);
}


gboolean
polyxedit_ui_polseq_prop_wnd_delete_event (GtkWidget *window, 
					     GdkEventAny *event, 
					     gpointer data)
{
  PxmEditCtxt *editctxt = data;
  
  gchar *help = NULL;
  

  g_assert (window != NULL);
  g_assert (editctxt != NULL);
  

  help = g_strdup_printf ("polseq_prop_wnd-%p", window);


  /* We set the datum to NULL, then the GDestroyNotify callback that
     was specified when the datum was set first (that is
     xxx_wnd_really_close () function above) will be called, thus
     destroying *this window, which is exactly what we want !
  */
  g_object_set_data (G_OBJECT
		     (editctxt->sequence_editor_wnd), 
		     help, NULL);
  g_free (help);
    
  return TRUE;
}


gboolean
polyxedit_ui_polseq_prop_wnd_destroy_event (GtkWidget *window, 
					    GdkEventAny *event, 
					    gpointer data)
{
  return FALSE;
}
