/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_ACIDOBASIC_H
#define LIBPOLYXMASS_ACIDOBASIC_H

#include "libpolyxmass-globals.h"
#include "pxmchem-monomer.h"
#include "pxmchem-modif.h"
#include "libpolyxmass-prop.h"



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  



PxmMonomer *
libpolyxmass_acidobasic_render_xml_node_mnm (xmlDocPtr xml_doc,
					     xmlNodePtr xml_node,
					     gpointer data);
  

gboolean
libpolyxmass_acidobasic_render_xml_node_monomers (xmlDocPtr xml_doc,
						  xmlNodePtr xml_node,
						  GPtrArray *mnmGPA,
						  gpointer data);
  


PxmModif *
libpolyxmass_acidobasic_render_xml_node_mdf (xmlDocPtr xml_doc,
					     xmlNodePtr xml_node,
					     gpointer data);
  
gboolean
libpolyxmass_acidobasic_render_xml_node_modifs (xmlDocPtr xml_doc,
						xmlNodePtr xml_node,
						GPtrArray *mdfGPA,
						gpointer data);
  
gboolean
libpolyxmass_acidobasic_render_xml_file (gchar *file,
					 GPtrArray *mnmGPA,
					 GPtrArray *mdfGPA,
					 gpointer data);

gdouble
libpolyxmass_acidobasic_calculate_charge_ratio (gdouble pka,
					      gdouble ph,
					      gboolean acidcharged);
  



  
  
  
  
  
#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* LIBPOLYXMASS_ACIDOBASIC_H */

