/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-calculations-opt.h"
#include "polyxedit-ui-masses-display-wnd.h"


GtkWidget *
polyxedit_calculations_opt_wnd_setup (PxmEditCtxt *editctxt)
{
  GtkWidget *window = NULL;
  GtkWidget *widget = NULL;

  PxmProp *prop = NULL;
  
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  gchar *help = NULL;
  
  
  g_assert (editctxt != NULL);
  

  /* This window may exist already, and the user may ask that it be
     displayed if it is hidden. So we ask for it in the prop list of
     the editctxt.  Remember that the editctxt has a PxmCalcOpt
     structure where we read the data to display here at first, and
     next use the widgets in *this window to set the data in.
  */
  prop = libpolyxmass_prop_find_prop (editctxt->propGPA,
				  NULL,
				  NULL,
				  "CALCULATIONS_OPT_WND",
				  NULL,
				  PXM_UNDEF_PROP_CMP);
  if (prop != NULL)
    {
      /* The window exists already, we just display it on top of
	 parent.
       */
      window = (GtkWidget *) prop->data;
      g_assert (window != NULL);

      gdk_window_show (window->window);
      
      return window;
    }
  
  /* The window did not exist already, which means that we have to go
     through all the creation steps.
  */
  gui_file = 
    g_strdup_printf ("%s/polyxedit-calculations-opt.glade", 
		     userspec->gladedir);
  
  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "calculations_options_wnd", 
		       PACKAGE);
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed loading the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "calculations_options_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed creating the calc mass options window\n"),
	     __FILE__, __LINE__);

      g_object_unref (G_OBJECT (xml));

      return NULL;
    }

  /* Immediately set to the window a pointer to the editctxt:
   */
  g_object_set_data (G_OBJECT (window), "editctxt", editctxt);


  /* Set the polymer sequence name to its correspondent GtkEntry.
   */
  widget = 
    glade_xml_get_widget (xml, "calculations_options_polseq_name_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "calculations_options_polseq_name_entry", widget);
  
  if (editctxt->polymer->plminfo->name != NULL)
    gtk_entry_set_text (GTK_ENTRY (widget), 
			editctxt->polymer->plminfo->name);
  else 
    gtk_entry_set_text (GTK_ENTRY (widget), _("Not set"));

  /* Set the polymer sequence context id number (its pointer) to its
     correspondent GtkEntry.
   */
  widget = 
    glade_xml_get_widget (xml, 
			  "calculations_options_polseq_id_number_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "calculations_options_polseq_id_number_entry",
                     widget);

  /* Set the polymer id number (the pointer to editctxt to the
     relative entry).
   */
  help = g_strdup_printf ("%p", editctxt);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);




  /* POLYMER CAPS-ACCOUNTING.
   */
  /* LEFT cap.
   */
  widget = glade_xml_get_widget (xml, 
				 "left_capped_polymer_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "left_capped_polymer_checkbutton",
                     widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_calculations_opt_checkbutton_toggled),
     editctxt);

  /* Set the checkbutton state to current value.
   */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				editctxt->calcopt->capping &
				PXM_CAPPING_LEFT);
  

  /* RIGHTT cap.
   */
  widget = glade_xml_get_widget (xml, 
				 "right_capped_polymer_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "right_capped_polymer_checkbutton",
                     widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_calculations_opt_checkbutton_toggled),
     editctxt);

  /* Set the checkbutton state to current value.
   */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				editctxt->calcopt->capping &
				PXM_CAPPING_RIGHT);

  

  /* ACCOUNTING OF THE POLYMER END MODIFICATIONS.
   */
  /* LEFT end.
   */
  widget = glade_xml_get_widget (xml, 
				 "account_left_end_modif_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "account_left_end_modif_checkbutton",
                     widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_calculations_opt_checkbutton_toggled),
     editctxt);

  /* Set the checkbutton state to current value.
   */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				editctxt->calcopt->plm_chement &
				PXMCHEMENT_PLM_LEFT_MODIF);


  /* RIGHT end.
   */
  widget = glade_xml_get_widget (xml, 
				 "account_right_end_modif_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "account_right_end_modif_checkbutton",
                     widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_calculations_opt_checkbutton_toggled),
     editctxt);

  /* Set the checkbutton state to current value.
   */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				editctxt->calcopt->plm_chement &
				PXMCHEMENT_PLM_RIGHT_MODIF);


  /* ACCOUNT MODIF in the monomers.
   */
  widget = glade_xml_get_widget (xml, 
				 "account_monomer_modifs_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "account_monomer_modifs_checkbutton",
                     widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_calculations_opt_checkbutton_toggled),
     editctxt);
  
  /* Set the checkbutton state to current value.
   */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				editctxt->calcopt->mnm_chement);

  /********* IONIZERULE *************************************************/
  widget = 
    glade_xml_get_widget (xml, 
			  "calculations_options_ionizerule_actform_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "calculations_options_ionizerule_actform_entry",
		     widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "activate",
     G_CALLBACK (polyxedit_calculations_opt_ionizerule_activate_entry), 
     window);
  /* Set the current value to the entry.
   */
  if (editctxt->ionizerule->actform != NULL)
    gtk_entry_set_text (GTK_ENTRY (widget), editctxt->ionizerule->actform);
  
  widget = 
    glade_xml_get_widget (xml, 
			  "calculations_options_ionizerule_charge_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "calculations_options_ionizerule_charge_entry",
                     widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "activate",
     G_CALLBACK (polyxedit_calculations_opt_ionizerule_activate_entry), 
     window);
  /* Set the current value to the entry.
   */
  help = g_strdup_printf ("%d", editctxt->ionizerule->charge);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  widget = 
    glade_xml_get_widget (xml, 
			  "calculations_options_ionizerule_level_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "calculations_options_ionizerule_level_entry",
                     widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "activate",
     G_CALLBACK (polyxedit_calculations_opt_ionizerule_activate_entry), 
     window);
  /* Set the current value to the entry.
   */
  help = g_strdup_printf ("%d", editctxt->ionizerule->level);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);



  /* So that *this window is displayed on top of the polymer sequence
     editor, for the editctxt of which it was opened. That does not
     interfere with the prop system that we devised to make *this
     window closed when the related polymer sequence context's editor
     window is closed.
  */
  gtk_window_set_transient_for (GTK_WINDOW (window),
				GTK_WINDOW (editctxt->
					    seqeditorctxt->
					    sequence_editor_wnd));
  
  gtk_widget_show_all (window);
  
  /* We have finished setting up the window, and so also using
   * the xml data, unref them
   */
  g_object_unref (G_OBJECT (xml));


  /* Signal / callback connections.
   */
  g_signal_connect 
    (G_OBJECT (window),
     "delete_event",
     G_CALLBACK (polyxedit_calculations_opt_wnd_delete_event), 
     editctxt);
  
  /* Now that we have terminated the construction of the window,
     we must create a prop object into which we store the pointer to 
     this window. We add this prop object to the editctxt's propGPA.
  */
  prop = libpolyxmass_prop_new ();
  
  libpolyxmass_prop_set_name (prop, "CALCULATIONS_OPT_WND");
  
  prop->data = (gpointer) window;
  
  /* And now set the freeing function pointer, so that if the editctxt
     comes to be freed, and this window still exists (which is this
     prop is still in the polseqctx->propGPA), we have an automatic
     destruction of *this widget.
  */
  prop->custom_free = polyxmass_globals_gtk_window_prop_free;
  
  g_ptr_array_add (editctxt->propGPA, prop);
  
  return window;
}



void 
polyxedit_calculations_opt_checkbutton_toggled (GtkWidget *widget,
					    gpointer data)
{
  PxmEditCtxt *editctxt = data;
   
  gboolean active = FALSE;
  
  gchar *name = NULL;
  
  g_assert (widget != NULL);
  
  name = (gchar *) gtk_widget_get_name (widget);
  
  /* Depending on the widget that was toggled, we just update the
     corresponding value in the calcopt structure that belongs to the
     editctxt to which we got a pointer in 'data'.
  */
  active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));

  if (0 == strcmp ("left_capped_polymer_checkbutton", name))
    {
      if (active == TRUE)
	{
	  editctxt->calcopt->capping |= PXM_CAPPING_LEFT;
	}
      else
	{
	  editctxt->calcopt->capping ^= PXM_CAPPING_LEFT;
	}
    }
  
  else if (0 == strcmp ("right_capped_polymer_checkbutton", name))
    {
      if (active == TRUE)
	{
	  editctxt->calcopt->capping |= PXM_CAPPING_RIGHT;
	}
      else
	{
	  editctxt->calcopt->capping ^= PXM_CAPPING_RIGHT;
	}
    }
  
  else if (0 == strcmp ("account_left_end_modif_checkbutton", name))
    {
      if (active == TRUE)
	{
	  editctxt->calcopt->plm_chement |= PXMCHEMENT_PLM_LEFT_MODIF;
	}
      else
	{
	  editctxt->calcopt->plm_chement ^= PXMCHEMENT_PLM_LEFT_MODIF;
	}
    }
  
  else if (0 == strcmp ("account_right_end_modif_checkbutton", name))
    {
      if (active == TRUE)
	{
	  editctxt->calcopt->plm_chement |= PXMCHEMENT_PLM_RIGHT_MODIF;
	}
      else
	{
	  editctxt->calcopt->plm_chement ^= PXMCHEMENT_PLM_RIGHT_MODIF;
	}
    }

  else if (0 == strcmp ("account_monomer_modifs_checkbutton", name))
    {
      if (active == TRUE)
	{
	  editctxt->calcopt->mnm_chement = PXMCHEMENT_MNM_MODIF;
	}
      else
	{
	  editctxt->calcopt->mnm_chement = PXMCHEMENT_MNM_NONE;
	}
    }

  else;
  


  /* Now that the new settings have been made into the
     editctxt->calcopt structure, we have to ask that the masses be
     recalculated. Also, do not forget to update the editctxt's data
     because the user may be configuring the way masses are computed
     for a polymer sequence that is not currently focused.
  */
  polyxedit_ui_masses_display_wnd_update_sequence_data (editctxt);
  polyxedit_ui_masses_display_wnd_update_sequence_masses (editctxt);
  polyxedit_ui_masses_display_wnd_update_selection_masses (editctxt);
  
  return; 
}


void
polyxedit_calculations_opt_ionizerule_activate_entry (GtkWidget *widget,
						      gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *entry = NULL;
  
  PxmEditCtxt *editctxt = NULL;
   
  GPtrArray *atomGPA = NULL;
  
  gint level = 0;
  gint charge = 0;
  
  gchar *help = NULL;
  
  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);
  
  atomGPA = editctxt->polchemdefctxt->polchemdef->atomGPA;
  g_assert (atomGPA != NULL);
  
  
  /* We are updating the way the ionization should be performed. All
     the the ionization GtkEntry 's should be updated, as the user may
     modify the content of one or two without <Enter> and then <Enter>
     only for the last.
  */
  entry = 
    g_object_get_data (G_OBJECT (window),
		       "calculations_options_ionizerule_actform_entry");
  
  g_assert (entry != NULL);
  
  help = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
  g_assert (help != NULL);
  
  if (FALSE == pxmchem_actform_check (help, atomGPA))
    {
      g_warning (_("%s@%d: actform is not valid: '%s'\n"),
		 __FILE__, __LINE__, help);
      
      g_free (help);
      
      return;
    }
  
  /* At this point the actform is valid, so we can set it to
     the ionizerule instance.
  */
  pxmchem_ionizerule_set_actform (editctxt->ionizerule, help);
  
  g_free (help);
  

  entry = 
    g_object_get_data (G_OBJECT (window),
		       "calculations_options_ionizerule_charge_entry");
  
  g_assert (entry != NULL);
  
  help = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
  g_assert (help != NULL);
  
  if (FALSE == libpolyxmass_globals_strtoi (help, &charge, 10))
    {
      g_warning (_("%s@%d: charge failed to convert to integer: '%s'\n"),
		 __FILE__, __LINE__, help);
      
      g_free (help);
      
      return;
    }
  
  editctxt->ionizerule->charge = charge;
    

  entry = 
    g_object_get_data (G_OBJECT (window),
		       "calculations_options_ionizerule_level_entry");

  help = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
  g_assert (help != NULL);
  
  if (FALSE == libpolyxmass_globals_strtoi (help, &level, 10))
    {
      g_warning (_("%s@%d: level failed to convert to integer: '%s'\n"),
		 __FILE__, __LINE__, help);
      
      g_free (help);
      
      return;
    }
  
  editctxt->ionizerule->level = level;
  

  /*
  debug_printf (("ionizerule is: actform %s - charge %d - level %d\n",
		 editctxt->ionizerule->actform,
		 editctxt->ionizerule->charge,
		 editctxt->ionizerule->level));
  */


  /* Now that the new settings have been made into the
     editctxt->calcopt structure, we have to ask that the masses be
     recalculated.
  */
  /* Now that the new settings have been made into the
     editctxt->calcopt structure, we have to ask that the masses be
     recalculated.
  */
  /* Now that the new settings have been made into the
     editctxt->calcopt structure, we have to ask that the masses be
     recalculated. Also, do not forget to update the editctxt's data
     because the user may be configuring the way masses are computed
     for a polymer sequence that is not currently focused.
  */
  polyxedit_ui_masses_display_wnd_update_sequence_data (editctxt);
  polyxedit_ui_masses_display_wnd_update_sequence_masses (editctxt);
  polyxedit_ui_masses_display_wnd_update_selection_masses (editctxt);
  
  return;
}




gint 
polyxedit_calculations_opt_wnd_delete_event (GtkWidget *window, 
					 GdkEventAny *event, 
					 gpointer data)
{
  PxmEditCtxt *editctxt = data;
  PxmProp *prop = NULL;
  
  g_assert (editctxt != NULL);
  

  /* BECAUSE this window still exists, it must be referenced in the
     editctxt->propGPA under the form of a prop instance named
     "CALCULATIONS_OPT_WND". We search this prop, because we'll have to 
     remove it from the propGPA, and free it (which will automatically
     destroy *this window, since we set the custom->free function
     to point to gtk_widget_destroy ().
  */
  prop = libpolyxmass_prop_find_prop (editctxt->propGPA,
				  NULL,
				  NULL,
				  "CALCULATIONS_OPT_WND",
				  NULL,
				  PXM_UNDEF_PROP_CMP);
  g_assert (prop != NULL);
  
  g_assert (FALSE != g_ptr_array_remove (editctxt->propGPA, prop));
  
  libpolyxmass_prop_free (prop); /* Will automagically destroy *this. */
  
  return TRUE;
}
